<?php
session_start();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

include './load.php';
include './templates/header.php';

include './app/models/Projects.php';
include './app/models/Products.php';
include './app/models/Settings.php';

if (!isSeller()) {
    header("Location: index.php");
    exit();
}

$uid = $_SESSION["user_id"];

$projects = new Projects();
$productModel = new Products();
$settings = new Settings();
// echo json_encode($messages);

if (isset($_GET["update-list-of-products"])) {
    // $products = $_GET["products"];

    $product_name = '';
    if (isset($_GET["product_name"]) && is_array($_GET["product_name"])) {
        $product_name = implode(",", $_GET["product_name"]);
    }

    if (!empty($product_name)) {
        $res = $productModel->updateListOfProducts($uid, $product_name);

        $country = $_SESSION["userData"]["country"];

        $result = $projects->getProjectsByDate($product_name, $country);

        if ($result) {
            $sellerName = 'one of the register buyer who is';
            if ($settings->get_option("hide-seller-name") === "1") {
                $sellerName = $_SESSION["userData"]["company_name"];
            }

            foreach ($result as $project) {
                $project_id = $project["id"];
                $seller_id = $_SESSION["user_id"];
                $email = $_SESSION["userData"]["email"];
                $company = $_SESSION["userData"]["company_name"];
                $isExists = $projects->checkNotification($project_id, $seller_id);

                if (!$isExists) {
                    $project_name = $project["project_name"];
                    $post_code = $project["post_code"];
                    $desc = $project["project_description"];
                    $projects->addToNofications($project_name, $desc, $project_id, $seller_id);

                    $projectItems = $projects->getProjectItems($project_id);

                    $buyer_id = $project["buyer_id"];
                    $buyerData = $projects->getUserById($buyer_id);

                    if ($buyerData["newsletter_preference"] === '1') {
                        $subject = "Looking for a new price offer";
                        $message = '<!DOCTYPE html>
                                <html>
                                    <head>
                                        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                                    </head>
                                    <body><div style="background-color: #f6f6f6;">
                                        <div style="width: 600px; margin: auto; background-color: #fff;">
                                            <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                                <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                            </div>
                                            <div class="template-body" style="">
                                                <div style="padding: 0 80px">
                                                    <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                                    <div class="image" style="margin: auto; padding: 30px 0;">
                                                        <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                    </div>
                                                </div>
                                                <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                                    <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                    <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW OPPORTUNITY</h1>
                                                    <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from ' . $sellerName . ' looking to buy:</h3>
                                                    <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                        <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">' . $project_name . '</h3>
                                                        <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> ' . $post_code . '</p>
                                                        <div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';

                        $products_list_array = explode(',', $product_name);

                        // Filter $projectItems based on product types in $products_list_array
                        $matchingProducts = array_filter($projectItems, function ($product) use ($products_list_array) {
                            return in_array($product['product_type'], $products_list_array);
                        });

                        // Reset array keys
                        $matchingProducts = array_values($matchingProducts);

                        foreach ($matchingProducts as $matchingProduct) {
                            $itemWidth = '100%';
                            if (count($matchingProducts) > 1) {
                                $itemWidth = '50%';
                            }

                            $quantity = '';
                            if ($matchingProduct["quantity"]) {
                                $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> ' . $matchingProduct["quantity"] . '</p>';
                            }

                            $unit = '';
                            if ($matchingProduct["unit"]) {
                                $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> ' . $matchingProduct["unit"] . '</p>';
                            }

                            $date_required = '';
                            if ($matchingProduct["date_required"]) {
                                $date_required = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> ' . $matchingProduct["date_required"] . '</p>';
                            }

                            $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> ' . ucfirst($matchingProduct["open_to_similar_brands"]) . '</p>';

                            // $product = $products->getProductByName($matchingProduct["product_type"]);

                            // if(!empty($matchingProduct["product_image"])) {
                            //     $img_url = BASE_URL . $matchingProduct["product_image"];
                            // }else {
                            //     if(!empty($product["image"])) {
                            //         $img_url = BASE_URL . $product["image"];
                            //     }else {
                            //         $img_url = 'https://rakanonline.com/wp-content/uploads/2022/08/default-product-image.png';
                            //     }
                            // }

                            // <div class="">
                            //     <img style="width: 50px; margin-bottom: 5px;" src="'.$img_url.'" alt="'.ucfirst($matchingProduct["product_type"]).'" />
                            // </div>

                            $attached_file = '';
                            if (!empty($matchingProduct["product_image"])) {
                                $attached_file = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; text-align: left;"><a href="' . BASE_URL . $matchingProduct["product_image"] . '">See the attached file to view how the buyer expects the materials to look.</a></p>';
                            }

                            $message .= '<div class="product-item" style="box-sizing: border-box; width: ' . $itemWidth . '; display: inline-block; padding: 7.5px;">
                                        <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                            <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">' . ucfirst($matchingProduct["product_type"]) . '</h3>
                                            <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> ' . $matchingProduct["description"] . '</p>
                                            ' . $open_to_similar_brands . '
                                            ' . $quantity . '
                                            ' . $unit . '
                                            ' . $date_required . '
                                            ' . $attached_file . '
                                        </div>
                                    </div>';
                        }

                        $message .= '</div>
                                        </div>
                                            <div class="button" style="text-align: center;">
                                                <a href="https://www.connectionsys.co.uk/">
                                                    <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                        <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                        <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                    </div>
                                </div>
                            </div>
                            </body></html>';

                        // echo $message;
                        // exit;

                        $mail = new PHPMailer();
                        try {
                            //Server settings
                            // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                            $mail->isSMTP();                                            //Send using SMTP
                            $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                            $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                            $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                            $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                            $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

                            //Recipients
                            $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                            $mail->addAddress($email, $company);     //Add a recipient
                            // $mail->addAddress('ellen@example.com');               //Name is optional
                            // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');

                            //Content
                            $mail->isHTML(true);                                  //Set email format to HTML
                            $mail->Subject = $subject;
                            $mail->Body    = $message;
                            // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

                            $mail->send();
                            // echo 'Message has been sent';
                        } catch (Exception $e) {
                            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                            exit;
                        }
                    }
                }
            }
        }

        $response = array("type" => "form-msg", "status" => "success", "message" => "Product updated successfully.");
    } else {
        $response = array("type" => "form-msg", "status" => "danger", "message" => "Please select at least one product.");
    }
}

if (isset($_GET["update-gr-link"])) {
    $gr_link = $_GET["gr_link"];

    $res = $projects->updateGrLink($uid, $gr_link);

    if ($res) {
        $response = array("type" => "form-msg", "status" => "success", "message" => "Google Reviews Link updated successfully.");
    } else {
        $response = array("type" => "form-msg", "status" => "danger", "message" => "Something went wrong!");
    }
}

$userData = $projects->getUserById($uid);
?>

<div class="edit-product d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item <?php echo $_SESSION["show"] === "home" ? "active" : ""; ?>">
                        <a href="seller.php?show=home">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.06 10.23L21.42 4.18503C19.065 2.53503 15.45 2.62503 13.185 4.38003L5.66999 10.245C4.16999 11.415 2.98499 13.815 2.98499 15.705V26.055C2.98499 29.88 6.08998 33 9.91498 33H26.085C29.91 33 33.015 29.895 33.015 26.07V15.9C33.015 13.875 31.71 11.385 30.06 10.23ZM19.125 27C19.125 27.615 18.615 28.125 18 28.125C17.385 28.125 16.875 27.615 16.875 27V22.5C16.875 21.885 17.385 21.375 18 21.375C18.615 21.375 19.125 21.885 19.125 22.5V27Z" fill="#60CB97" />
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "chat" ? "active" : ""; ?>" id="chatBtn">
                        <a href="seller.php?show=chat">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M33 9.375V17.025C33 18.93 32.37 20.535 31.245 21.645C30.135 22.77 28.53 23.4 26.625 23.4V26.115C26.625 27.135 25.485 27.75 24.645 27.18L23.19 26.22C23.325 25.755 23.385 25.245 23.385 24.705V18.6C23.385 15.54 21.345 13.5 18.285 13.5H8.09999C7.88999 13.5 7.695 13.515 7.5 13.53V9.375C7.5 5.55 10.05 3 13.875 3H26.625C30.45 3 33 5.55 33 9.375Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                <path d="M23.385 18.6V24.705C23.385 25.245 23.325 25.755 23.19 26.22C22.635 28.425 20.805 29.805 18.285 29.805H14.205L9.675 32.82C9 33.285 8.09999 32.79 8.09999 31.98V29.805C6.56999 29.805 5.295 29.295 4.41 28.41C3.51 27.51 3 26.235 3 24.705V18.6C3 15.75 4.77 13.785 7.5 13.53C7.695 13.515 7.88999 13.5 8.09999 13.5H18.285C21.345 13.5 23.385 15.54 23.385 18.6Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "products" ? "active" : ""; ?>" id="productsBtn">
                        <a href="seller.php?show=products">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.1501 10.41C30.1501 11.22 29.7151 11.955 29.0251 12.33L26.4151 13.74L24.1951 14.925L19.5901 17.415C19.0951 17.685 18.5551 17.82 18.0001 17.82C17.4451 17.82 16.9051 17.685 16.4101 17.415L6.9751 12.33C6.2851 11.955 5.8501 11.22 5.8501 10.41C5.8501 9.6 6.2851 8.865 6.9751 8.49L9.9301 6.9L12.2851 5.625L16.4101 3.405C17.4001 2.865 18.6001 2.865 19.5901 3.405L29.0251 8.49C29.7151 8.865 30.1501 9.6 30.1501 10.41Z" fill="white" />
                                <path d="M14.8501 19.185L6.07508 14.805C5.40008 14.46 4.62008 14.505 3.97508 14.895C3.33008 15.285 2.95508 15.975 2.95508 16.725V25.02C2.95508 26.46 3.75008 27.75 5.04008 28.395L13.8151 32.775C14.1151 32.925 14.4451 33 14.7751 33C15.1651 33 15.5551 32.895 15.9001 32.67C16.5451 32.28 16.9201 31.59 16.9201 30.84V22.545C16.9351 21.12 16.1401 19.83 14.8501 19.185Z" fill="white" />
                                <path d="M33.0449 16.7249V25.0199C33.0449 26.4449 32.2499 27.7349 30.9599 28.3799L22.1849 32.7749C21.8849 32.9249 21.5549 32.9999 21.2249 32.9999C20.8349 32.9999 20.4449 32.8949 20.0849 32.6699C19.4549 32.2799 19.0649 31.5899 19.0649 30.8399V22.5599C19.0649 21.1199 19.8599 19.8299 21.1499 19.1849L24.3749 17.5799L26.6249 16.4549L29.9249 14.8049C30.5999 14.4599 31.3799 14.4899 32.0249 14.8949C32.6549 15.2849 33.0449 15.9749 33.0449 16.7249Z" fill="white" />
                                <path d="M26.4149 13.74L24.1949 14.925L9.92993 6.9L12.2849 5.625L26.0549 13.395C26.2049 13.485 26.3249 13.605 26.4149 13.74Z" fill="white" />
                                <path d="M26.625 16.4551V19.8601C26.625 20.4751 26.115 20.9851 25.5 20.9851C24.885 20.9851 24.375 20.4751 24.375 19.8601V17.5801L26.625 16.4551Z" fill="white" />
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "notifications" ? "active" : ""; ?>" id="notificationsBtn">
                        <a href="seller.php?show=notifications">
                            <div class="unread-notif-counter" style="display: none;">0</div>
                            <svg width="28" height="28" viewBox="0 0 27 31" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path id="Vector" d="M26.4096 21.3609C25.5799 19.9266 24.5815 17.1984 24.5815 12.375V11.3766C24.5815 5.14688 19.5893 0.0421875 13.444 0H13.3596C11.8841 0.00184556 10.4234 0.2943 9.06089 0.860664C7.69839 1.42703 6.46079 2.25621 5.41874 3.30087C4.37669 4.34553 3.55061 5.58521 2.98766 6.94912C2.4247 8.31304 2.13591 9.77448 2.13776 11.25V12.375C2.13776 17.1984 1.13932 19.9266 0.30963 21.3609C0.108973 21.7028 0.00217139 22.0915 3.2762e-05 22.4879C-0.00210587 22.8842 0.100495 23.2741 0.297451 23.6181C0.494407 23.962 0.778729 24.2478 1.12164 24.4466C1.46456 24.6454 1.8539 24.75 2.25026 24.75H7.73463C7.73463 26.2418 8.32726 27.6726 9.38216 28.7275C10.437 29.7824 11.8678 30.375 13.3596 30.375C14.8515 30.375 16.2822 29.7824 17.3371 28.7275C18.392 27.6726 18.9846 26.2418 18.9846 24.75H24.469C24.8653 24.7525 25.2551 24.6497 25.5986 24.452C25.942 24.2543 26.2268 23.9689 26.4237 23.625C26.6189 23.2791 26.7203 22.8882 26.7178 22.4911C26.7154 22.094 26.6091 21.7044 26.4096 21.3609ZM13.3596 28.125C12.4657 28.1213 11.6094 27.7645 10.9772 27.1324C10.3451 26.5003 9.98833 25.644 9.98463 24.75H16.7346C16.7309 25.644 16.3742 26.5003 15.742 27.1324C15.1099 27.7645 14.2536 28.1213 13.3596 28.125Z" fill="white" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left">
                    <div class="header-title">
                        <h3 class="m-0">Seller Page</h3>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                </div>
                <div class="header-right">
                    <div class="search">
                        <div class="icon">
                            <img src="public/images/bi_search-heart-fill.svg" alt="">
                        </div>
                        <input class="form-control" type="search" name="" id="" placeholder="Search your query">
                    </div>
                    <div class="notification">

                    </div>
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="edit.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" data-name="Layer 1" viewBox="0 0 24 24" id="edit">
                                            <path d="M3.5,24h15A3.51,3.51,0,0,0,22,20.487V12.95a1,1,0,0,0-2,0v7.537A1.508,1.508,0,0,1,18.5,22H3.5A1.508,1.508,0,0,1,2,20.487V5.513A1.508,1.508,0,0,1,3.5,4H11a1,1,0,0,0,0-2H3.5A3.51,3.51,0,0,0,0,5.513V20.487A3.51,3.51,0,0,0,3.5,24Z"></path>
                                            <path d="M9.455,10.544l-.789,3.614a1,1,0,0,0,.271.921,1.038,1.038,0,0,0,.92.269l3.606-.791a1,1,0,0,0,.494-.271l9.114-9.114a3,3,0,0,0,0-4.243,3.07,3.07,0,0,0-4.242,0l-9.1,9.123A1,1,0,0,0,9.455,10.544Zm10.788-8.2a1.022,1.022,0,0,1,1.414,0,1.009,1.009,0,0,1,0,1.413l-.707.707L19.536,3.05Zm-8.9,8.914,6.774-6.791,1.4,1.407-6.777,6.793-1.795.394Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted">Edit</span>
                                    </a>
                                </li>
                                <hr>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" viewBox="0 0 24 24" id="logout">
                                            <path d="M12.59,13l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L12.59,11H3a1,1,0,0,0,0,2ZM12,2A10,10,0,0,0,3,7.55a1,1,0,0,0,1.8.9A8,8,0,1,1,12,20a7.93,7.93,0,0,1-7.16-4.45,1,1,0,0,0-1.8.9A10,10,0,1,0,12,2Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="main-content">
            <div class="">
                <div class="update-product">
                    <?php
                    if (isset($response) && $response["type"] === "form-msg") {
                    ?>
                        <div class="alert alert-<?php echo $response["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                            <?php echo $response["message"]; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php
                    }

                    if (isset($_GET["status"]) && isset($_GET["message"])) {
                    ?>
                        <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                            <?php echo $_GET["message"]; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php
                    }
                    ?>

                    <div class="card mb-3">
                        <div class="card-header">Update List of Products</div>
                        <div class="card-body">
                            <form action="">
                                <div class="form-group product-list mb-15">
                                    <label for="">List of Products</label>
                                    <select class="form-control d-none" name="products">
                                        <?php
                                        $products = $productModel->getAllProducts();

                                        if ($products) {
                                            foreach ($products as $product) {
                                                echo '<option value="' . strtolower($product["name"]) . '">' . $product["name"] . '</option>';
                                            }
                                        }
                                        ?>
                                    </select>
                                    <details>
                                        <summary>Choose a product</summary>
                                        <ul>
                                            <?php
                                            $products = $productModel->getAllProducts();
                                            $products_list = $userData["products_list"];
                                            $selectedValues = explode(',', $products_list);

                                            if ($products) {
                                                foreach ($products as $product) {
                                                    $productName = strtolower($product["name"]);
                                                    $isChecked = in_array($productName, $selectedValues) ? 'checked' : '';

                                                    echo '<li>
                                                                <label><input type="checkbox" name="product_name[]" value="' . $productName . '" ' . $isChecked . ' /><span>' . $product["name"] . '</span></label>
                                                            </li>';
                                                }
                                            }
                                            ?>
                                        </ul>
                                    </details>
                                </div>
                                <div class="form-group">
                                    <button type="submit" name="update-list-of-products" value="1" class="btn butn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="card mb-3">
                        <div class="card-header">Update Postcodes</div>
                        <div class="card-body" style="max-width: 100% !important;">
                        <form action="app/core/update-postcodes.php" method="POST">
                            <input type="hidden" id="selected-postcodes" name="postcodes" value="[]">
                            <div id="osm-map" style="width: 100%; height: 400px;" class="mb-2"></div>
                            <div id="alert-message" class="mb-2" style="display: none; text-align: center; margin-top: 20px; padding: 10px; background-color: #28a745; color: white; border-radius: 5px;"></div>
                            <div class="form-group">
                                <button type="submit" name="update-postcodes" value="1" class="btn butn-primary">Update Postcodes</button>
                            </div>
                        </form>
                        </div>
                    </div>

                    <div class="card mb-3">
                        <div class="card-header">Update Preferences</div>
                        <div class="card-body">
                            <div class="form-group product-list mb-15">
                                <label for="" class="d-flex align-items-center gap-2">
                                    <input type="checkbox" name="notifications" id="notifications" <?php echo $userData["newsletter_preference"] === '1' ? 'checked' : ''; ?>> Notifications
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="card mb-3">
                        <div class="card-header">Change Password</div>
                        <div class="card-body">
                            <form action="app/core/change-password.php" method="POST">
                                <div class="form-group product-list mb-15">
                                    <label for="">Current Password</label>
                                    <input type="password" name="current-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group product-list mb-15">
                                    <label for="">New Password</label>
                                    <input type="password" name="new-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group product-list mb-15">
                                    <label for="">Confirm Password</label>
                                    <input type="password" name="confirm-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group">
                                    <button type="submit" name="change-password" value="1" class="btn butn-primary">Change Password</button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="card mb-3">
                        <div class="card-header">External Reviews</div>
                        <div class="card-body">
                            <form action="">
                                <div class="form-group product-list mb-15">
                                    <label for="">Reviews Link</label>
                                    <input style="max-width: 318px;" class="form-control" type="text" name="gr_link" value="<?php echo $userData["gr_link"]; ?>" id="">
                                </div>
                                <div class="form-group">
                                    <button type="submit" name="update-gr-link" value="1" class="btn butn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">Reviews</div>
                        <div class="card-body">
                            <div class="reviews">
                                <?php
                                $reviews = $projects->getSellerReviews($uid);

                                if ($reviews && $reviews["reviews"]) {
                                    foreach ($reviews["reviews"] as $review) {
                                ?>
                                        <div class="review">
                                            <div class="buyer-name">
                                                <h6><?php echo $review["company_name"]; ?></h6>
                                            </div>
                                            <div class="mb-10">
                                                <div class="rating">
                                                    <div class="Stars" style="--rating: <?php echo $review["rating"]; ?>;"></div>
                                                </div>
                                                <div class="date"></div>
                                            </div>
                                            <div class="comment">
                                                <?php echo $review["comment"]; ?>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                } else {
                                    ?>
                                    <div class="text-center">
                                        <p class="text-muted">No reviews found!</p>
                                    </div>
                                <?php
                                }

                                ?>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Include Footer -->
            <footer>
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>

                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<?php
include './templates/footer.php';
?>
<script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"></script>
<link href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" rel="stylesheet"/>
<script>
    // Parse user's selected postcodes
    var userPostCodes = JSON.parse('<?php echo isset($userData["postcodes"]) && $userData["postcodes"] ? addslashes($userData["postcodes"]) : "[]"; ?>');


    // Define a green marker icon for selected postcodes
    var greenIcon = L.icon({
        iconUrl: 'https://img.icons8.com/?size=100&id=PmnKuCaoGaNp&format=png&color=000000',
        iconSize: [50, 50],
        popupAnchor: [0, -15]
    });

    // Initialize the map
    var map = L.map('osm-map').setView([54.8, -4.6], 6); // Center on the UK
    L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(map);

    // Load UK boundary GeoJSON
    $.getJSON('path/uk-boundary.geojson', function (geojson) {
        var boundaryLayer = L.geoJson(geojson, {
            style: {
                color: 'green',
                weight: 2,
                fillOpacity: 0.1
            }
        }).addTo(map);
        map.fitBounds(boundaryLayer.getBounds());
    });

    // Function to load user's postcodes
    function loadUserPostcodes() {
        if (Array.isArray(userPostCodes)) {
            userPostCodes.forEach(function (item) {
                var marker = L.marker([item.latitude, item.longitude], { icon: greenIcon }).addTo(map);
                marker.bindPopup(`<b>Postcode:</b> ${item.postcode}<br><b>Latitude:</b> ${item.latitude}<br><b>Longitude:</b> ${item.longitude}`);
                marker.on('click', function () {
                    removePostcodeFromSelection(item.postcode, marker);
                });
            });
            document.getElementById('selected-postcodes').value = JSON.stringify(userPostCodes);
        } else {
            console.log('No valid user postcodes found.');
        }
    }

    // Function to remove a postcode
    function removePostcodeFromSelection(postcode, marker) {
        var selectedPostcodes = JSON.parse(document.getElementById('selected-postcodes').value);
        selectedPostcodes = selectedPostcodes.filter(post => post.postcode !== postcode);
        document.getElementById('selected-postcodes').value = JSON.stringify(selectedPostcodes);
        map.removeLayer(marker);
        showAlert(`Postcode Removed: ${postcode}`);
    }

    // Function to dynamically load a postcode
    function loadPostcodes(postcode) {
        $.ajax({
            url: 'https://api.postcodes.io/postcodes/' + postcode,
            method: 'GET',
            success: function (data) {
                if (data.result) {
                    var lat = data.result.latitude;
                    var lon = data.result.longitude;
                    var marker = L.marker([lat, lon]).addTo(map);
                    marker.bindPopup(`<b>Postcode:</b> ${postcode}<br><b>Latitude:</b> ${lat}<br><b>Longitude:</b> ${lon}`);
                    marker.on('click', function () {
                        addPostcodeToSelection(postcode, lat, lon, marker);
                    });
                }
            },
            error: function () {
                console.log(`Postcode ${postcode} not found.`);
            }
        });
    }

    // Function to add a new postcode
    function addPostcodeToSelection(postcode, lat, lon, marker) {
        var selectedPostcodes = JSON.parse(document.getElementById('selected-postcodes').value);
        if (!selectedPostcodes.some(post => post.postcode === postcode)) {
            selectedPostcodes.push({ postcode: postcode, latitude: lat, longitude: lon });
            document.getElementById('selected-postcodes').value = JSON.stringify(selectedPostcodes);
            marker.setIcon(greenIcon);
            showAlert(`Postcode Selected: ${postcode}`);
        }
    }

    // Function to show an alert
    function showAlert(message) {
        var alertMessage = document.getElementById('alert-message');
        alertMessage.textContent = message;
        alertMessage.style.display = 'block';
        setTimeout(function () {
            alertMessage.style.display = 'none';
        }, 3000);
    }

    // Load user's postcodes
    loadUserPostcodes();

    // Load additional postcodes dynamically
    var postcodes = [
        // London
        'W1A 1AA', 'EC1A 1BB', 'SW1A 1AA', 'N1 9GU', 'E1 6AN', 'W10 5DL', 'SE1 7PB', 'NW1 2BN', 'SW19 1AE', 'W12 8RP',

        // Manchester
        'M1 1AE', 'M3 4QL', 'M2 5NY', 'M4 5AN', 'M8 8AA', 'M9 6AA', 'M33 7DD', 'M60 0AL', 'M45 6AD', 'M13 0AZ',

        // Birmingham
        'B1 1AA', 'B2 5UP', 'B3 2DL', 'B4 6HS', 'B5 4BT', 'B6 4AF', 'B7 4BB', 'B8 1HP', 'B9 5BN', 'B10 9RE',


        // Bristol
        'BS1 4ST', 'BS2 0EH', 'BS3 5EX', 'BS4 3NG', 'BS5 9DR', 'BS6 5SJ', 'BS7 8AF', 'BS8 1EU', 'BS9 1LQ', 'BS16 1BL',


        // Liverpool
        'L1 8JQ', 'L2 6QR', 'L3 4EF', 'L4 3QT', 'L5 9RH', 'L6 5BG', 'L7 3NQ', 'L8 4RW', 'L9 2AT', 'L10 6ND',

        // Leeds
        'LS1 1UR', 'LS2 7UD', 'LS3 1AP', 'LS4 2EG', 'LS5 3DP', 'LS6 1BJ', 'LS7 2AL', 'LS8 5AG', 'LS9 6AD', 'LS10 2RL',

        // Sheffield
        'S1 2HU', 'S2 3QJ', 'S3 7NT', 'S4 7NG', 'S5 9PR', 'S6 3EJ', 'S7 1RA', 'S8 0SJ', 'S10 2TY', 'S11 8AT',

        // Newcastle
        'NE1 1DH', 'NE2 2AL', 'NE3 2BY', 'NE4 6NU', 'NE5 1BW', 'NE6 2TX', 'NE7 7PF', 'NE8 3DL', 'NE9 5PY', 'NE10 8NT',

        // Cardiff
        'CF10 1EP', 'CF11 9AB', 'CF14 5DW', 'CF15 7QU', 'CF23 8BB', 'CF24 3JP', 'CF36 3YT', 'CF37 1PS', 'CF38 1BG', 'CF39 9DR',

        // Nottingham
        'NG1 1QA', 'NG2 7LU', 'NG3 5QA', 'NG4 3GB', 'NG5 1AG', 'NG6 8EZ', 'NG7 1BY', 'NG8 1BP', 'NG9 2FQ', 'NG10 1AW',

        // Southampton
        'SO14 7FW', 'SO15 2AZ', 'SO16 1RP', 'SO17 1XL', 'SO18 1EB', 'SO19 9PB', 'SO20 6PH', 'SO21 1AN', 'SO22 6RA', 'SO23 8AZ',

        // Coventry
        'CV1 2WT', 'CV2 4LQ', 'CV3 5EH', 'CV4 9JW', 'CV5 6PS', 'CV6 1HR', 'CV7 9EX', 'CV8 2SY', 'CV9 1EX', 'CV10 7LA',

        // Derby
        'DE1 1LQ', 'DE3 9FW', 'DE4 3RJ', 'DE5 3JS', 'DE6 1AA', 'DE7 5RR', 'DE8 1FA', 'DE21 4GA', 'DE22 3FP', 'DE23 6QQ',

        // Oxford
        'OX1 1AA', 'OX2 0BN', 'OX3 7AY', 'OX4 4HE', 'OX5 2AF', 'OX6 3DZ', 'OX7 5DY', 'OX8 1NB', 'OX9 2BP', 'OX10 8BG',

        // Cambridge
        'CB1 2HS', 'CB2 1TN', 'CB3 0AF', 'CB4 3AX', 'CB5 8DR', 'CB6 1HW', 'CB7 4LA', 'CB8 0EB', 'CB9 7EH', 'CB10 2JB',

        // Norwich
        'NR1 1PP', 'NR2 1AL', 'NR3 3AP', 'NR4 6FB', 'NR5 8EQ', 'NR6 5QA', 'NR7 0AA', 'NR8 6RL', 'NR9 4AS', 'NR10 4EW',

        // Hull
        'HU1 2DA', 'HU2 8AH', 'HU3 1UR', 'HU4 7JS', 'HU5 1RR', 'HU6 9DE', 'HU7 4QS', 'HU8 0SN', 'HU9 1AA', 'HU10 6JS',

        // Sunderland
        'SR1 1JG', 'SR2 7AG', 'SR3 3EZ', 'SR4 6QJ', 'SR5 2DW', 'SR6 8HG', 'SR7 9BP', 'SR8 3DZ', 'SR9 1JN', 'SR10 1QJ',

        // Leicester
        'LE1 5JB', 'LE2 7HJ', 'LE3 1AA', 'LE4 1AA', 'LE5 1AR', 'LE6 0AB', 'LE7 9PQ', 'LE8 6JJ', 'LE9 2DD', 'LE10 1TY',

        // York
        'YO1 6JX', 'YO10 3DH', 'YO11 1AA', 'YO12 4NA', 'YO13 9DT', 'YO14 9AL', 'YO15 2EQ', 'YO16 4PB', 'YO17 6BJ', 'YO18 7BP',

        // Blackpool
        'FY1 1AA', 'FY2 0PA', 'FY3 9EB', 'FY4 1BS', 'FY5 2JR', 'FY6 7AB', 'FY7 6AX', 'FY8 1BL', 'FY9 1AD', 'FY10 3TH'
    ];
    postcodes.forEach(function (postcode) {
        loadPostcodes(postcode);
    });
</script>
<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });

        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });
    });
</script>