<?php
    session_start();

    include './load.php';
    include './templates/header.php';

    include './app/models/Messages.php';
    include './app/models/Notifications.php';
    include './app/models/Projects.php';
    include './app/models/Products.php';
    include './app/models/Settings.php';

    if(!isAdmin()) {
        header("Location: index.php");
        exit();
    }

    $uid = $_SESSION["user_id"];

    $msgModel = new Messages();
    $notifModel = new Notifications();
    $projectsModel = new Projects();
    $productModel = new Products();
    $settings = new Settings();

    if(isset($_POST["update_options"])) {
        $hide_buyer_name = isset($_POST["hide-buyer-name"]) ? '1' : '0';
        $hide_seller_name = isset($_POST["hide-seller-name"]) ? '1' : '0';

        $settings->update_option("hide-buyer-name", $hide_buyer_name);
        $settings->update_option("hide-seller-name", $hide_seller_name);

        $response = array(
            "status" => "success",
            "message" => "Options updated successfully"
        );
    }
?>

<div class="admin d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item active">
                        <a href="/">
                            <img src="public/images/home.svg" alt="">
                        </a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="header-left">
                    <div class="header-title">
                        <h1 class="m-0">Admin Page</h1>
                    </div>
                </div>
                <div class="header-right">
                    <div class="search">
                        <div class="icon">
                            <img src="public/images/bi_search-heart-fill.svg" alt="">
                        </div>
                        <input class="form-control" type="search" name="" id="" placeholder="Search your query">
                    </div>
                    <div class="notification">

                    </div>
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="" style="position: absolute; top: 0; width: 210px; right: 0;">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="settings.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" id="setting">
                                            <g fill="none" fill-rule="evenodd" stroke="#200E32" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" transform="translate(2.5 1.5)"><path d="M18.3066362,6.12356982 L17.6842106,5.04347829 C17.1576365,4.12955711 15.9906873,3.8142761 15.0755149,4.33867279 L15.0755149,4.33867279 C14.6398815,4.59529992 14.1200613,4.66810845 13.6306859,4.54104256 C13.1413105,4.41397667 12.7225749,4.09747295 12.4668193,3.66132725 C12.3022855,3.38410472 12.2138742,3.06835005 12.2105264,2.74599544 L12.2105264,2.74599544 C12.2253694,2.22917739 12.030389,1.72835784 11.6700024,1.3576252 C11.3096158,0.986892553 10.814514,0.777818938 10.2974829,0.778031878 L9.04347831,0.778031878 C8.53694532,0.778031878 8.05129106,0.97987004 7.69397811,1.33890085 C7.33666515,1.69793166 7.13715288,2.18454839 7.13958814,2.69107553 L7.13958814,2.69107553 C7.12457503,3.73688099 6.27245786,4.57676682 5.22654465,4.57665906 C4.90419003,4.57331126 4.58843537,4.48489995 4.31121284,4.32036615 L4.31121284,4.32036615 C3.39604054,3.79596946 2.22909131,4.11125048 1.70251717,5.02517165 L1.03432495,6.12356982 C0.508388616,7.03634945 0.819378585,8.20256183 1.72997713,8.73226549 L1.72997713,8.73226549 C2.32188101,9.07399614 2.68650982,9.70554694 2.68650982,10.3890161 C2.68650982,11.0724852 2.32188101,11.704036 1.72997713,12.0457667 L1.72997713,12.0457667 C0.820534984,12.5718952 0.509205679,13.7352837 1.03432495,14.645309 L1.03432495,14.645309 L1.6659039,15.7345539 C1.9126252,16.1797378 2.3265816,16.5082503 2.81617164,16.6473969 C3.30576167,16.7865435 3.83061824,16.7248517 4.27459956,16.4759726 L4.27459956,16.4759726 C4.71105863,16.2212969 5.23116727,16.1515203 5.71931837,16.2821523 C6.20746948,16.4127843 6.62321383,16.7330005 6.87414191,17.1716248 C7.03867571,17.4488473 7.12708702,17.764602 7.13043482,18.0869566 L7.13043482,18.0869566 C7.13043482,19.1435014 7.98693356,20.0000001 9.04347831,20.0000001 L10.2974829,20.0000001 C11.3504633,20.0000001 12.2054882,19.1490783 12.2105264,18.0961099 L12.2105264,18.0961099 C12.2080776,17.5879925 12.4088433,17.0999783 12.7681408,16.7406809 C13.1274382,16.3813834 13.6154524,16.1806176 14.1235699,16.1830664 C14.4451523,16.1916732 14.7596081,16.2797208 15.0389017,16.4393593 L15.0389017,16.4393593 C15.9516813,16.9652957 17.1178937,16.6543057 17.6475973,15.7437072 L17.6475973,15.7437072 L18.3066362,14.645309 C18.5617324,14.2074528 18.6317479,13.6859659 18.5011783,13.1963297 C18.3706086,12.7066935 18.0502282,12.2893121 17.6109841,12.0366133 L17.6109841,12.0366133 C17.17174,11.7839145 16.8513595,11.3665332 16.7207899,10.876897 C16.5902202,10.3872608 16.6602358,9.86577384 16.9153319,9.42791767 C17.0812195,9.13829096 17.3213574,8.89815312 17.6109841,8.73226549 L17.6109841,8.73226549 C18.5161253,8.20284891 18.8263873,7.04344892 18.3066362,6.13272314 L18.3066362,6.13272314 L18.3066362,6.12356982 Z"></path><circle cx="9.675" cy="10.389" r="2.636"></circle></g>
                                        </svg>
                                        <span class="ml-5">Settings</span>
                                    </a>
                                </li>
                                <br>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="30" viewBox="0 0 24 24" id="logout">
                                            <path d="M12.59,13l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L12.59,11H3a1,1,0,0,0,0,2ZM12,2A10,10,0,0,0,3,7.55a1,1,0,0,0,1.8.9A8,8,0,1,1,12,20a7.93,7.93,0,0,1-7.16-4.45,1,1,0,0,0-1.8.9A10,10,0,1,0,12,2Z"></path>
                                        </svg>
                                        <span class="ml-5">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content">
            <div class=" m-3">
                <?php
                    if(isset($response) && $response["message"] !== "") {
                        ?>
                            <div class="alert alert-<?php echo $response["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                <?php echo $response["message"]; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php
                    }
                ?>
                <form action="" method="post">
                    <div class="card">
                        <div class="card-header">
                            <h4>Hide/Show Company Name</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="buyer-company-name">
                                    <input type="checkbox" name="hide-buyer-name" value="1" <?php echo $settings->get_option('hide-buyer-name') === '1' ? 'checked' : '' ?> id="buyer-company-name"> Show Buyer Company Name
                                </label>
                            </div>
                            <div class="form-group" style="margin-bottom: 0;">
                                <label for="seller-company-name">
                                    <input type="checkbox" name="hide-seller-name" value="1" <?php echo $settings->get_option('hide-buyer-name') === '1' ? 'checked' : '' ?> id="seller-company-name"> Show Seller Company Name
                                </label>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" name="update_options" value="1" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });
    });
</script>