<?php
    session_start();

    include './load.php';
    include './templates/header.php';
    include './app/models/Messages.php';
    include './app/models/Notifications.php';
    include './app/models/Projects.php';
    include './app/models/Products.php';
    include './app/models/Settings.php';

    if(!isSeller()) {
        header("Location: index.php");
        exit();
    }

    $uid = $_SESSION["user_id"];

    $msgModel = new Messages();
    $notifModel = new Notifications();
    $projectModel = new Projects();
    $productModel = new Products();
    $settings = new Settings();
    // echo json_encode($messages);

    if(isset($_GET["show"])) {
        $_SESSION["show"] = $_GET["show"];
    }
    
    if(isset($_GET["notif_type"])) {
        $_SESSION["notif_type"] = $_GET["notif_type"];
    }else {
        $_SESSION["notif_type"] = 'all';
    }

    if(isset($_GET["add-to-chat"])) {
        $seller_id = $_GET["add-to-chat"];
        $addToChat = $msgModel->addToChat($uid, $seller_id);

        if($addToChat) {
            $_SESSION["chat_id"] = $seller_id;

            $msgModel->readAll($uid);
        }
    }

    if(isset($_GET["chat_id"])) {
        $_SESSION["chat_id"] = $_GET["chat_id"];

        $msgModel->readAll($uid);
    }

    $messages = null;
    if(isset($_SESSION["chat_id"])) {
        $user1 = $_SESSION["user_id"];
        $user2 = $_SESSION["chat_id"];

        $chatUser = $msgModel->chatUserDetails($user2);
        $messages = $msgModel->getMessages($user1, $user2);
    }
    
    if(isset($_GET["read_all"])) {
        $notifModel->readAll($uid);
    }

    if(isset($_GET["action"]) && $_GET["action"] === "delete-notif") {
        $notif_id = $_GET["notif_id"];

        $deleteNotif = $notifModel->deleteSellerNotification($notif_id, $uid);
        if($deleteNotif) {
            // echo "Deleted";
        }else {
            // echo "Something went wrong!";
        }
    }

    if(!isset($_SESSION["vat-type"])) {
        $_SESSION["vat-type"] = 'with-vat';
    }

    if(isset($_GET["vat-type"])) {
        $_SESSION["vat-type"] = $_GET["vat-type"];
    }
?>

<?php
    if($settings->get_option('hide-seller-name') === '0') {
    ?>
<style>
    .hide-company-name {
        display: none !important;
    }
</style>
    <?php
    }
?>

<div class="seller d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item <?php echo $_SESSION["show"] === "home" ? "active" : ""; ?>">
                        <a href="?show=home">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.06 10.23L21.42 4.18503C19.065 2.53503 15.45 2.62503 13.185 4.38003L5.66999 10.245C4.16999 11.415 2.98499 13.815 2.98499 15.705V26.055C2.98499 29.88 6.08998 33 9.91498 33H26.085C29.91 33 33.015 29.895 33.015 26.07V15.9C33.015 13.875 31.71 11.385 30.06 10.23ZM19.125 27C19.125 27.615 18.615 28.125 18 28.125C17.385 28.125 16.875 27.615 16.875 27V22.5C16.875 21.885 17.385 21.375 18 21.375C18.615 21.375 19.125 21.885 19.125 22.5V27Z" fill="#60CB97"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "chat" ? "active" : ""; ?>" id="chatBtn">
                        <a href="?show=chat">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M33 9.375V17.025C33 18.93 32.37 20.535 31.245 21.645C30.135 22.77 28.53 23.4 26.625 23.4V26.115C26.625 27.135 25.485 27.75 24.645 27.18L23.19 26.22C23.325 25.755 23.385 25.245 23.385 24.705V18.6C23.385 15.54 21.345 13.5 18.285 13.5H8.09999C7.88999 13.5 7.695 13.515 7.5 13.53V9.375C7.5 5.55 10.05 3 13.875 3H26.625C30.45 3 33 5.55 33 9.375Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M23.385 18.6V24.705C23.385 25.245 23.325 25.755 23.19 26.22C22.635 28.425 20.805 29.805 18.285 29.805H14.205L9.675 32.82C9 33.285 8.09999 32.79 8.09999 31.98V29.805C6.56999 29.805 5.295 29.295 4.41 28.41C3.51 27.51 3 26.235 3 24.705V18.6C3 15.75 4.77 13.785 7.5 13.53C7.695 13.515 7.88999 13.5 8.09999 13.5H18.285C21.345 13.5 23.385 15.54 23.385 18.6Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "products" ? "active" : ""; ?>" id="productsBtn">
                        <a href="?show=products">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.1501 10.41C30.1501 11.22 29.7151 11.955 29.0251 12.33L26.4151 13.74L24.1951 14.925L19.5901 17.415C19.0951 17.685 18.5551 17.82 18.0001 17.82C17.4451 17.82 16.9051 17.685 16.4101 17.415L6.9751 12.33C6.2851 11.955 5.8501 11.22 5.8501 10.41C5.8501 9.6 6.2851 8.865 6.9751 8.49L9.9301 6.9L12.2851 5.625L16.4101 3.405C17.4001 2.865 18.6001 2.865 19.5901 3.405L29.0251 8.49C29.7151 8.865 30.1501 9.6 30.1501 10.41Z" fill="white"/>
                                <path d="M14.8501 19.185L6.07508 14.805C5.40008 14.46 4.62008 14.505 3.97508 14.895C3.33008 15.285 2.95508 15.975 2.95508 16.725V25.02C2.95508 26.46 3.75008 27.75 5.04008 28.395L13.8151 32.775C14.1151 32.925 14.4451 33 14.7751 33C15.1651 33 15.5551 32.895 15.9001 32.67C16.5451 32.28 16.9201 31.59 16.9201 30.84V22.545C16.9351 21.12 16.1401 19.83 14.8501 19.185Z" fill="white"/>
                                <path d="M33.0449 16.7249V25.0199C33.0449 26.4449 32.2499 27.7349 30.9599 28.3799L22.1849 32.7749C21.8849 32.9249 21.5549 32.9999 21.2249 32.9999C20.8349 32.9999 20.4449 32.8949 20.0849 32.6699C19.4549 32.2799 19.0649 31.5899 19.0649 30.8399V22.5599C19.0649 21.1199 19.8599 19.8299 21.1499 19.1849L24.3749 17.5799L26.6249 16.4549L29.9249 14.8049C30.5999 14.4599 31.3799 14.4899 32.0249 14.8949C32.6549 15.2849 33.0449 15.9749 33.0449 16.7249Z" fill="white"/>
                                <path d="M26.4149 13.74L24.1949 14.925L9.92993 6.9L12.2849 5.625L26.0549 13.395C26.2049 13.485 26.3249 13.605 26.4149 13.74Z" fill="white"/>
                                <path d="M26.625 16.4551V19.8601C26.625 20.4751 26.115 20.9851 25.5 20.9851C24.885 20.9851 24.375 20.4751 24.375 19.8601V17.5801L26.625 16.4551Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "notifications" ? "active" : ""; ?>" id="notificationsBtn">
                        <a href="?show=notifications">
                            <div class="unread-notif-counter" style="display: none;">0</div>
                            <svg width="28" height="28" viewBox="0 0 27 31" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path id="Vector" d="M26.4096 21.3609C25.5799 19.9266 24.5815 17.1984 24.5815 12.375V11.3766C24.5815 5.14688 19.5893 0.0421875 13.444 0H13.3596C11.8841 0.00184556 10.4234 0.2943 9.06089 0.860664C7.69839 1.42703 6.46079 2.25621 5.41874 3.30087C4.37669 4.34553 3.55061 5.58521 2.98766 6.94912C2.4247 8.31304 2.13591 9.77448 2.13776 11.25V12.375C2.13776 17.1984 1.13932 19.9266 0.30963 21.3609C0.108973 21.7028 0.00217139 22.0915 3.2762e-05 22.4879C-0.00210587 22.8842 0.100495 23.2741 0.297451 23.6181C0.494407 23.962 0.778729 24.2478 1.12164 24.4466C1.46456 24.6454 1.8539 24.75 2.25026 24.75H7.73463C7.73463 26.2418 8.32726 27.6726 9.38216 28.7275C10.437 29.7824 11.8678 30.375 13.3596 30.375C14.8515 30.375 16.2822 29.7824 17.3371 28.7275C18.392 27.6726 18.9846 26.2418 18.9846 24.75H24.469C24.8653 24.7525 25.2551 24.6497 25.5986 24.452C25.942 24.2543 26.2268 23.9689 26.4237 23.625C26.6189 23.2791 26.7203 22.8882 26.7178 22.4911C26.7154 22.094 26.6091 21.7044 26.4096 21.3609ZM13.3596 28.125C12.4657 28.1213 11.6094 27.7645 10.9772 27.1324C10.3451 26.5003 9.98833 25.644 9.98463 24.75H16.7346C16.7309 25.644 16.3742 26.5003 15.742 27.1324C15.1099 27.7645 14.2536 28.1213 13.3596 28.125Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left d-flex gap-4 align-items-center">
                    <div class="header-title">
                        <h3 class="m-0">Seller Page</h3>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                    <!-- <div class="d-flex flex-column align-items-center justify-between">
                        <small class="text-muted"><?php echo $_SESSION["vat-type"] === 'with-vat' ? 'With VAT' : 'Without VAT' ?></small>
                        <div class="toggle-switch inline">
                            <input type="checkbox" id="local-pickup" class="switch-input vat-type-switch" <?php echo $_SESSION["vat-type"] === 'with-vat' ? 'checked' : '' ?> />
                            <label for="local-pickup" class="switch-label"></label>
                        </div>
                    </div> -->
                </div>
                <div class="header-right">
                    <div class="search">
                        <div class="icon">
                            <img src="public/images/bi_search-heart-fill.svg" alt="">
                        </div>
                        <input class="form-control" type="search" name="" id="" placeholder="Search your query">
                    </div>
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="edit.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" data-name="Layer 1" viewBox="0 0 24 24" id="edit">
                                            <path d="M3.5,24h15A3.51,3.51,0,0,0,22,20.487V12.95a1,1,0,0,0-2,0v7.537A1.508,1.508,0,0,1,18.5,22H3.5A1.508,1.508,0,0,1,2,20.487V5.513A1.508,1.508,0,0,1,3.5,4H11a1,1,0,0,0,0-2H3.5A3.51,3.51,0,0,0,0,5.513V20.487A3.51,3.51,0,0,0,3.5,24Z"></path><path d="M9.455,10.544l-.789,3.614a1,1,0,0,0,.271.921,1.038,1.038,0,0,0,.92.269l3.606-.791a1,1,0,0,0,.494-.271l9.114-9.114a3,3,0,0,0,0-4.243,3.07,3.07,0,0,0-4.242,0l-9.1,9.123A1,1,0,0,0,9.455,10.544Zm10.788-8.2a1.022,1.022,0,0,1,1.414,0,1.009,1.009,0,0,1,0,1.413l-.707.707L19.536,3.05Zm-8.9,8.914,6.774-6.791,1.4,1.407-6.777,6.793-1.795.394Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted">Edit</span>
                                    </a>
                                </li>
                                <hr>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" viewBox="0 0 24 24" id="logout">
                                            <path d="M12.59,13l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L12.59,11H3a1,1,0,0,0,0,2ZM12,2A10,10,0,0,0,3,7.55a1,1,0,0,0,1.8.9A8,8,0,1,1,12,20a7.93,7.93,0,0,1-7.16-4.45,1,1,0,0,0-1.8.9A10,10,0,1,0,12,2Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content <?php echo $_SESSION["show"] === "home" ? "show_all" : "show_single";  ?>">
            <!-- <div class="empty-content text-center mt-50">
                <p class="text-muted">Nothing selected for the page.</p>
            </div> -->

            <div id="chat-section" class="chat-comp box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "chat") ? "show" : ""; ?>">
                <div class="">
                    <div class="sec__heading">
                        <h5>Chat</h5>
                    </div>
                    <div class="inner-content">
                        <div class="app-content">
                            <div class="people-list">
                                <ul class="list list-unstyled p-0 m-0">
                                    <?php
                                        $peopleList = $msgModel->getPeopleList($uid);
                                        if($peopleList) {
                                            foreach ($peopleList as $people) {
                                                ?>
                                                    <li class="clearfix">
                                                        <a class="justify-content-between" href="<?php echo BASE_URL . 'seller.php?chat_id='. $people["user_id"]; ?>">
                                                            <div class="profile d-flex align-items-center">
                                                                <img src="public/images/<?php echo $people["company_logo"]; ?>" alt="avatar">
                                                                <div class="about">
                                                                    <div class="name hide-company-name"><?php echo $people["company_name"]; ?></div>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </li>
                                                <?php
                                            }
                                        }
                                    ?>
                                </ul>
                            </div>
                            <div class="chat">
                                <?php
                                    if(isset($_SESSION["chat_id"])) {
                                        ?>
                                            <div class="chat-header">
                                                <img src="public/images/<?php echo $chatUser["company_logo"]; ?>" alt="">
                                                <h6><?php echo $chatUser["company_name"]; ?></h6>
                                            </div>
                                        <?php
                                    }
                                ?>
                                
                                <div class="chat-history">
                                    <ul class="list-unstyled m-0">
                                        <li class="clearfix">
                                            <?php
                                                if($messages && count($messages) >= 20) {
                                                    ?>
                                                            <div class="load-more-msg text-center">
                                                            <a href="javascript:void(0);">Load More</a>
                                                        </div>
                                                    <?php
                                                }
                                            ?>
                                            <div class="chats">
                                                <?php
                                                    if($messages) {
                                                        foreach($messages as $message) {
                                                            if(!empty($message["chat_at"])) {
                                                                ?>
                                                                    <div class="date-divider">
                                                                        <span class="text-muted"><?php echo displayDateOrDay($message["chat_at"]); ?></span>
                                                                    </div>
                                                                <?php
                                                            }

                                                            if($message["user_id"] == $_SESSION["user_id"]) {
                                                                $width = 'width: 100%;';
                                                            }else {
                                                                $width = 'width: calc(100% - 60px);';
                                                            }
                                                            ?>
                                                                <div data-id="<?php echo $message["message_id"]; ?>" class="chat-msg <?php if($message["user_id"] == $_SESSION["user_id"]) {echo "owner";} ?>">
                                                                    <div class="chat-msg-content">
                                                                        <div class="chat-msg-date text-muted"><?php echo date("h:i A", strtotime($message["chat_timestamp"])); ?></div>
                                                                        <div class="msg-body">
                                                                            <div class="chat-msg-profile">
                                                                                <img class="chat-msg-img" src="public/images/<?php echo $message["company_logo"]; ?>" alt="">
                                                                            </div>
                                                                            <div class="" style="<?php echo $width;?>">
                                                                                <?php
                                                                                    if(!empty($message["attached_file"]) && $message["file_name"]) {
                                                                                        $allowedExtensions = array("jpg", "jpeg", "png", "gif");

                                                                                        $uploadedFileName = $message["attached_file"]; // Replace with the actual uploaded file name
                                                                                        $fileExtension = strtolower(pathinfo($uploadedFileName, PATHINFO_EXTENSION));

                                                                                        if (in_array($fileExtension, $allowedExtensions)) {
                                                                                            ?>
                                                                                                <div class="chat-msg-image">
                                                                                                    <a target="_blank" href="<?php echo $message["attached_file"]; ?>">
                                                                                                        <img src="<?php echo $message["attached_file"]; ?>" alt="<?php echo $message["file_name"]; ?>">
                                                                                                    </a>
                                                                                                </div>
                                                                                            <?php
                                                                                        } else {
                                                                                            ?>
                                                                                                <div class="chat-msg-file">
                                                                                                    <div class="file-icon">
                                                                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="file-arrow-down">
                                                                                                            <rect width="25" height="25 " fill="none"></rect><polygon points="152 32 152 88 208.008 88 152 32" opacity=".2"></polygon><path fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" d="M200,224.00005H55.99219a8,8,0,0,1-8-8V40a8,8,0,0,1,8-8L152,32l56,56v128A8,8,0,0,1,200,224.00005Z"></path><polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="152 32 152 88 208.008 88"></polyline><polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="100 156 128 184 156 156"></polyline><line x1="128" x2="128" y1="120" y2="184" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></line>
                                                                                                        </svg>
                                                                                                    </div>
                                                                                                    <div class="file-url">
                                                                                                        <a target="_blank" href="<?php echo $message["attached_file"]; ?>"><?php echo $message["file_name"]; ?></a>
                                                                                                    </div>
                                                                                                </div>
                                                                                            <?php
                                                                                        }
                                                                                    }

                                                                                    if(!empty($message["message_text"])) {
                                                                                        ?>
                                                                                            <div class="chat-msg-text"><?php echo $message["message_text"];?></div>
                                                                                        <?php
                                                                                    }
                                                                                ?>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php
                                                        }
                                                    }
                                                    
                                                    if(!isset($_SESSION["chat_id"])) {
                                                        ?>
                                                            <div class="msg text-muted mt-50" style="height: 100%; display: flex; align-items: center; justify-content: center; text-align: center;">
                                                                <h6>Select a chat or start a new conversation</h6>
                                                            </div>
                                                        <?php
                                                    }
                                                ?>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                                <div class="chat-message">
                                    <?php
                                        if(isset($_SESSION["chat_id"])) {
                                            ?>
                                                <div class="form-container">
                                                    <p class="attached-file-name" style="margin-top: -3px;"></p>
                                                    <div class="warning-msg" style="display: none;">
                                                        <small><p style="color: #df3079;">Terms of Service reminder: Sharing contact information is only allowed when essential for the service.</p></small>
                                                    </div>
                                                    <div class="box-wrapper">
                                                        <div class="input-wraper" style="position: relative;">
                                                            <div class="upload-file">
                                                                <label class="upload-area">
                                                                    <input id="attached-file" type="file">
                                                                    <span class="file-upload-button">
                                                                        <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                            <g id="fi-sr-clip" opacity="0.4" clip-path="url(#clip0_93_163)">
                                                                                <path id="Vector" d="M26.775 11.2001C26.5562 10.9813 26.2596 10.8585 25.9502 10.8585C25.6408 10.8585 25.3441 10.9813 25.1254 11.2001L12.418 23.9622C11.8764 24.504 11.2333 24.9337 10.5255 25.2269C9.81778 25.5202 9.0592 25.6711 8.29311 25.6712C6.74591 25.6713 5.26205 25.0568 4.16794 23.9628C3.07384 22.8689 2.45911 21.3851 2.459 19.8379C2.45889 18.2907 3.07341 16.8068 4.16736 15.7127L16.4745 3.35539C17.1326 2.70776 18.02 2.34642 18.9433 2.35007C19.8666 2.35372 20.7511 2.72207 21.404 3.37488C22.057 4.02769 22.4256 4.91207 22.4294 5.83538C22.4333 6.75869 22.0722 7.64613 21.4247 8.30439L9.11753 20.6617C8.89557 20.8744 8.60007 20.9931 8.29269 20.9931C7.98532 20.9931 7.68982 20.8744 7.46786 20.6617C7.24914 20.4429 7.12628 20.1462 7.12628 19.8369C7.12628 19.5275 7.24914 19.2308 7.46786 19.0121L18.4252 8.00455C18.6377 7.78452 18.7553 7.48982 18.7526 7.18392C18.75 6.87802 18.6273 6.58541 18.411 6.3691C18.1947 6.15279 17.9021 6.03009 17.5962 6.02743C17.2903 6.02478 16.9956 6.14237 16.7755 6.35489L5.81819 17.3624C5.49313 17.6874 5.23526 18.0733 5.05934 18.4979C4.88341 18.9226 4.79286 19.3778 4.79286 19.8375C4.79286 20.2971 4.88341 20.7523 5.05934 21.177C5.23526 21.6017 5.49313 21.9875 5.81819 22.3126C6.48508 22.9489 7.37147 23.304 8.29328 23.304C9.21508 23.304 10.1015 22.9489 10.7684 22.3126L23.0744 9.95405C24.1454 8.85541 24.7404 7.37905 24.7306 5.84479C24.7207 4.31053 24.1068 2.84191 23.0218 1.75708C21.9369 0.672249 20.4682 0.0585561 18.9339 0.0489428C17.3996 0.0393295 15.9234 0.63457 14.8249 1.70572L2.51769 14.0631C0.986068 15.5947 0.12561 17.672 0.12561 19.8381C0.12561 22.0041 0.986068 24.0814 2.51769 25.6131C4.04932 27.1447 6.12665 28.0051 8.29269 28.0051C10.4587 28.0051 12.5361 27.1447 14.0677 25.6131L26.775 12.8544C26.884 12.746 26.9705 12.6171 27.0295 12.4751C27.0886 12.3332 27.1189 12.181 27.1189 12.0272C27.1189 11.8735 27.0886 11.7213 27.0295 11.5793C26.9705 11.4374 26.884 11.3085 26.775 11.2001Z" fill="black" fill-opacity="0.4"/>
                                                                            </g>
                                                                            <defs>
                                                                                <clipPath id="clip0_93_163">
                                                                                    <rect width="28" height="28" fill="white"/>
                                                                                </clipPath>
                                                                            </defs>
                                                                        </svg>
                                                                    </span>
                                                                </label>
                                                            </div>
                                                            <input id="receiver_id" type="hidden" name="" value="<?php echo $_SESSION["chat_id"]; ?>">
                                                            <textarea id="msg-input" class="form-control" id="" cols="30" rows="2"></textarea>
                                                            <div id="send-msg">
                                                                <a href="javascript:void(0);"><img src="public/images/fi-sr-paper-plane.svg" alt=""></a>
                                                            </div>
                                                        </div>
                                                        <div id="sending-msg" style="display: none">
                                                            <a href="javascript:void(0);">
                                                                <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                                    <circle fill="#fff" stroke="none" cx="6" cy="50" r="6">
                                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>    
                                                                    </circle>
                                                                    <circle fill="#fff" stroke="none" cx="26" cy="50" r="6">
                                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>       
                                                                    </circle>
                                                                    <circle fill="#fff" stroke="none" cx="46" cy="50" r="6">
                                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>     
                                                                    </circle>
                                                                </svg>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="price-ioffer products-section" class="products box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "products") ? "show" : ""; ?>">
                <div class="">
                    <div class="sec__heading">
                        <h5>Price I Offer</h5>
                    </div>
                    <div class="p-lists">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th class="th-img">Photo</th>
                                        <th class="th-name" style="min-width: 150px;">Name</th>
                                    </tr>
                                </thead>
                                <tbody class="offers-wrapper">
                                    <?php
                                        $projects = $projectModel->productISold($uid);
                                        // echo json_encode($projects);

                                        if($projects) {
                                            foreach($projects as $project) {
                                                // echo json_encode($project);
                                                ?>
                                                    <tr class="price-i-offer" data-id="<?php echo $project["offer_id"]; ?>" data-project="<?php echo $project["project_id"]; ?>">
                                                        <td>
                                                            <div class="p-img">
                                                                <?php
                                                                    $product_name = strtolower($project["product_name"]);
                                                                    $productsArray = explode(",", $product_name);
                                                                    $product = $productModel->getProductByName($productsArray[0]);

                                                                    ?>
                                                                        <img class="lazyload" data-src="<?php echo isset($product["image"]) ? $product["image"] : ''; ?>" alt="<?php echo isset($product["name"]) ? $product["name"] : ''; ?>">
                                                                    <?php
                                                                ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="" style="display: flex; justify-content: space-between;">
                                                                <span class="p-name">
                                                                    <h6><?php echo $project["project_name"]; ?></h6>
                                                                    <span class="text-muted fw-normal hide-company-name"><b><?php echo $project["company_name"]; ?></b></span>
                                                                    <span class="text-muted fw-normal"><b>Postcode:</b> <?php echo $project["post_code"]; ?></span>
                                                                    
                                                                </span>
                                                                <div class="p-status">
                                                                    <?php
                                                                        if($project["status"] === null) {
                                                                            echo '<b class="text-muted">Pending</b>';
                                                                        }else {
                                                                            echo '<b class="text-muted">'.lcfirst($project["status"]).'</b>';
                                                                        }
                                                                    ?>
                                                                </div>
                                                            </div>

                                                            <span>
                                                                <?php
                                                                    if(!empty($project["attached_file"])) {
                                                                        ?>
                                                                            <div class="text-muted fw-normal pt-5">
                                                                                <a class="text-decoration-none" style="color: #60CB97; font-weight: 500;" target="_blank" href="<?php echo $project["attached_file"]; ?>">See the Attached File</a>
                                                                            </div>
                                                                        <?php
                                                                    }
                                                                ?>
                                                            </span>

                                                            <div class="p-amount" style="gap: 10px;">
                                                                <?php
                                                                    $offerData = $project["offer_data"];
                                                                    $arrayData = json_decode($offerData, true);

                                                                    foreach ($arrayData as $item) {
                                                                        // echo json_encode($item);
                                                                        ?>
                                                                            <div class="amount">
                                                                                <span class="text-muted"><?php echo ucfirst($item['product']); ?>:</span> (<small class="text-muted">All the prices <strong><?php echo $item["vat"] === '1' ? 'With VAT' : 'Without VAT' ?></strong></small>)
                                                                                <!-- <b class="text-muted">£<?php echo number_format($item['price'], 2); ?></b> -->
                                                                                <div>
                                                                                    <table>
                                                                                        <tr>
                                                                                            <td style="padding-right: 15px;">
                                                                                                <b style="margin-right: 4px;">Product Price:</b>
                                                                                                <b class="text-muted">£<?php echo number_format($item['price'], 2) ?> </b>
                                                                                            </td>
                                                                                            <td>
                                                                                                <?php
                                                                                                    if(isset($item["delivery_price"]) && $item["delivery_price"] !== null) {
                                                                                                        ?>
                                                                                                            <b style="margin-right: 4px;">Delivery Price:</b>
                                                                                                            <b class="text-muted">£<?php echo number_format($item['delivery_price'], 2) ?> </b>
                                                                                                        <?php
                                                                                                    }
                                                                                                ?>
                                                                                            </td>
                                                                                        </tr>
                                                                                        <tr>
                                                                                            <?php
                                                                                                if(isset($item["delivery_date"]) && $item["delivery_date"] !== null) {
                                                                                                    ?>
                                                                                                        <td style="padding-right: 15px;">
                                                                                                            <b style="margin-right: 4px;">Delivery Date:</b>
                                                                                                            <b class="text-muted"><?php echo $item['delivery_date']; ?> </b>
                                                                                                        </td>
                                                                                                    <?php
                                                                                                }
                                                                                            
                                                                                                if(isset($item["payment_term"]) && $item["payment_term"] !== null) {
                                                                                                    ?>
                                                                                                        <td>
                                                                                                            <b style="margin-right: 4px;">Payment Term:</b>
                                                                                                            <b class="text-muted"><?php echo $item['payment_term']; ?> </b>
                                                                                                        </td>
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                        </tr>
                                                                                    </table>
                                                                                </div>
                                                                            </div>
                                                                        <?php
                                                                    }
                                                                ?>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php
                                            }
                                        }else {
                                            ?>
                                                <tr>
                                                    <td class="no-data-found text-muted" style="border-bottom: 0; text-align: center;" colspan="4">No data found!</td>
                                                </tr>
                                            <?php
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div id="notifications-section" class="notifications box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "notifications") ? "show" : ""; ?>">
                <div class="javascript:void(0);">
                    <div class="sec__heading d-flex align-items-center justify-content-between">
                        <h5>Notifications</h5>
                        <div class="icon">
                            <!-- <a href="javascript:void(0);"> -->
                            
                            <?php 
                                if(isset($_SESSION["notif_type"]) && $_SESSION["notif_type"] === 'marked') {
                                    ?>
                                        <a href="?notif_type=all">
                                            <img src="public/images/star.svg" alt="">
                                        </a>
                                    <?php
                                }else {
                                    ?>
                                        <a href="?notif_type=marked">
                                            <img src="public/images/star-light.svg" alt="">
                                        </a>
                                    <?php
                                }
                             ?>
                        </div>
                    </div>
                    <div class="inner-content" style="padding-right: 0 !important;">
                        <div class="load-notifications" style="display: none;">
                            <a href="javascript:void(0);">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="reload">
                                    <path d="M21,11a1,1,0,0,0-1,1,8.05,8.05,0,1,1-2.22-5.5h-2.4a1,1,0,0,0,0,2h4.53a1,1,0,0,0,1-1V3a1,1,0,0,0-2,0V4.77A10,10,0,1,0,22,12,1,1,0,0,0,21,11Z"></path>
                                </svg>
                                <span>view new projects</span>
                            </a>
                        </div>
                        <div class="notifs">
                            <div class="text-end mb-5">
                                <a class="text-muted" href="?read_all=1"><small>Mark all as read</small></a>
                            </div>
                            <div class="lists-container">
                                <?php
                                    $notifications = $notifModel->getSellerNotifications($uid);
                                    // echo json_encode($notifications);

                                    if( $notifications) {
                                        foreach($notifications["data"] as $notification) {
                                            $notif_id = $notification["id"];
                                            $checkOffer = $notifModel->checkOffer($uid, $notif_id);

                                            // echo json_encode($notification);
                                            if($notification["is_deleted"] === '0') {
                                                ?>
                                                    <div class="list <?php echo $notification["is_deleted"] === '1' ? 'deleted-list' : ''; ?>" data-id="<?php echo $notification["id"]; ?>" data-project="<?php echo $notification["project_id"]; ?>">
                                                        
                                                        <div class="info">
                                                            <div class="p-meta">
                                                                <div class="d-flex justify-content-between">
                                                                    <div class="title">
                                                                        <?php
                                                                            if($notification["updated_on"] && $notification["is_deleted"] !== '1' && ($notification["is_completed"] !== '1' || $notification["is_completed"] !== '3') && $notification["created_at"] < $notification["updated_on"]) {
                                                                                ?>
                                                                                    <div class="mb-20 d-flex align-items-center">
                                                                                        <img width="20" style="opacity: 0.7;" src="public/images/edit.svg" alt="">
                                                                                        <span class="text-muted ml-10"><i>This one edited by the buyer</i></span>
                                                                                    </div>
                                                                                <?php
                                                                            }
                                                                            if($notification["is_deleted"] === '1') {
                                                                                ?>
                                                                                    <div class="mb-15">
                                                                                        <img width="30" src="public/images/group-64304.png" alt="">
                                                                                        <span style="color: #df3079">This one deleted by the buyer</span> <span class="text-muted">-</span> <a class="text-decoration-none" href="?action=delete-notif&notif_id=<?php echo $notification["id"]; ?>" style="color: #60CB97;">Delete</a>
                                                                                    </div>
                                                                                <?php
                                                                            }
                                                                            
                                                                            if($notification["is_completed"] === '1' || $notification["is_completed"] === '3') {
                                                                                ?>
                                                                                    <div class="mb-20 d-flex align-items-center">
                                                                                        <img width="20" style="opacity: 0.7;" src="public/images/lose.png" alt="">
                                                                                        <?php
                                                                                            if($uid === $notification["seller_id"]) {
                                                                                                echo '<span class="text-muted ml-10"><i>The buyer buy from you</i></span>';
                                                                                            }else {
                                                                                                echo '<span class="text-muted ml-10"><i>The buyer choose another seller</i></span>';
                                                                                            }
                                                                                        ?>
                                                                                    </div>
                                                                                <?php
                                                                            }
                                                                        ?>
                                                                        
                                                                        <div class="d-flex gap-3 align-items-center">
                                                                            <div class="notif-icon">
                                                                                <img src="public/images/notification.svg" alt="">
                                                                            </div>
                                                                            <div class="">
                                                                                <h6 class="mb-1"><?php echo $notification["title"]; ?></h6>
                                                                                <p class="mb-0 fw-normal text-muted hide-company-name"><b><?php echo $notification["company_name"]; ?></b></p>
                                                                                <p class="mb-0 fw-normal text-muted"><b>Postcode:</b> <?php echo $notification["post_code"]; ?></p>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="star">
                                                                        <a class="mark-notifications" href="javascript:void(0);" data-id="<?php echo $notification["id"]; ?>">
                                                                            <?php
                                                                                if($notification["is_marked"] === '0') {
                                                                                    ?>
                                                                                        <img class="star-image" width="20" src="public/images/star-light.svg" alt="">
                                                                                    <?php
                                                                                }else {
                                                                                    ?>
                                                                                        <img class="star-image" width="20" src="public/images/star.svg" alt="">
                                                                                    <?php
                                                                                }
                                                                            ?>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                                <div class="desc">
                                                                    <ol class="mb-0" style="padding-left: 15px;">
                                                                        <?php
                                                                            $project_id = $notification["project_id"];
                                                                            $productItems = $projectModel->getProjectItems($project_id, '1');

                                                                            $userData = $projectModel->getUserById($uid);
                                                                            $products_list = $userData["products_list"];
                                                                            $listAray = explode(",", $products_list);

                                                                            $encounteredProductTypes = array();
                                                                            $duplicateFound = true;

                                                                            if($productItems) {
                                                                                foreach($productItems as $item) {
                                                                                    $product_type = $item["product_type"];
    
                                                                                    if (in_array($product_type, $listAray)) {
                                                                                        if (in_array($product_type, $encounteredProductTypes)) {
                                                                                            // Duplicate found
                                                                                            $duplicateFound = true;
                                                                                        } else {
                                                                                            // Add product type to the encountered array
                                                                                            $encounteredProductTypes[] = $product_type;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }

                                                                            $total = 0;
                                                                            $newItems = 0;
                                                                            $isOfferSent = false;
                                                                            if($productItems) {
                                                                                foreach($productItems as $item) {
                                                                                    // echo json_encode($item);
                                                                                    $product_type = $item["product_type"];
    
                                                                                    if (in_array($product_type, $listAray)) {
                                                                                        $total ++;
                                                                                    }
                                                                                }
                                                                            }

                                                                            if($total < 1) {
                                                                                echo '<div class="alert alert-danger mt-10 text-center" style="background-color: #f9f9f9; border: none;" role="alert">Material not selected!</div>';
                                                                            }

                                                                            if($productItems) {
                                                                                foreach($productItems as $item) {
                                                                                    // echo json_encode($item);
                                                                                    $product_type = $item["product_type"];
                                                                                    $quantity = $item["quantity"];
    
                                                                                    if (in_array($product_type, $listAray)) {
                                                                                        $open_to_similar_brands = '<span class="badge bg-danger">No</span>';
                                                                                        if($item["open_to_similar_brands"] === 'yes') {
                                                                                            $open_to_similar_brands = '<span class="badge bg-warning">Yes</span>';
                                                                                        }
    
                                                                                        ?>
                                                                                            <li>
                                                                                                <h6 class="mb-0"><?php echo ucfirst($item["product_type"]); ?></h6>
                                                                                                <p><b>Description: </b> <?php echo $item["description"]; ?></p>
                                                                                                <div class="d-flex; align-items-center">
                                                                                                    <small class="mr-5 text-muted">Open To Similar Brands: </small>
                                                                                                    <?php echo $open_to_similar_brands; ?>
                                                                                                </div>
                                                                                                <?php
                                                                                                    if($item["quantity"]) {
                                                                                                        ?>
                                                                                                            <p><b>Quantity: </b> <?php echo $item["quantity"]; ?></p>
                                                                                                        <?php
                                                                                                    }
                                                                                                    if($item["unit"]) {
                                                                                                        ?>
                                                                                                            <p><b>Unit: </b> <?php echo $item["unit"]; ?></p>
                                                                                                        <?php
                                                                                                    }
                                                                                                    if($item["date_required"]) {
                                                                                                        ?>
                                                                                                            <p><b>Date Required: </b> <?php echo $item["date_required"]; ?></p>
                                                                                                        <?php
                                                                                                    }
                                                                                                    if($item["product_image"]) {
                                                                                                        ?>
                                                                                                            <p style="font-size: 14px;"><a href="<?php echo $item["product_image"]; ?>" target="_blank">See the attached file to view how the seller expects the materials to look.</a></p>
                                                                                                        <?php
                                                                                                    }
    
                                                                                                    if($duplicateFound) {
                                                                                                        if($checkOffer["status"] === "success") {
                                                                                                            $offer = $checkOffer["result"][0];
                                                                                                            $offer_id = $offer["offer_id"];
    
                                                                                                            // echo json_encode($offer);
                                        
                                                                                                            $offer_items = $notifModel->getOfferItemsByOfferId($offer_id, $uid);
                                                                                                            if($offer_items) {
                                                                                                                $isOfferSent = true;
                                                                                                            }
                                                                                                            ?>
                                                                                                                <!-- Offer Data -->
                                                                                                                <div class="offer-data">
                                                                                                                    <div class="d-flex align-items-center justify-content-between">
                                                                                                                        <div class=""></div>
                                                                                                                        <div class="">
                                                                                                                            <?php
                                                                                                                                $editPermission = 0;
                                                                                                                                if($offer_items) {
                                                                                                                                    foreach ($offer_items as $offerItem) {
                                                                                                                                        // echo json_encode($offerItem);
                                                                                                                                        $product_name = $offerItem["product_name"];
                                                                                                                                        $userData = $projectModel->getUserById($uid);
                                                                                                                                        $products_list = $userData["products_list"];
                                        
                                                                                                                                        $listAray = explode(",", $products_list);
        
                                        
                                                                                                                                        if(in_array($product_name, $listAray) && $offerItem["edit_permission"] === '1') {
                                                                                                                                            $editPermission++;
                                                                                                                                        }
                                                                                                                                        
                                                                                                                                        if($offer["version"] === '2') {
                                                                                                                                            $getOfferItem = $projectModel->getOfferItem($uid, $item["id"]);

                                                                                                                                            if($item["id"] === $offerItem["item_id"] && $getOfferItem["is_editable"] === '0') {
                                                                                                                                                ?>
                                                                                                                                                    <div class="prices">
                                                                                                                                                        <!-- <span><?php echo ucfirst($offerItem['product_name']); ?>:</span>
                                                                                                                                                        <b class="text-muted">£<?php echo $offerItem['product_price']; ?></b> -->
            
                                                                                                                                                        <table class="table" style="margin-top: 10px; margin-bottom: 0; text-align: end; border-color: transparent;">
                                                                                                                                                            <tr>
                                                                                                                                                                <td>
                                                                                                                                                                    <small>Product Price:</small>
                                                                                                                                                                    <b class="text-muted pr-2">£<?php echo $offerItem['product_price']; ?></b>
                                                                                                                                                                </td>
                                                                                                                                                                <td>
                                                                                                                                                                    <small>Delivery Price:</small>
                                                                                                                                                                    <b class="text-muted">£<?php echo $offerItem['delivery_price']; ?></b>
                                                                                                                                                                </td>
                                                                                                                                                            </tr>
                                                                                                                                                            <tr>
                                                                                                                                                                <td>
                                                                                                                                                                    <small>Delivery Date:</small>
                                                                                                                                                                    <b class="text-muted"><?php echo $offerItem['delivery_date']; ?></b>
                                                                                                                                                                </td>
                                                                                                                                                                <td>
                                                                                                                                                                    <small>Payment Term:</small>
                                                                                                                                                                    <b class="text-muted"><?php echo $offerItem['payment_term']; ?></b>
                                                                                                                                                                </td>
                                                                                                                                                            </tr>
                                                                                                                                                        </table>
                                                                                                                                                    </div>
                                                                                                                                                <?php
                                                                                                                                            }
                                                                                                                                        }else {
                                                                                                                                            ?>
                                                                                                                                                <div class="prices">
                                                                                                                                                    <small>Product Price:</small>
                                                                                                                                                    <b class="text-muted pr-2">£<?php echo $offerItem['product_price']; ?></b>
                                                                                                                                                </div>
                                                                                                                                            <?php
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            ?>
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                                
                                                                                                                <!-- Re-Write Price Form - Current -->
                                                                                                                <div class="form-wrapper rewrite-price-form" style="display: none;">
                                                                                                                    <div class="form-content">
                                                                                                                        <div class="pb-10 w-100">
                                                                                                                            <div class="">
                                                                                                                                <?php
                                                                                                                                    $projectItems = $projectModel->getProjectItems($project_id, '1');
                                                                                                                                    // echo $item["id"];
                                                                                                                                    // echo json_encode($projectItems);

                                                                                                                                    foreach ($projectItems as $offerItem) {
                                                                                                                                        $product_name = $offerItem["product_type"];
    
                                                                                                                                        // echo json_encode($offerItem);
    
                                                                                                                                        $userData = $projectModel->getUserById($uid);
                                                                                                                                        $products_list = $userData["products_list"];
                                                                                                                
                                                                                                                                        $listAray = explode(",", $products_list);
    
                                                                                                                                        // if(in_array($product_name, $listAray) && $offerItem["edit_permission"] === '1') {
                                                                                                                                        if(in_array($product_name, $listAray)) {
                                                                                                                                            if($offer["version"] === '2') {
                                                                                                                                                if($item["id"] === $offerItem["id"]) {
                                                                                                                                                    ?>
                                                                                                                                                        <div class="mt-5 d-flex align-items-center justify-content-between new-price-form" style="gap: 12px; padding: 15px 0; margin-left: -15px;">
                                                                                                                                                            <div class="vat-toggle-switch">
                                                                                                                                                                <label class="switch switch-green">
                                                                                                                                                                    <input type="checkbox" name="vat_input[]" class="switch-input">
                                                                                                                                                                    <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                                                                                                                                                    <span class="switch-handle"></span>
                                                                                                                                                                </label>
                                                                                                                                                            </div>
                                                                                                                                                            <div class="price" style="max-width: 235px;">
                                                                                                                                                                <input type="hidden" name="item_id[]" value="<?php echo $item["id"]; ?>">
                                                                                                                                                                <!-- <label for=""><?php echo ucfirst($offerItem["product_type"]); ?></label> -->
                                                                                                                                                                <input type="hidden" name="product_type[]" value="<?php echo $offerItem["product_type"]; ?>">
                                                                                                                                                                <input type="hidden" name="quantity[]" id="quantity" value="<?php echo $quantity; ?>">
                                                                                                                                                                <div class="row">
                                                                                                                                                                    <div class="col-6 p-0">
                                                                                                                                                                        <div class="p-1">
                                                                                                                                                                            <input type="number" name="product_price[]" id="priceInput" placeholder="Enter Price">
                                                                                                                                                                        </div>
                                                                                                                                                                    </div>
                                                                                                                                                                    <div class="col-6 p-0">
                                                                                                                                                                        <div class="p-1">
                                                                                                                                                                            <input type="number" name="delivery_price[]" id="priceInput" placeholder="Delivery Price">
                                                                                                                                                                        </div>
                                                                                                                                                                    </div>
                                                                                                                                                                    <div class="col-12 mb-10 mt-10 p-0">
                                                                                                                                                                        <small class="d-block text-muted mb-5">Total price for required quantity</small>
                                                                                                                                                                        <input type="number" name="total_price[]" id="priceInput" placeholder="Total Price" readonly>
                                                                                                                                                                    </div>
                                                                                                                                                                    <div class="col-6 p-0">
                                                                                                                                                                        <div class="p-1">
                                                                                                                                                                            <input type="text" name="delivery_date[]" id="priceInput" placeholder="Delivery Date">
                                                                                                                                                                        </div>
                                                                                                                                                                    </div>
                                                                                                                                                                    <div class="col-6 p-0">
                                                                                                                                                                        <div class="p-1">
                                                                                                                                                                            <input type="text" name="payment_term[]" id="priceInput" placeholder="Payment Term">
                                                                                                                                                                        </div>
                                                                                                                                                                </div>
                                                                                                                                                                </div>
                                                                                                                                                            </div>
                                                                                                                                                        </div>
                                                                                                                                                    <?php
                                                                                                                                                }
                                                                                                                                            }else {
                                                                                                                                                ?>
                                                                                                                                                    <div class="mt-5 d-flex align-items-center justify-content-between" style="padding: 15px 0;">
                                                                                                                                                        <div class="vat-toggle-switch">
                                                                                                                                                            <label class="switch switch-green">
                                                                                                                                                                <input type="checkbox" name="vat_input[]" class="switch-input">
                                                                                                                                                                <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                                                                                                                                                <span class="switch-handle"></span>
                                                                                                                                                            </label>
                                                                                                                                                        </div>
                                                                                                                                                        <div class="price" style="max-width: 235px;">
                                                                                                                                                            <input type="hidden" name="item_id[]" value="<?php echo $item["id"]; ?>">
                                                                                                                                                            <!-- <label for=""><?php echo ucfirst($offerItem["product_type"]); ?></label> -->
                                                                                                                                                            <input type="hidden" name="product_type[]" value="<?php echo $offerItem["product_type"]; ?>">
                                                                                                                                                            <div class="row">
                                                                                                                                                                <div class="col-6 p-0">
                                                                                                                                                                    <div class="p-1">
                                                                                                                                                                        <input type="number" name="product_price[]" id="priceInput" placeholder="Enter Price">
                                                                                                                                                                    </div>
                                                                                                                                                                </div>
                                                                                                                                                                <?php
                                                                                                                                                                    if($offerItem["delivery_price"] !== null) {
                                                                                                                                                                        ?>
                                                                                                                                                                            <div class="col-6 p-0">
                                                                                                                                                                                <div class="p-1">
                                                                                                                                                                                    <input type="number" name="delivery_price[]" id="priceInput" placeholder="Delivery Price">
                                                                                                                                                                                </div>
                                                                                                                                                                            </div>
                                                                                                                                                                        <?php
                                                                                                                                                                    }
                                                                                                                                                                ?>
                                                                                                                                                                <?php
                                                                                                                                                                    if($offerItem["delivery_date"] !== null) {
                                                                                                                                                                        ?>
                                                                                                                                                                            <div class="col-6 p-0">
                                                                                                                                                                                <div class="p-1">
                                                                                                                                                                                    <input type="text" name="delivery_date[]" id="priceInput" placeholder="Delivery Date">
                                                                                                                                                                                </div>
                                                                                                                                                                            </div>
                                                                                                                                                                        <?php
                                                                                                                                                                    }
                                                                                                                                                                ?>
                                                                                                                                                                <?php
                                                                                                                                                                    if($offerItem["payment_term"] !== null) {
                                                                                                                                                                        ?>
                                                                                                                                                                            <div class="col-6 p-0">
                                                                                                                                                                                <div class="p-1">
                                                                                                                                                                                    <input type="text" name="payment_term[]" id="priceInput" placeholder="Payment Term">
                                                                                                                                                                                </div>
                                                                                                                                                                            </div>
                                                                                                                                                                        <?php
                                                                                                                                                                    }
                                                                                                                                                                ?>
                                                                                                                                                            </div>
                                                                                                                                                        </div>
                                                                                                                                                    </div>
                                                                                                                                                <?php
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                ?>
                                                                                                                            </div>
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            <?php
                                                                                                            
                                                                                                        }else {
                                                                                                            ?>
                                                                                                                <!-- Offer Form -->
                                                                                                                <div class="mt-5 d-flex align-items-center justify-content-between" style="gap: 12px; padding: 15px 0; margin-left: -15px;">
                                                                                                                    <div class="vat-toggle-switch">
                                                                                                                        <label class="switch switch-green">
                                                                                                                            <input type="checkbox" name="vat_input[]" class="switch-input">
                                                                                                                            <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                                                                                                            <span class="switch-handle"></span>
                                                                                                                        </label>
                                                                                                                    </div>
                                                                                                                    <div class="price" style="max-width: 235px;">
                                                                                                                        <input type="hidden" name="item_id[]" value="<?php echo $item["id"]; ?>">
                                                                                                                        <input type="hidden" name="product_type[]" value="<?php echo $item["product_type"]; ?>">
                                                                                                                        <input type="hidden" name="quantity[]" id="quantity" value="<?php echo $quantity; ?>">
                                                                                                                        <div class="row">
                                                                                                                            <div class="col-6 p-0">
                                                                                                                                <div class="p-1">
                                                                                                                                    <input type="number" name="product_price[]" id="priceInput" min="1" placeholder="Unit Price">
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div class="col-6 p-0">
                                                                                                                                <div class="p-1">
                                                                                                                                    <input type="number" name="delivery_price[]" id="priceInput" placeholder="Delivery Price">
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div class="col-12 mb-10 mt-10 p-0">
                                                                                                                                <small class="d-block text-muted mb-5">Total price for required quantity</small>
                                                                                                                                <input type="number" name="total_price[]" id="priceInput" placeholder="Total Price" readonly>
                                                                                                                            </div>
                                                                                                                            <div class="col-6 p-0">
                                                                                                                                <div class="p-1">
                                                                                                                                    <input type="text" name="delivery_date[]" id="priceInput" placeholder="Delivery Date">
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div class="col-6 p-0">
                                                                                                                                <div class="p-1">
                                                                                                                                    <input type="text" name="payment_term[]" id="priceInput" placeholder="Payment Term">
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            <?php
                                                                                                        }
                                                                                                    }

                                                                                                    if($checkOffer["status"] === 'success') {
                                                                                                        $getOfferItem = $projectModel->getOfferItem($uid, $item["id"]);
                                                                                                        // echo json_encode($getOfferItem);

                                                                                                        $is_editable = false;
                                                                                                        if(!$getOfferItem) {
                                                                                                            $is_editable = true;
                                                                                                        }else if($getOfferItem["is_editable"] === '1') {
                                                                                                            $is_editable = true;
                                                                                                        }

                                                                                                        if($is_editable) {
                                                                                                            $newItems++;
                                                                                                            ?>
                                                                                                                <!-- Offer Form -->
                                                                                                                <div class="mt-5 d-flex align-items-center justify-content-between new-material-inputs" style="gap: 12px; padding: 15px 0; margin-left: -15px;">
                                                                                                                    <div class="vat-toggle-switch">
                                                                                                                        <label class="switch switch-green">
                                                                                                                            <input type="checkbox" name="new_vat_input[]" class="switch-input">
                                                                                                                            <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                                                                                                            <span class="switch-handle"></span>
                                                                                                                        </label>
                                                                                                                    </div>
                                                                                                                    <div class="price" style="max-width: 235px;">
                                                                                                                        <input type="hidden" name="new_item_id[]" value="<?php echo $item["id"]; ?>">
                                                                                                                        <input type="hidden" name="new_product_type[]" value="<?php echo $item["product_type"]; ?>">
                                                                                                                        <input type="hidden" name="new_quantity[]" id="quantity" value="<?php echo $quantity; ?>">
                                                                                                                        <div class="row">
                                                                                                                            <div class="col-6 p-0">
                                                                                                                                <div class="p-1">
                                                                                                                                    <input type="number" name="new_product_price[]" id="priceInput" min="1" placeholder="Unit Price">
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div class="col-6 p-0">
                                                                                                                                <div class="p-1">
                                                                                                                                    <input type="number" name="new_delivery_price[]" id="priceInput" placeholder="Delivery Price">
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div class="col-12 mb-10 mt-10 p-0">
                                                                                                                                <small class="d-block text-muted mb-5">Total price for required quantity</small>
                                                                                                                                <input type="number" name="new_total_price[]" id="priceInput" placeholder="Total Price" readonly>
                                                                                                                            </div>
                                                                                                                            <div class="col-6 p-0">
                                                                                                                                <div class="p-1">
                                                                                                                                    <input type="text" name="new_delivery_date[]" id="priceInput" placeholder="Delivery Date">
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div class="col-6 p-0">
                                                                                                                                <div class="p-1">
                                                                                                                                    <input type="text" name="new_payment_term[]" id="priceInput" placeholder="Payment Term">
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            <?php
                                                                                                        }
                                                                                                        
                                                                                                        // if($checkOffer["status"] === 'success' && !$getOfferItem || $getOfferItem["is_editable"] === '1') {
                                                                                                        // }
                                                                                                    }
                                                                                                ?>
                                                                                            </li>
                                                                                        <?php
                                                                                    }
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </ol>
                                                                    
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="msg-area">
                                                            <?php
                                                                if($checkOffer["status"] === "success") {
                                                                    $offer = $checkOffer["result"][0];
                                                                    $offer_id = $offer["offer_id"];

                                                                    $offer_items = $notifModel->getOfferItemsByOfferId($offer_id, $uid);
                                                                        if(!$duplicateFound) {
                                                                            ?>
                                                                                <div class="offer-data">
                                                                                    <div class="d-flex align-items-center justify-content-between">
                                                                                        <div class="">
                                                                                            <?php
                                                                                                if(!empty($offer["attached_file"])) {
                                                                                                    ?>
                                                                                                        <a class="text-decoration-none" style="color: #60CB97; font-weight: 500;" target="_blank" href="<?php echo $offer["attached_file"]; ?>">See the attachment</a>
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                        </div>
                                                                                        <div class="d-flex" style="gap: 15px;">
                                                                                            <div class="">
                                                                                                <?php
                                                                                                    // $dataArray = json_decode($offer_data, true);
                                                                                
                                                                                                    $editPermission = 0;
                                                                                                    foreach ($offer_items as $item) {
                                                                                                        $product_name = $item["product_name"];
                                                                                
                                                                                                        $userData = $projectModel->getUserById($uid);
                                                                                                        $products_list = $userData["products_list"];
                                                                                
                                                                                                        $listAray = explode(",", $products_list);
                                                                                
                                                                                                        if(in_array($product_name, $listAray) && $item["edit_permission"] === '1') {
                                                                                                            $editPermission++;
                                                                                                        }
                                                                                                        ?>
                                                                                                            <div class="price d-flex">
                                                                                                                <span><?php echo ucfirst($item['product_name']); ?>:</span>
                                                                                                                <b class="text-muted">£<?php echo $item['product_price']; ?></b>
                                                                                                            </div>
                                                                                                        <?php
                                                                                                    }
                                                                                                ?>
                                                                                            </div>
                                                                                            <?php
                                                                                                $is_updated = 0;
                                                                                                foreach($productItems as $item) {
                                                                                                    if($item["is_updated"] === '1') {
                                                                                                        $is_updated = 1;
                                                                                
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                
                                                                                                if($notification["updated_on"] && $is_updated === 1 && $editPermission > 0) {
                                                                                                    ?>
                                                                                                         <!-- <div class="d-flex align-items-center">
                                                                                                            <a class="rewrite-price text-decoration-none" href="javascript:void(0);" style="color: #60CB97;">Rewrite</a>
                                                                                                        </div> -->
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                
                                                                                <div class="form-wrapper rewrite-price-form" style="display: none;">
                                                                                    <div class="form-content">
                                                                                        <div class="pb-10 w-100">
                                                                                            <?php
                                                                                                foreach ($offer_items as $item) {
                                                                                                    $product_name = $item["product_name"];
                                                                            
                                                                                                    $userData = $projectModel->getUserById($uid);
                                                                                                    $products_list = $userData["products_list"];
                                                                            
                                                                                                    $listAray = explode(",", $products_list);
                                                                                                    if(in_array($product_name, $listAray) && $item["edit_permission"] === '1') {
                                                                                                        ?>
                                                                                                            <div class="mt-5 d-flex align-items-center justify-content-between">
                                                                                                                <div class="vat-toggle-switch">
                                                                                                                    <label class="switch switch-green">
                                                                                                                        <input type="checkbox" name="vat_input[]" class="switch-input">
                                                                                                                        <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                                                                                                        <span class="switch-handle"></span>
                                                                                                                    </label>
                                                                                                                </div>
                                                                                                                <div class="price d-flex">
                                                                                                                    <label for=""><?php echo ucfirst($item["product_name"]); ?></label>
                                                                                                                    <input type="hidden" name="product_type[]" value="<?php echo $item["product_name"]; ?>">
                                                                                                                    <input type="number" name="product_price[]" id="priceInput" placeholder="Enter Price">
                                                                                                                </div>
                                                                                                            </div>
                                                                                                        <?php
                                                                                                    }
                                                                                                }
                                                                                            ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            <?php
                                                                        }

                                                                        $target = '';
                                                                        if($_SESSION["show"] === 'notifications') {
                                                                            $target = "show=chat&";
                                                                        }
                                                                    ?>
                                                                        <div class="form-bottom mt-5">
                                                                            <div class="d-flex align-items-center justify-content-between">
                                                                                <!-- <div class="msg">
                                                                                    <a href="?show=chat&<?php echo $target; ?>add-to-chat=<?php echo $notification["buyer_id"]; ?>">
                                                                                        <img src="public/images/messages-3.svg" alt="">
                                                                                    </a>
                                                                                </div> -->
                                                                                <div class="d-flex gap-4">
                                                                                    <!-- <div class="check-icon">
                                                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="check" style="width: 28px;">
                                                                                            <rect width="25" height="25" fill="none"></rect><polyline fill="none" stroke="#60cb97" stroke-linecap="round" stroke-linejoin="round" stroke-width="24" points="216 72.005 104 184 48 128.005"></polyline>
                                                                                        </svg>
                                                                                    </div> -->

                                                                                    <?php
                                                                                        if($duplicateFound) {
                                                                                            $is_updated = 0;
                                                                                            if($productItems) {
                                                                                                foreach($productItems as $item) {
                                                                                                    if($item["is_updated"] === '1') {
                                                                                                        $is_updated = 1;
                                                                                
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                            
                                                                                            if($notification["updated_on"] && $is_updated === 1 && $editPermission > 0) {
                                                                                                ?>
                                                                                                    <!-- <div class="d-flex align-items-center">
                                                                                                        <a class="rewrite-price text-decoration-none" href="javascript:void(0);" style="color: #60CB97;">Rewrite</a>
                                                                                                    </div> -->
                                                                                                <?php
                                                                                            }else {
                                                                                            }
                                                                                                ?>
                                                                                                    <!-- <div class="check-icon">
                                                                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="check" style="width: 28px;">
                                                                                                            <rect width="25" height="25" fill="none"></rect><polyline fill="none" stroke="#60cb97" stroke-linecap="round" stroke-linejoin="round" stroke-width="24" points="216 72.005 104 184 48 128.005"></polyline>
                                                                                                        </svg>
                                                                                                    </div> -->
                                                                                                <?php
                                                                                        }
                                                                                        ?>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    <?php
                                                                }else {
                                                                    if($notification["is_deleted"] !== '1') {
                                                                        ?>
                                                                            <div class="form-wrapper">
                                                                                <?php
                                                                                    if(!$duplicateFound) {
                                                                                        ?>
                                                                                            <div class="form-content">
                                                                                                <div class="pb-10 w-100">
                                                                                                    <?php
                                                                                                        foreach($productItems as $item) {
                                                                                                            $product_type = $item["product_type"];
        
                                                                                                            $userData = $projectModel->getUserById($uid);
                                                                                                            $products_list = $userData["products_list"];
        
                                                                                                            $listAray = explode(",", $products_list);
                                                                                                            if (in_array($product_type, $listAray)) {
                                                                                                                ?>
                                                                                                                    <div class="mt-5 d-flex align-items-center justify-content-between">
                                                                                                                        <div class="vat-toggle-switch">
                                                                                                                            <label class="switch switch-green">
                                                                                                                                <input type="checkbox" name="vat_input[]" class="switch-input">
                                                                                                                                <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                                                                                                                <span class="switch-handle"></span>
                                                                                                                            </label>
                                                                                                                        </div>
                                                                                                                        <div class="price d-flex">
                                                                                                                            <label for=""><?php echo ucfirst($item["product_type"]); ?></label>
                                                                                                                            <input type="hidden" name="item_id[]" value="<?php echo $item["id"]; ?>">
                                                                                                                            <input type="hidden" name="product_type[]" value="<?php echo $item["product_type"]; ?>">
                                                                                                                            <input type="number" name="product_price[]" id="priceInput" placeholder="Enter Price">
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                <?php
                                                                                                            }
                                                                                                        }
                                                                                                    ?>
                                                                                                </div>
                                                                                            </div>
                                                                                        <?php
                                                                                    }

                                                                                    if($total) {
                                                                                        ?>
                                                                                            <div class="mt-5 d-flex align-items-center justify-content-between" style="gap: 15px;">
                                                                                                <div class="msg">
                                                                                                    <a href="?show=home&add-to-chat=<?php echo $notification["buyer_id"]; ?>">
                                                                                                        <img src="public/images/messages.svg" alt="">
                                                                                                        Send Message
                                                                                                    </a>
                                                                                                </div>
                                                                                                <div class="w-100">
                                                                                                    <div class="w-100 mb-5 d-flex gap-2 offer-contents">
                                                                                                        <div class="add-attachment">
                                                                                                            <label for="file-input-<?php echo $project_id; ?>">
                                                                                                                <input type="file" id="file-input-<?php echo $project_id; ?>" class="file-input" accept="image/*, application/pdf">
                                                                                                                <span id="file-text">Add Attachment</span>
                                                                                                            </label>
                                                                                                        </div>
                                                                                                        <span class="file-contents">Show</span>
                                                                                                    </div>
                                                                                                    <div class="w-100 btn-submit-price">
                                                                                                        <button><img src="public/images/fi-sr-paper-plane.svg" alt="">Send Now</button>
                                                                                                        <div class="loading" style="display: none">
                                                                                                            <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                                                                                <circle fill="#000" stroke="none" cx="6" cy="50" r="6">
                                                                                                                    <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>    
                                                                                                                </circle>
                                                                                                                <circle fill="#000" stroke="none" cx="26" cy="50" r="6">
                                                                                                                    <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>       
                                                                                                                </circle>
                                                                                                                <circle fill="#000" stroke="none" cx="46" cy="50" r="6">
                                                                                                                    <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>     
                                                                                                                </circle>
                                                                                                            </svg>
                                                                                                        </div>
                                                                                                        <div class="check-icon" style="display: none;">
                                                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="check" style="width: 28px;">
                                                                                                                <rect width="25" height="25" fill="none"></rect><polyline fill="none" stroke="#60cb97" stroke-linecap="round" stroke-linejoin="round" stroke-width="24" points="216 72.005 104 184 48 128.005"></polyline>
                                                                                                            </svg>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        <?php
                                                                                    }
                                                                                ?>

                                                                            </div>
                                                                        <?php
                                                                    }
                                                                }
                                                            ?>
                                                        </div>
                                                        
                                                        <?php
                                                            $style = '';
                                                            if($isOfferSent && $newItems > 0) {
                                                                ?>
                                                                    <div class="form-wrapper rewrite-price-form" style="display: block;">
                                                                        <div class="mt-5 d-flex align-items-center justify-content-between" style="gap: 15px;">
                                                                            <div class="msg">
                                                                                <a href="?show=home&add-to-chat=<?php echo $notification["buyer_id"]; ?>">
                                                                                    <img src="public/images/messages.svg" alt="">
                                                                                    Send Message
                                                                                </a>
                                                                            </div>
                                                                            <div class="w-100">
                                                                                <div class="w-100 mb-5 d-flex gap-2 offer-contents">
                                                                                    <div class="add-attachment">
                                                                                        <label for="file-input-<?php echo $project_id; ?>">
                                                                                            <input type="file" id="file-input-<?php echo $project_id; ?>" class="file-input" accept="image/*, application/pdf">
                                                                                            <span id="file-text">Add Attachment</span>
                                                                                        </label>
                                                                                    </div>
                                                                                    <span class="file-contents">Show</span>
                                                                                </div>
                                                                                <div class="w-100 btn-submit-price add-new-items-price">
                                                                                    <button><img src="public/images/fi-sr-paper-plane.svg" alt="">Send Now</button>
                                                                                    <div class="loading" style="display: none; text-align: center;">
                                                                                        <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                                                            <circle fill="#000" stroke="none" cx="6" cy="50" r="6">
                                                                                                <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>    
                                                                                            </circle>
                                                                                            <circle fill="#000" stroke="none" cx="26" cy="50" r="6">
                                                                                                <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>       
                                                                                            </circle>
                                                                                            <circle fill="#000" stroke="none" cx="46" cy="50" r="6">
                                                                                                <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>     
                                                                                            </circle>
                                                                                        </svg>
                                                                                    </div>
                                                                                    <div class="check-icon" style="display: none; text-align: center;">
                                                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="check" style="width: 28px;">
                                                                                            <rect width="25" height="25" fill="none"></rect><polyline fill="none" stroke="#60cb97" stroke-linecap="round" stroke-linejoin="round" stroke-width="24" points="216 72.005 104 184 48 128.005"></polyline>
                                                                                        </svg>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                <?php
                                                            }
                                                        
                                                        ?>

                                                        <div class="form-wrapper rewrite-price-form" style="display: none;">
                                                            <div class="mt-5 d-flex align-items-center justify-content-between" style="gap: 15px;">
                                                                <div class="msg">
                                                                    <a href="?show=home&add-to-chat=<?php echo $notification["buyer_id"]; ?>">
                                                                        <img src="public/images/messages.svg" alt="">
                                                                        Send Message
                                                                    </a>
                                                                </div>
                                                                <div class="w-100">
                                                                    <div class="w-100 mb-5 d-flex gap-2 offer-contents">
                                                                        <div class="add-attachment">
                                                                            <label for="file-input-<?php echo $project_id; ?>">
                                                                                <input type="file" id="file-input-<?php echo $project_id; ?>" class="file-input" accept="image/*, application/pdf">
                                                                                <span id="file-text">Add Attachment</span>
                                                                            </label>
                                                                        </div>
                                                                        <span class="file-contents">Show</span>
                                                                    </div>
                                                                    <div class="w-100 btn-submit-price">
                                                                        <button><img src="public/images/fi-sr-paper-plane.svg" alt="">Send Now</button>
                                                                        <div class="loading" style="display: none; text-align: center;">
                                                                            <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                                                <circle fill="#000" stroke="none" cx="6" cy="50" r="6">
                                                                                    <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>    
                                                                                </circle>
                                                                                <circle fill="#000" stroke="none" cx="26" cy="50" r="6">
                                                                                    <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>       
                                                                                </circle>
                                                                                <circle fill="#000" stroke="none" cx="46" cy="50" r="6">
                                                                                    <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>     
                                                                                </circle>
                                                                            </svg>
                                                                        </div>
                                                                        <div class="check-icon" style="display: none; text-align: center;">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="check" style="width: 28px;">
                                                                                <rect width="25" height="25" fill="none"></rect><polyline fill="none" stroke="#60cb97" stroke-linecap="round" stroke-linejoin="round" stroke-width="24" points="216 72.005 104 184 48 128.005"></polyline>
                                                                            </svg>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php
                                            }
                                        }
                                    }else {
                                        ?>
                                            <div class="text-center mt-50">
                                                <p class="text-muted">Nothing to see here!</p>
                                            </div>
                                        <?php
                                    }
                                ?>
                            </div>
                            <div class="">
                                <?php
                                    if($notifications && $notifications["total"] >= 20) {
                                        ?>
                                            <div class="load-more-notifications text-center mt-15 mb-5" style="display: none;">
                                                <a href="javascript:void(0);">
                                                    <span class="text-muted">Load More</span>
                                                </a>
                                            </div>
                                        <?php
                                    };
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <footer>
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>
                                    
                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });

        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });

        $(".chat-history ul li").animate({ scrollTop:3031 },"fast");

        $(".file-input").on("change", function (event) {
            const target = $(this);

            if ($(this).val()) {
                // $(this).parent().prev().text('File Uploaded')
                $(this).next().text('Edit')

                const file = event.target.files[0];
                const reader = new FileReader();

                reader.onload = function(event) {
                    const contents = event.target.result;

                    target.closest('.offer-contents').addClass("file-attached");
                    target.closest('.offer-contents').find('.file-contents').attr("filedataurl", contents);
                };
                
                reader.onerror = function(event) {
                    console.log("File could not be read! Code");
                    target.closest('.offer-contents').removeClass("file-attached");

                    target.closest('.offer-contents').find('.file-contents').removeAttr("filedataurl");
                };

                if (file) {
                    reader.readAsDataURL(file); // Read file as data URL
            }
            } else {
                // $(this).parent().prev().text('')
                $(this).next().text('Add Attachment')
                $(this).closest('.offer-contents').removeClass("file-attached");

                target.closest('.offer-contents').find('.file-contents').removeAttr("filedataurl");
            }

        });

        $(".file-contents").on("click", function() {
            const filedataurl = $(this).attr('filedataurl')
            // console.log(filedataurl);

            if (filedataurl) {
                const newWindow = window.open();

                if (filedataurl.startsWith("data:image")) {
                    newWindow.document.write('<img src="' + filedataurl + '" style="max-width: 100%;" />');
                 } else if (filedataurl.startsWith("data:application/pdf")) {
                    newWindow.document.write('<embed src="' + filedataurl + '" type="application/pdf" style="width: 100%; height: 100%" />');
                } else {
                    console.error("Unsupported file type.");
                }
            } else {
                console.error("No image data found.");
            }
        });

        $("#attached-file").on("change", function () {
            let maxFileSizeMB = 10;
            let maxFileSizeBytes = maxFileSizeMB * 1024 * 1024;

            let $uploadButton = $(".file-upload-button");
            let $attachedFileName = $(".attached-file-name");
            let fileName = $(this).val().split("\\").pop();

            if ($(this).val()) {
                let uploadedFile = this.files[0];
                if(uploadedFile.size <= maxFileSizeBytes) {
                    $uploadButton.addClass("file-attached");
                    $attachedFileName.text(fileName);
                }else {
                    alert("Please upload file less than 10MB. Thanks!!");
                }
            } else {
                $uploadButton.removeClass("file-attached");
                $attachedFileName.text('');
            }
        });

        function updateChatUser() {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "updateChatUser"
                },
                success: function(data) {
                    let res = JSON.parse(data);
                    // console.log(res);

                    if(res.status === "success") {
                        $(".people-list ul").html(res.result);
                    }
                    // if(res.is_found == true) {
                    //     $(".load-notifications").show();
                    // }
                    // data && $(".chat-history ul li").append(data);
                }
            });
        }

        var termsToCheck = ["email", "skype", "phone", "contact", "details", "telephone", "number", "address"];

        function checkForContactDetails(text) {

            var lowercaseText = text.toLowerCase();
            var containsTerms = false;

            for (var i = 0; i < termsToCheck.length; i++) {
                var term = termsToCheck[i];
                if (lowercaseText.includes(term)) {
                    containsTerms = true;
                    break;
                }
            }

            // Check for words ending with "@"
            if (text.match(/\w+@$/)) {
                containsTerms = true;
            }

            var warningMessage = $('#warning-message');
            if (containsTerms) {
                // console.log("violations are not allowed");
                $(".warning-msg").show();
            } else {
                // console.log("you are going correctly");
                $(".warning-msg").hide();
            }
        }

        $('#msg-input').on('input', function() {
            var text = $(this).val();
            checkForContactDetails(text);
        });

        $("#send-msg").click(function() {
            var $msg_input = $("#msg-input"); // Corrected selector
            var $file = $("#attached-file"); // Corrected selector
            var $receiver = $("#receiver_id"); // Corrected selector

            if ($msg_input.val().trim() !== "" || $file[0].files[0]) {
                let $attachedFileName = $(".attached-file-name");

                var formData = new FormData(); // Create a new FormData object
                formData.append('message_text', $msg_input.val()); // Append the message value
                formData.append('file', $file[0].files[0]); // Append the selected file
                formData.append('receiver_id', $receiver.val()); // Append the message value
                formData.append('action', 'SEND_MESSAGE'); // Append the message value
    
                $.ajax({
                    url: "app/core/messages.php",
                    type: "POST",
                    data: formData,
                    processData: false, // Prevent jQuery from processing data
                    contentType: false, // Let the browser set the content type
                    beforeSend: function() {
                        // console.log("Sending...");
                        $("#send-msg").hide();
                        $("#sending-msg").show();
                    },
                    success: function(data) {
                        console.log(data);
                    },
                    complete: function() {
                        // console.log("Sent successfully");
                        $msg_input.val('');
                        $file.val('');
                        
                        // Scroll to bottom
                        let targetSection = $(".chat-history ul li");
                        let targetBottom = targetSection[0].scrollHeight
                        $(".chat-history ul li").animate({ scrollTop: targetBottom },"fast");

                        $attachedFileName.text('');
                        $attachedFileName.hide();

                        $("#send-msg").show();
                        $("#sending-msg").hide();
                    }
                });
            }else {
                alert("Please enter a message or attach a file");
            }
            
        });

        $(".load-more-msg").click(function() {
            let receiver_id = $("#receiver_id").val();
            let first_id = $(".chat-msg").first().data("id");

            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "loadMoreMessages",
                    receiver_id: receiver_id,
                    first_id: first_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if(res.status === 'success') {
                        res.result && $(".chat-history .chats").prepend(res.result);

                        if(res.total < 20) {
                            $(".load-more-msg").hide();
                        }
                    }
                }
            });
        });

        function updateMessages(receiver_id, last_msg_id) {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "updateMessages",
                    receiver_id: receiver_id,
                    last_msg_id: last_msg_id
                },
                success: function(data) {
                    // console.log(data);
                    if(data) {
                        $(".chat-history ul li .chats").append(data);

                        // Scroll to bottom
                        var element = $('.chat-history ul li');
                        var positionFromBottom = element.prop('scrollHeight') - element.scrollTop() - element.height();

                        console.log(positionFromBottom);
                        if(positionFromBottom < 150) {
                            let targetBottom = element[0].scrollHeight
                            $(".chat-history ul li").animate({ scrollTop: targetBottom + 100 },"fast");
                        }
                    }
                }
            });
        }

        $(".load-more-notifications").click(function() {
            let last_id = $(".notifs .list").last().data("id");

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "loadMoreNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    let res = JSON.parse(data);
                    
                    if(res.has_result) {
                        $(".notifs .lists-container").append(res.data);

                        if(res.total < 10)  {
                            $(".load-more-notifications").hide();
                        }
                    }
                }
            });
        });

        $(".load-notifications a").click(function(){
            // $(".load-notifications").hide();
            updateNewNotifications();
        });

        function checkNewNotifications() {
            // console.log("Checking new notifications");

            let last_id = $(".notifs .list").first().data("id");

            if(!last_id) {
                last_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "checkNewNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    let res = JSON.parse(data);
                    
                    if(res.is_found == true) {
                        $(".load-notifications").show();
                    }else {
                        $(".load-notifications").hide();
                    }
                }
            });
        }
        
        function updateNewNotifications() {
            // console.log("Checking new notifications");
            let last_id = $(".notifs .list").first().data("id");

            if(!last_id) {
                last_id = 0;
            }
    
            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "getNewSellerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.status == 'success') {
                        $(".no-results").hide();
                        res.data && $(".notifs .lists-container").prepend(res.data);
    
                        $(".load-notifications").hide();
                        $(".notif-alert").hide();
                    }
                }
            });
        }

        function updatePriceIOffer(type, project_id) {
            let formData = new FormData();

            formData.append('action', 'getPriceIOffer');

            if(type === 'rewrite-price') {
                formData.append('project_id', project_id);
            }else {
                let last_id = $(".price-i-offer").first().data("id");
                // console.log(last_id);

                if(last_id) {
                    formData.append('last_id', last_id);
                }else {
                    formData.append('last_id', 0);
                }
            }

            $.ajax({
                url: "app/core/projects.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.status == 'success') {
                        $(".no-data-found").hide();
                        var element = $('.price-i-offer[data-project="' + res.project_id + '"]');
                        
                        if(type === 'rewrite-price') {
                            element.replaceWith(res.data);
                        }else {
                            if (element.length > 0) {
                                element.remove();
                            }
    
                            res.data && $(".offers-wrapper").prepend(res.data);
                        }
                    }
                }
            });
        }

        // updatePriceIOffer('rewrite-price', 377);

        setInterval(function(){
            let receiver_id = $("#receiver_id").val();
            
            if(receiver_id) {
                let last_msg_id = $(".chat-msg").last().data("id");
                if(!last_msg_id) {
                    last_msg_id = 0;
                }

                // console.log("waiting for new message!");
                updateMessages(receiver_id, last_msg_id);
            }

            checkNewNotifications();
            updateChatUser();
            getUnreadMessages();
        }, 1500);

        $("#priceInput").on("input", function() {
            var inputValue = $(this).val();
            
            // Remove any non-numeric characters except dots
            var cleanedValue = inputValue.replace(/[^0-9.]/g, '');
            
            // Ensure only one dot is allowed
            var dotCount = cleanedValue.split('.').length - 1;
            if (dotCount > 1) {
                cleanedValue = cleanedValue.slice(0, -1);
            }
            
            // console.log(cleanedValue);
            // Update the input value
            // $(this).val(cleanedValue);
        });

        // Add event listener for product price and quantity input fields
        $("input[name='product_price[]'], input[name='quantity[]']").on('input', function() {
            // Get the parent container of the input fields
            var container = $(this).closest('.price');
            
            // Find the input fields for product price, quantity, and total price within the container
            var productPrice = parseFloat(container.find("input[name='product_price[]']").val());
            var quantity = parseFloat(container.find("input[name='quantity[]']").val());
            var totalPriceInput = container.find("input[name='total_price[]']");

            // Calculate total price
            var totalPrice = productPrice * quantity;

            // Update the total price input field with the calculated value
            totalPriceInput.val(totalPrice);

            // console.log(totalPrice);
        });

        // Add event listener for product price and quantity input fields
        $("input[name='new_product_price[]'], input[name='new_quantity[]']").on('input', function() {
            // Get the parent container of the input fields
            var container = $(this).closest('.price');
            
            // Find the input fields for product price, quantity, and total price within the container
            var productPrice = parseFloat(container.find("input[name='new_product_price[]']").val());
            var quantity = parseFloat(container.find("input[name='new_quantity[]']").val());
            var totalPriceInput = container.find("input[name='new_total_price[]']");

            // Calculate total price
            var totalPrice = productPrice * quantity;

            // Update the total price input field with the calculated value
            totalPriceInput.val(totalPrice);

            // console.log(totalPrice);
        });

        // Offer Price
        $(document).on('click','.btn-submit-price', function() {
            // let notif_id =$(this).parent().parent().data("id");
            let price_type = $(this).data("type");

            
            var $list = $(this).closest(".list");
            
            if($(this).hasClass('add-new-items-price')) {
                // $list.find(".form-wrapper.rewrite-price-form .new-price-form").remove();
            }
            // List id
            var project_id = $list.data("project");
            var notif_id = $list.data("id");

            // Get selected file
            var selectedFile = $list.find(".file-input")[0].files[0];

            let offerType = "new-offer";
            if($(this).hasClass('add-new-items-price')) {
                offerType = "rewrite-items";
                var inputNames = ["new_product_price", "new_delivery_price", "new_delivery_date", "new_payment_term"];
            }else {
                var inputNames = ["product_price", "delivery_price", "delivery_date", "payment_term"];
            }

            var allInputsNotEmpty = {};

            inputNames.forEach(function(inputName) {
                allInputsNotEmpty[inputName] = true;
                $list.find('input[name="' + inputName + '[]"]').each(function() {
                    if ($(this).val() === '') {
                        allInputsNotEmpty[inputName] = false;
                        return false; // Exit the loop early if any input is empty
                    }
                });
            });

            // Check if any input is empty
            var anyInputEmpty = Object.values(allInputsNotEmpty).some(function(value) {
                return value === false;
            });


            var $msgarea = $list.find(".msg-area");
            if (anyInputEmpty) {
                if (!$msgarea.find('.message').length) {
                    var message = "Please make sure you added data to all the fields.";
                    $msgarea.prepend("<div class='message mb-2' style='color: red; padding: 0 8px;'>" + message + "</div>");
                }
            } else {
                $msgarea.find('.message').remove();

                let formData = new FormData();
                formData.append('project_id', project_id);
                formData.append('notif_id', notif_id);
                formData.append('attached-file', selectedFile);

                if($(this).hasClass('add-new-items-price')) {
                    $list.find('input[name="new_vat_input[]"]').each(function() {
                        const value = $(this).is(':checked') ? 1 : 0;
                        formData.append('vat_input[]', value);
                    });

                    $list.find('input[name="new_item_id[]"]').each(function() {
                        formData.append('item_id[]', $(this).val());
                    });

                    $list.find('input[name="new_product_type[]"]').each(function() {
                        formData.append('product_type[]', $(this).val());
                    });

                    $list.find('input[name="new_product_price[]"]').each(function() {
                        formData.append('product_price[]', $(this).val());
                    });

                    $list.find('input[name="new_delivery_price[]"]').each(function() {
                        formData.append('delivery_price[]', $(this).val());
                    });

                    $list.find('input[name="new_total_price[]"]').each(function() {
                        formData.append('toal_price[]', $(this).val());
                    });

                    $list.find('input[name="new_delivery_date[]"]').each(function() {
                        formData.append('delivery_date[]', $(this).val());
                    });

                    $list.find('input[name="new_payment_term[]"]').each(function() {
                        formData.append('payment_term[]', $(this).val());
                    });

                    formData.append('action', 'NEW_ITEMS_PRICE');
                }else {
                    $list.find('input[name="vat_input[]"]').each(function() {
                        const value = $(this).is(':checked') ? 1 : 0;
                        formData.append('vat_input[]', value);
                    });

                    $list.find('input[name="item_id[]"]').each(function() {
                        formData.append('item_id[]', $(this).val());
                    });

                    $list.find('input[name="product_type[]"]').each(function() {
                        formData.append('product_type[]', $(this).val());
                    });

                    $list.find('input[name="product_price[]"]').each(function() {
                        formData.append('product_price[]', $(this).val());
                    });

                    $list.find('input[name="delivery_price[]"]').each(function() {
                        formData.append('delivery_price[]', $(this).val());
                    });

                    $list.find('input[name="toal_price[]"]').each(function() {
                        formData.append('toal_price[]', $(this).val());
                    });

                    $list.find('input[name="delivery_date[]"]').each(function() {
                        formData.append('delivery_date[]', $(this).val());
                    });

                    $list.find('input[name="payment_term[]"]').each(function() {
                        formData.append('payment_term[]', $(this).val());
                    });

                    formData.append('action', 'OFFER_PRICE');
                }

                // const formDataObject = Object.fromEntries(formData);
                // console.log(formDataObject);

                $.ajax({
                    url: "app/core/notifications.php",
                    type: "POST",
                    data: formData,
                    processData: false, // Prevent jQuery from processing data
                    contentType: false, // Let the browser set the content type
                    beforeSend: function() {
                        // console.log("Sending...");
                        $list.find(".btn-submit-price button").hide();
                        $list.find(".price input").prop('disabled', true);
                        $list.find(".loading").show();
                    },
                    success: function(data) {
                        // let res = JSON.parse(data);
                        console.log(data);
                    },
                    complete: function() {
                        // console.log("Sent successfully");
                        // $list.find(".btn-submit-price").hide();
                        $list.find(".check-icon").show();
                        $list.find(".loading").hide();

                        

                        if(offerType === "rewrite-items") {
                            // Disable the input
                            $list.find('input[name="new_vat_input[]"]').each(function() {
                                $(this).prop('disabled', true);
                            });

                            // $('.price-i-offer[data-project="' + project_id + '"]').remove();
                            updatePriceIOffer('rewrite-price', project_id);
                        }else {
                            // Disable the input
                            $list.find('input[name="vat_input[]"]').each(function() {
                                $(this).prop('disabled', true);
                            });

                            updatePriceIOffer('new-price');
                        }

                        // disabled .file-input
                        $list.find(".file-input").prop('disabled', true);
                    }
                });
            }
        });

        $(".rewrite-price").click(function() {
            // Find the parent elements for the clicked "Rewrite" link
            var $parent = $(this).closest(".list");
            $parent.find(".offer-data, .rewrite-price-form, .form-bottom").toggle();

            $parent.find(".new-material-inputs").remove();
        });
        
        function getUnreadMessages() {
            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "getUnreadMessages",
                },
                success: function(data) {
                    let res = JSON.parse(data);
                    
                    if(res.status == "success") {
                        if(res.unread > 0) {
                            $(".unread-notif-counter").text(res.unread);
                            $(".unread-notif-counter").show();
                        }
                    }
                }
            });
        }

        $(document).on('click','.mark-notifications', function() {
            let notif_id = $(this).data("id");
            var imgElement = $(this).find("img");

            let src = imgElement.attr("src");

            let type = 1;
            if(src === 'public/images/star.svg') {
                type = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "markNotification",
                    notif_id: notif_id,
                    type: type
                },
                success: function(data) {
                    // console.log(data);
                    // let res = JSON.parse(data);

                    if(type === 1) {
                        imgElement.attr('src', 'public/images/star.svg');
                    }else {
                        imgElement.attr('src', 'public/images/star-light.svg');
                    }
                }
            });
        });
    });
</script>