<?php
    session_start();

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    include './load.php';
    include './templates/header.php';
    include './app/models/Messages.php';
    include './app/models/Notifications.php';
    include './app/models/Projects.php';
    include './app/models/Products.php';
    include './app/models/Settings.php';

    if(!isBuyer()) {
        header("Location: index.php");
        exit();
    }

    $uid = $_SESSION["user_id"];

    $msgModel = new Messages();
    $notifModel = new Notifications();
    $projectsModel = new Projects();
    $productModel = new Products();
    $settings = new Settings();
    // echo json_encode($messages);

    if(isset($_GET["show"])) {
        $_SESSION["show"] = $_GET["show"];

        if($_GET["show"] === "add") {
            $_SESSION["add-new-project"] = 'show';
        }
    }

    $last_project_created = $projectsModel->lastProjectCreated($uid);

    if($last_project_created) {
        // $added_on = $projectData["added_on"];
    
        // Get the current timestamp
        $currentTimestamp = time();
    
        // Calculate the difference in seconds
        $timeDifference = $currentTimestamp - strtotime($last_project_created);
    
        if ($timeDifference >= 7 * 24 * 3600) {
            $_SESSION["add-new-project"] = 'show';
        }
    }


    if(isset($_GET["notif_type"])) {
        $_SESSION["notif_type"] = $_GET["notif_type"];
    }else {
        $_SESSION["notif_type"] = 'all';
    }

    if(isset($_GET["add-to-chat"])) {
        $seller_id = $_GET["add-to-chat"];
        $addToChat = $msgModel->addToChat($uid, $seller_id);

        if($addToChat) {
            $_SESSION["chat_id"] = $seller_id;

            $msgModel->readAll($uid);
        }
    }

    if(isset($_GET["chat_id"])) {
        $_SESSION["chat_id"] = $_GET["chat_id"];

        $msgModel->readAll($uid);
    }

    if(!(isset($_GET["add-to-chat"]) || isset($_GET["chat_id"]))) {
        unset($_SESSION["chat_id"]);
    }

    if(isset($_GET["update_notif_status"]) && !empty($_GET["update_notif_status"])) {
        $project_id = $_GET["project_id"];
        $seller_id = $_GET["seller_id"];
        $offer_id = $_GET["offer_id"];
        $item_id = $_GET["item_id"];
        $status = $_GET["status_type"];
        $res = $projectsModel->updateStatus($project_id, $offer_id, $item_id, $seller_id, $status);

        // echo json_encode($res);
    }

    $messages = null;
    if(isset($_SESSION["chat_id"])) {
        $user1 = $_SESSION["user_id"];
        $user2 = $_SESSION["chat_id"];

        $chatUser = $msgModel->chatUserDetails($user2);
        $messages = $msgModel->getMessages($user1, $user2);
    }

    if(isset($_GET["action"]) && $_GET["action"] === "publish-project") {
        $pid = $_GET["pid"];

        $getProject = $projectsModel->getProject($pid);

        if($getProject && $getProject["status"] === '0') {
            $projectsModel->publishProduct($pid);

            // Select all project items
            $projectItems = $projectsModel->getProjectItems($pid);

            $sellerName = 'one of the register buyer who is';
            if($settings->get_option("hide-seller-name") === "1") {
                $sellerName = $_SESSION["userData"]["company_name"];
            }
    
            foreach($projectItems as $item) {
                $product_type = $item["product_type"];
                $sellers = $projectsModel->searchByKeywords($product_type);
                // echo json_encode($sellers);
                // exit;
    
                if($sellers) {
                    foreach($sellers as $seller) {
                        $seller_id = $seller["user_id"];
                        $products_list = $seller["products_list"];

                        $subject = "Looking for a new price offer";
                        $message = '<!DOCTYPE html>
                            <html>
                                <head>
                                    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                                </head>
                                <body><div style="background-color: #f6f6f6;">
                                    <div style="width: 600px; margin: auto; background-color: #fff;">
                                        <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                            <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                        </div>
                                        <div class="template-body" style="">
                                            <div style="padding: 0 80px">
                                                <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                                <div class="image" style="margin: auto; padding: 30px 0;">
                                                    <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                </div>
                                            </div>
                                            <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                                <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW OPPORTUNITY</h1>
                                                <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from '. $sellerName .' looking to buy:</h3>
                                                <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                    <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$getProject["project_name"].'</h3>
                                                    <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$getProject["post_code"].'</p>
                                                    <div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';

                        $products_list_array = explode(',', $products_list);

                        // Filter $projectItems based on product types in $products_list_array
                        $matchingProducts = array_filter($projectItems, function ($product) use ($products_list_array) {
                            return in_array($product['product_type'], $products_list_array);
                        });
                        
                        // Reset array keys
                        $matchingProducts = array_values($matchingProducts);

                        foreach($matchingProducts as $matchingProduct) {
                            $itemWidth = '100%';
                            if(count($matchingProducts) > 1) {
                                $itemWidth = '50%';
                            }
            
                            $quantity = '';
                            if($matchingProduct["quantity"]) {
                                $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.$matchingProduct["quantity"].'</p>';
                            }
            
                            $unit = '';
                            if($matchingProduct["unit"]) {
                                $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.$matchingProduct["unit"].'</p>';
                            }
            
                            $date_required = '';
                            if($matchingProduct["date_required"]) {
                                $date_required = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.$matchingProduct["date_required"].'</p>';
                            }

                            $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($matchingProduct["open_to_similar_brands"]).'</p>';
            
                            // $product = $productModel->getProductByName($matchingProduct["product_type"]);

                            // if(!empty($matchingProduct["product_image"])) {
                            //     $img_url = BASE_URL . $matchingProduct["product_image"];
                            // }else {
                            //     if(!empty($product["image"])) {
                            //         $img_url = BASE_URL . $product["image"];
                            //     }else {
                            //         $img_url = 'https://rakanonline.com/wp-content/uploads/2022/08/default-product-image.png';
                            //     }
                            // }

                            // <div class="">
                            //     <img style="width: 50px; margin-bottom: 5px;" src="'.$img_url.'" alt="'.ucfirst($matchingProduct["product_type"]).'" />
                            // </div>

                            $attached_file = '';
                            if(!empty($matchingProduct["product_image"])) {
                                $attached_file = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 14px;text-align: left;"><a href="'. BASE_URL . $matchingProduct["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                            }
                            
                            $message .= '<div class="product-item" style="box-sizing: border-box; width: '.$itemWidth.'; display: inline-block; padding: 7.5px;">
                                <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                    
                                    <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($matchingProduct["product_type"]).'</h3>
                                    <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> '.$matchingProduct["description"].'</p>
                                    '.$open_to_similar_brands.'
                                    '.$quantity.'
                                    '.$unit.'
                                    '.$date_required.'
                                    '.$attached_file.'
                                </div>
                            </div>';
                        }
                
                        $message .= '</div>
                                        </div>
                                            <div class="button" style="text-align: center;">
                                                <a href="https://www.connectionsys.co.uk/">
                                                    <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                        <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                        <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                    </div>
                                </div>
                            </div>
                            </body></html>';
                        
                        $isExists = $projectsModel->checkNotification($pid, $seller_id);
                        if(!$isExists) {
                            $email = $seller["email"];
                            $company_name = $seller["company_name"];

                            $project_name = $getProject["project_name"];
                            $description = $item["description"];

                            $desc = json_encode($description);
                            $projectsModel->addToNofications($project_name, $desc, $pid, $seller_id);
        
                            $mail = new PHPMailer();
                            try {
                                //Server settings
                                // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                                $mail->isSMTP();                                            //Send using SMTP
                                $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                                $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                                $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                                $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                                $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                            
                                //Recipients
                                $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                                $mail->addAddress($email, $company_name);     //Add a recipient
                                // $mail->addAddress('ellen@example.com');               //Name is optional
                                // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                            
                                //Content
                                $mail->isHTML(true);                                  //Set email format to HTML
                                $mail->Subject = $subject;
                                $mail->Body    = $message;
                                // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                            
                                $mail->send();
                                // echo 'Message has been sent';
                            } catch (Exception $e) {
                                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                                exit;
                            }
                        }
                    }
                }
            }
        }else {
            // echo "Project published already!";
        }
    }

    if(!isset($_SESSION["vat-type"])) {
        $_SESSION["vat-type"] = 'with-vat';
    }

    if(isset($_GET["vat-type"])) {
        $_SESSION["vat-type"] = $_GET["vat-type"];
    }

    if(!isset($_SESSION["add-new-project"])) {
        $_SESSION["add-new-project"] = 'hide';
    }
?>

<!-- //**\\ -->
<link rel="stylesheet" href="public/css/image-uploader.css">

<?php
    if($settings->get_option('hide-buyer-name') === '0') {
    ?>
<style>
    .hide-company-name {
        display: none !important;
    }
</style>
    <?php
    }
?>

<style>
    .toggle-switch {
    position: relative;
    display: inline-block;
    width: 50px;
    height: 25px;
  }
  
  .switch-input {
    display: none;
  }
  
  .switch-label {
    display: block;
    width: 100%;
    height: 100%;
    border-radius: 17px;
    background-color: #ccc;
    position: relative;
    cursor: pointer;
  }
  
  .switch-label:before {
    content: '';
    position: absolute;
    top: 2px;
    left: 2px;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    background-color: white;
    transition: transform 0.3s ease;
  }
  
  .switch-input:checked + .switch-label:before {
    transform: translateX(26px);
  }
  
  .switch-label:active:before {
    width: 22px;
  }

  .switch-input:checked + .switch-label {
    background: green;
  }
  
</style>

<style>
    .box-button {
        height: 45px;
        display: flex;
        align-items: center;
        border: 1px solid #ccc;
        padding: 6px 10px;
        border-radius: 5px;
        margin: auto;
    }

    .label {
        margin-right: 20px;
    }

    .radio-container {
        display: flex;
    }

    .radio-container input[type="radio"] {
        display: none;
    }

    .radio-container label {
        padding: 2px 8px;
        border: 1px solid #ccc;
        border-radius: 5px;
        margin-right: 10px;
        cursor: pointer;
        margin-bottom: 0;
    }

    .radio-container input[type="radio"]:checked + label {
        background-color: #4CAF50;
        color: white;
        border: 1px solid #4CAF50;
    }

    .radio-container input[type="radio"]:checked + label.no {
        background-color: red;
        border: 1px solid red;
    }
</style>

<style>
    
</style>

<div class="buyer d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item active">
                        <a href="?action=home">Projects</a>
                    </div>
                    <div class="item" id="chatBtn">
                        <a href="product-list.php">Products</a>
                    </div>
                    <div class="item" id="addBtn">
                        <a href="search.php">Search</a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left d-flex gap-4 align-items-center">
                    <div class="header-title">
                        <h3 class="m-0">Buyer Page</h3>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                    <!-- <div class="d-flex flex-column align-items-center justify-between">
                        <small class="text-muted"><?php echo $_SESSION["vat-type"] === 'with-vat' ? 'With VAT' : 'Without VAT' ?></small>
                        <div class="toggle-switch inline">
                            <input type="checkbox" id="local-pickup" class="switch-input vat-type-switch" <?php echo $_SESSION["vat-type"] === 'with-vat' ? 'checked' : '' ?> />
                            <label for="local-pickup" class="switch-label"></label>
                        </div>
                    </div> -->
                </div>
                <div class="header-right">
                    <form action="search.php" method="GET">
                        <div class="search">
                            <div class="icon">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6.5 13C7.88314 13.0022 9.23062 12.5613 10.345 11.742H10.344C10.374 11.782 10.406 11.82 10.442 11.857L14.292 15.707C14.4795 15.8946 14.7339 16.0001 14.9991 16.0002C15.2644 16.0003 15.5189 15.895 15.7065 15.7075C15.8941 15.52 15.9996 15.2656 15.9997 15.0004C15.9998 14.7351 15.8945 14.4806 15.707 14.293L11.857 10.443C11.8212 10.4068 11.7828 10.3734 11.742 10.343C12.5611 9.22927 13.002 7.88249 13 6.5C12.9995 4.77626 12.3145 3.12326 11.0956 1.90439C9.87674 0.68552 8.22374 0.000530138 6.5 0C4.77609 0 3.12279 0.684819 1.90381 1.90381C0.684819 3.12279 0 4.77609 0 6.5C0 8.22391 0.684819 9.87721 1.90381 11.0962C3.12279 12.3152 4.77609 13 6.5 13Z" fill="#60CB97"/>
                                </svg>
                            </div>
                            <input class="form-control" type="search" name="search_key" id="search-input" placeholder="Search your query">
                        </div>
                    </form>

                    <div class="notification">
                        <div class="dropdown-icon">
                            <div class="notif-alert" style="display: none;"></div>
                            <img src="public/images/notification-dark.svg" alt="">
                        </div>
                        <div class="notification-menu <?php echo isset($_GET["notif_type"]) ? 'active' : ''; ?>">
                            <div class="load-notifications" style="display: none;">
                                <a href="javascript:void(0);">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="reload">
                                        <path d="M21,11a1,1,0,0,0-1,1,8.05,8.05,0,1,1-2.22-5.5h-2.4a1,1,0,0,0,0,2h4.53a1,1,0,0,0,1-1V3a1,1,0,0,0-2,0V4.77A10,10,0,1,0,22,12,1,1,0,0,0,21,11Z"></path>
                                    </svg>
                                    <span>view new projects</span>
                                </a>
                            </div>
                            <div class="notif-header">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="notif-back-btn">
                                        <a href="javascript:void(0);">Back</a>
                                    </div>
                                    <div class="title">
                                        <h5  class="m-0">Notifications</h5>
                                    </div>
                                    <div class=""></div>
                                </div>
                            </div>
                            <div class="notifs">
                                <div class="d-flex align-items-center justify-content-end mr-10 mt-5 mb-5">
                                    <?php 
                                        if(isset($_SESSION["notif_type"]) && $_SESSION["notif_type"] === 'marked') {
                                            ?>
                                                <a href="?notif_type=all">
                                                    <img width="30" src="public/images/star.svg" alt="">
                                                </a>
                                            <?php
                                        }else {
                                            ?>
                                                <a href="?notif_type=marked">
                                                    <img width="30" src="public/images/star-light.svg" alt="">
                                                </a>
                                            <?php
                                        }
                                    ?>
                                </div>
                                <div class="lists-container">
                                    <?php
                                        $notifications = $notifModel->getBuyerNotifications($uid);

                                        if( $notifications) {
                                            foreach($notifications["data"] as $notification) {
                                                // echo json_encode($notification);
                                                ?>
                                                    <div class="list" data-id="<?php echo $notification["offer_id"]; ?>">
                                                        <div class="info d-flex align-items-center justify-content-between">

                                                            <div class="p-meta">
                                                                <div class="d-flex gap-4">
                                                                    <div class="notif-icon" style="width: 60px;">
                                                                        <img src="public/images/notification.svg" alt="">
                                                                    </div>
                                                                    <div class="" style="width: 100%;">
                                                                        <div class="title mb-10">
                                                                            <div class="">
                                                                                <h6><?php echo $notification["project_name"]; ?></h6>
                                                                                <span class="d-block mt-1 text-muted hide-company-name"><b><?php echo $notification["company_name"]; ?></b></span>
                                                                                <span class="text-muted"><b>Postcode:</b> <?php echo $notification["post_code"]; ?></span>
                                                                            </div>
                                                                            <div class="start">
                                                                                <!-- <img class="star-image" width="20" src="public/images/star-light.svg" alt=""> -->
                                                                                <a class="mark-notifications" href="javascript:void(0);" data-id="<?php echo $notification["offer_id"]; ?>">
                                                                                    <?php
                                                                                        if($notification["is_marked"] === '0') {
                                                                                            ?>
                                                                                                <img class="star-image" width="20" src="public/images/star-light.svg" alt="">
                                                                                            <?php
                                                                                        }else {
                                                                                            ?>
                                                                                                <img class="star-image" width="20" src="public/images/star.svg" alt="">
                                                                                            <?php
                                                                                        }
                                                                                    ?>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="desc">
                                                                    <?php
                                                                        $project_id = $notification["project_id"];
                                                                        $productItems = $projectsModel->getProjectItems($project_id);

                                                                        $offer_data = $notification["offer_data"];
                                                                        $dataArray = json_decode($offer_data, true);

                                                                        $x = 0;
                                                                        foreach ($dataArray as $item) {
                                                                            // echo json_encode($item);
                                                                            $x++;
                                                                            ?>
                                                                                <div class="amount">
                                                                                    <b class="d-flex gap-1 text-muted mr-10"><span><?php echo $x; ?>.</span><?php echo ucfirst($item['product']) ?>:</b>
                                                                                    <div style="margin-left: 20px;">
                                                                                        <table class="">
                                                                                            <tr>
                                                                                                <td>Product Price:</td>
                                                                                                <td>
                                                                                                    <b class="text-muted">£<?php echo number_format($item['price'], 2) ?> </b> <span class="text-muted"><?php echo $item["vat"] === '1' ? '(With VAT)' : '(Without VAT)' ?></span>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <?php
                                                                                                if(isset($item["delivery_price"]) && $item["delivery_price"] !== null) {
                                                                                                    ?>
                                                                                                        <tr>
                                                                                                            <td>Delivery Price:</td>
                                                                                                            <td>
                                                                                                                <b class="text-muted">£<?php echo number_format($item['delivery_price'], 2) ?> </b>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                            <?php
                                                                                                if(isset($item["delivery_date"]) && $item["delivery_date"] !== null) {
                                                                                                    ?>
                                                                                                        <tr>
                                                                                                            <td>Delivery Date:</td>
                                                                                                            <td>
                                                                                                                <b class="text-muted">£<?php echo $item['delivery_date']; ?> </b>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                            <?php
                                                                                                if(isset($item["payment_term"]) && $item["payment_term"] !== null) {
                                                                                                    ?>
                                                                                                        <tr>
                                                                                                            <td>Payment Term:</td>
                                                                                                            <td>
                                                                                                                <b class="text-muted">£<?php echo $item['payment_term']; ?> </b>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                        </table>
                                                                                    </div>
                                                                                </div>
                                                                            <?php
                                                                        }
                                                                    ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="msg-area d-flex align-items-center justify-content-between">
                                                            <div class="w-100 d-flex align-items-center justify-content-between">
                                                                <?php
                                                                    if(!empty($notification["attached_file"])) {
                                                                        ?>
                                                                            <div class="add-attachment">
                                                                                <a target="_blank" href="<?php echo $notification["attached_file"]; ?>">Attachment</a>
                                                                            </div>
                                                                        <?php
                                                                    }
                                                                ?>
                                                                <div class="msg" style="<?php echo empty($notification["attached_file"]) ? 'display: flex; width: 100%; justify-content: end;' : '' ?>">
                                                                    <a href="?add-to-chat=<?php echo $notification["seller_id"]; ?>">
                                                                        <img src="public/images/messages.svg" alt="">
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php
                                            }
                                        }else {
                                            ?>
                                                <div class="text-center mt-50">
                                                    <p class="no-results text-muted">Nothing to see here!</p>
                                                </div>
                                            <?php
                                        }
                                    ?>
                                </div>
                                <div class="">
                                    <?php

                                        if($notifications && $notifications["total"] >= 20) {
                                            ?>
                                                <div class="load-more-notifications">
                                                    <a href="javascript:void(0);">
                                                        <span>Load More</span>
                                                    </a>
                                                </div>
                                            <?php
                                        };
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="">
                                <a href="logout.php">
                                    <svg width="30" height="30" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_3_3720)">
                                        <path d="M17.214 22.5C16.8162 22.5 16.4346 22.658 16.1533 22.9393C15.872 23.2206 15.714 23.6022 15.714 24V28.5C15.714 29.6935 15.2399 30.8381 14.396 31.682C13.5521 32.5259 12.4075 33 11.214 33H7.5C6.30653 33 5.16193 32.5259 4.31802 31.682C3.47411 30.8381 3 29.6935 3 28.5V7.5C3 6.30653 3.47411 5.16193 4.31802 4.31802C5.16193 3.47411 6.30653 3 7.5 3H11.214C12.4075 3 13.5521 3.47411 14.396 4.31802C15.2399 5.16193 15.714 6.30653 15.714 7.5V12C15.714 12.3978 15.872 12.7794 16.1533 13.0607C16.4346 13.342 16.8162 13.5 17.214 13.5C17.6118 13.5 17.9934 13.342 18.2747 13.0607C18.556 12.7794 18.714 12.3978 18.714 12V7.5C18.7116 5.51161 17.9207 3.60534 16.5147 2.19933C15.1087 0.793323 13.2024 0.00238179 11.214 0H7.5C5.51161 0.00238179 3.60534 0.793323 2.19933 2.19933C0.793323 3.60534 0.00238179 5.51161 0 7.5L0 28.5C0.00238179 30.4884 0.793323 32.3947 2.19933 33.8007C3.60534 35.2067 5.51161 35.9976 7.5 36H11.214C13.2024 35.9976 15.1087 35.2067 16.5147 33.8007C17.9207 32.3947 18.7116 30.4884 18.714 28.5V24C18.714 23.6022 18.556 23.2206 18.2747 22.9393C17.9934 22.658 17.6118 22.5 17.214 22.5Z" fill="#60CB97"/>
                                        <path d="M34.3007 14.8189L27.4217 7.93987C27.2834 7.7966 27.1179 7.68233 26.9349 7.60371C26.7518 7.5251 26.555 7.48372 26.3558 7.48199C26.1567 7.48026 25.9592 7.51821 25.7748 7.59363C25.5905 7.66905 25.423 7.78043 25.2822 7.92127C25.1413 8.06211 25.0299 8.22959 24.9545 8.41393C24.8791 8.59828 24.8411 8.7958 24.8429 8.99497C24.8446 9.19414 24.886 9.39097 24.9646 9.57397C25.0432 9.75698 25.1575 9.9225 25.3007 10.0609L31.6952 16.4554L9.00024 16.5004C8.60242 16.5004 8.22089 16.6584 7.93958 16.9397C7.65828 17.221 7.50024 17.6025 7.50024 18.0004C7.50024 18.3982 7.65828 18.7797 7.93958 19.061C8.22089 19.3423 8.60242 19.5004 9.00024 19.5004L31.7822 19.4554L25.2977 25.9399C25.1545 26.0782 25.0402 26.2438 24.9616 26.4268C24.883 26.6098 24.8416 26.8066 24.8399 27.0058C24.8381 27.2049 24.8761 27.4025 24.9515 27.5868C25.0269 27.7711 25.1383 27.9386 25.2792 28.0795C25.42 28.2203 25.5875 28.3317 25.7718 28.4071C25.9562 28.4825 26.1537 28.5205 26.3528 28.5187C26.552 28.517 26.7488 28.4756 26.9319 28.397C27.1149 28.3184 27.2804 28.2041 27.4187 28.0609L34.2977 21.1819C35.1418 20.3384 35.6162 19.1942 35.6168 18.001C35.6173 16.8077 35.144 15.6631 34.3007 14.8189Z" fill="#60CB97"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_3_3720">
                                        <rect width="36" height="36" fill="white"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="change-password.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" data-name="Layer 1" viewBox="0 0 24 24" id="edit">
                                            <path d="M3.5,24h15A3.51,3.51,0,0,0,22,20.487V12.95a1,1,0,0,0-2,0v7.537A1.508,1.508,0,0,1,18.5,22H3.5A1.508,1.508,0,0,1,2,20.487V5.513A1.508,1.508,0,0,1,3.5,4H11a1,1,0,0,0,0-2H3.5A3.51,3.51,0,0,0,0,5.513V20.487A3.51,3.51,0,0,0,3.5,24Z"></path><path d="M9.455,10.544l-.789,3.614a1,1,0,0,0,.271.921,1.038,1.038,0,0,0,.92.269l3.606-.791a1,1,0,0,0,.494-.271l9.114-9.114a3,3,0,0,0,0-4.243,3.07,3.07,0,0,0-4.242,0l-9.1,9.123A1,1,0,0,0,9.455,10.544Zm10.788-8.2a1.022,1.022,0,0,1,1.414,0,1.009,1.009,0,0,1,0,1.413l-.707.707L19.536,3.05Zm-8.9,8.914,6.774-6.791,1.4,1.407-6.777,6.793-1.795.394Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Edit</span>
                                    </a>
                                </li>
                                <hr>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 6.35 6.35" id="logout" opacity="0.8">
                                            <path fill-rule="evenodd" d="M7.953.998a3.024 3.024 0 0 0-3.006 3.004V20a3.024 3.024 0 0 0 3.006 3.004h3.994A3.022 3.022 0 0 0 14.951 20v-4.002c0-1.334-2-1.334-2 0V20a.983.983 0 0 1-1.004 1.004H7.953A.983.983 0 0 1 6.95 20V4.002a.983.983 0 0 1 1.004-1.004h3.994a.983.983 0 0 1 1.004 1.004v4.002c0 1.334 2 1.334 2 0V4.002A3.022 3.022 0 0 0 11.947.998H7.953zM1.957 4.984a1 1 0 0 0-1.01 1.02v11.994a1 1 0 0 0 2 0V6.004a1 1 0 0 0-.982-1.02 1 1 0 0 0-.008 0zm16.037 2.004a1 1 0 0 0-.096.004 1 1 0 0 0-.6 1.713L19.595 11h-9.588a1.006 1.006 0 0 0-.104 0c-1.333.07-1.23 2.071.104 2.002h9.582l-2.29 2.287a1 1 0 1 0 1.411 1.418l4.002-4.002a1 1 0 0 0 0-1.41l-4.002-4a1 1 0 0 0-.715-.307z" color="#000" font-family="sans-serif" font-weight="400" overflow="visible" paint-order="stroke fill markers" transform="scale(.26458)" style="line-height:normal;font-variant-ligatures:normal;font-variant-position:normal;font-variant-caps:normal;font-variant-numeric:normal;font-variant-alternates:normal;font-feature-settings:normal;text-indent:0;text-align:start;text-decoration-line:none;text-decoration-style:solid;text-decoration-color:#000;text-transform:none;text-orientation:mixed;shape-padding:0;isolation:auto;mix-blend-mode:normal"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content <?php echo $_SESSION["show"] === "home" ? "show_all" : "show_single";  ?>">
        
            <div id="products-section" class="projects-list box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "products") ? "show" : ""; ?>">
                <div class="">
                    <div class="sec__heading d-flex align-items-center justify-content-between">
                        <h5>Projects List</h5>
                        <a href="?action=add-project">
                            <svg width="28" height="28" viewBox="0 0 36 36" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.27C3 29.745 6.255 33 11.715 33H24.27C29.73 33 32.985 29.745 32.985 24.285V11.715C33 6.255 29.745 3 24.285 3ZM24 19.125H19.125V24C19.125 24.615 18.615 25.125 18 25.125C17.385 25.125 16.875 24.615 16.875 24V19.125H12C11.385 19.125 10.875 18.615 10.875 18C10.875 17.385 11.385 16.875 12 16.875H16.875V12C16.875 11.385 17.385 10.875 18 10.875C18.615 10.875 19.125 11.385 19.125 12V16.875H24C24.615 16.875 25.125 17.385 25.125 18C25.125 18.615 24.615 19.125 24 19.125Z" fill="#60CB97"></path>
                            </svg>
                        </a>
                    </div>
                    <div class="inner-content">
                        <div class="projects">
                            <?php
                                $projects = $projectsModel->getProjects($uid, null, '0');

                                if($projects) {
                                    foreach($projects as $project) {
                                        // echo json_encode($project);
                                        $style = 'display: none;';
                                        if(isset($_GET["project_id"]) && $_GET["project_id"] == $project["id"]) {
                                            $style = '';
                                        }

                                        if(isset($_GET["active-project"]) && $_GET["active-project"] == $project["id"]) {
                                            $style = '';
                                        }

                                        $is_active = '';
                                        if(isset($_GET["action"]) && $_GET["action"] === "load-products") {
                                            if($_GET['pid'] === $project["id"]) {
                                                $is_active = 'active';
                                            }
                                        }
                                        ?>
                                        <div class="single-project <?php echo $is_active;  ?>" data-id="<?php echo $project["id"]; ?>" data-type="<?php echo isset($_GET["action"]) && ($_GET["action"] === 'edit-project' || $_GET['action'] === 'edit-product' || $_GET['action'] === 'add-product' || $_GET["action"] === 'add-project') ? 'redirect' : 'load-products' ?>">
                                            <div class="product-name">
                                                <div class="">
                                                    <h6 class="mb-0"><?php echo $project["project_name"]; ?> <?php echo $project["status"] === '0' ? '<small><sup class="text-muted project-status">[Draft]</sup></small>' : '' ?> </h6>
                                                    <?php
                                                        $projectItems = $projectsModel->getProjectItems($project["id"]);
                                                        $products_count = 0;
                                                        if($projectItems) {
                                                            $products_count = count($projectItems);
                                                        }
                                                    ?>

                                                    <span class="text-muted" style="font-size: 10px;"><?php echo $products_count; ?> Products</span>
                                                </div>
                                            </div>
                                            <div class="product-actions">
                                                <ul class="d-flex align-items-center justify-center-center list-unstyled mb-0" style="gap: 10px">
                                                    <li>
                                                        <a href="?action=edit-project&project-id=<?php echo $project["id"]; ?>" class="text-decoration-none" style="font-size: 13px;">Edit</a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:void(0);" class="delete-project">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="20" fill="red" id="delete"><path d="M24.2,12.193,23.8,24.3a3.988,3.988,0,0,1-4,3.857H12.2a3.988,3.988,0,0,1-4-3.853L7.8,12.193a1,1,0,0,1,2-.066l.4,12.11a2,2,0,0,0,2,1.923h7.6a2,2,0,0,0,2-1.927l.4-12.106a1,1,0,0,1,2,.066Zm1.323-4.029a1,1,0,0,1-1,1H7.478a1,1,0,0,1,0-2h3.1a1.276,1.276,0,0,0,1.273-1.148,2.991,2.991,0,0,1,2.984-2.694h2.33a2.991,2.991,0,0,1,2.984,2.694,1.276,1.276,0,0,0,1.273,1.148h3.1A1,1,0,0,1,25.522,8.164Zm-11.936-1h4.828a3.3,3.3,0,0,1-.255-.944,1,1,0,0,0-.994-.9h-2.33a1,1,0,0,0-.994.9A3.3,3.3,0,0,1,13.586,7.164Zm1.007,15.151V13.8a1,1,0,0,0-2,0v8.519a1,1,0,0,0,2,0Zm4.814,0V13.8a1,1,0,0,0-2,0v8.519a1,1,0,0,0,2,0Z"></path></svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                                
                                                <?php
                                                    if($project["status"] === '0') {
                                                        $btnStyle = 'gap: 5px;';
                                                        if($products_count < 1) {
                                                            $btnStyle = 'gap: 5px; display: none !important;';
                                                        }
                                                        ?>
                                                            <ul class="d-flex align-items-center justify-center-center list-unstyled mb-0 mt-2" style="<?php echo $btnStyle; ?>">
                                                                <li>
                                                                    <a href="javascript:void(0);" class="text-decoration-none publish-project" data-project-id="<?php echo $project["id"]; ?>" data-location="2" style="font-size: 13px; color: #60CB97;">Publish</a>
                                                                </li>
                                                            </ul>
                                                        <?php
                                                    }
                                                ?>
                                            </div>
                                        </div>
                                        <?php
                                    }
                                }else {
                                    ?>
                                        <span class="d-block text-center text-muted mt-50">Nothing to see here!</span>
                                    <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php
                if(isset($_GET["action"]) && $_GET["action"] === 'add-project') {
                    ?>
                        <div id="add-new-project" class="box-content" style="width: 73%; display: inline-flex;">
                            <div class="">
                                <div class="sec__heading">
                                    <h5>Add New Project</h5>
                                </div>
                                <div class="inner-content" style="padding: 10px !important;">
                                    <form id="new-project-form">
                                        <div class="d-flex justify-content-between" style="flex-direction: column; height: calc(100vh - 160px);">
                                            <div class="">
                                                <div class="form-group mb-20">
                                                    <label for="">Project Name</label>
                                                    <input type="text" class="form-control" name="project_name" required>
                                                </div>
                                                <div class="form-group mb-20">
                                                    <label for="">Project Description</label>
                                                    <textarea name="description" style="height: 150px;" class="form-control" id="" cols="30" rows="10" required></textarea>
                                                </div>
                                                <div class="form-group mb-20">
                                                    <label for="">Project Address</label>
                                                    <input type="text" class="form-control" name="post_code" required>
                                                </div>
                                            </div>
                                            <div class="">
                                                <button class="btn butn-primary" style="width: 100%;" type="submit">Save</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php
                }else {
                    
                    if(isset($_GET["project-id"])) {
                        $project_id = $_GET["project-id"];
                        $project = $projectsModel->getProject($project_id);
                    }

                    // echo json_encode($project);

                    if(isset($_GET["action"]) && $_GET["action"] === 'edit-project') {
                        ?>
                            <div id="edit-project-section" class="box-content" style="width: 73%; display: inline-flex;">
                                <div class="">
                                    <div class="sec__heading">
                                        <h5><?php echo $project["project_name"]; ?> - Project</h5>
                                    </div>
                                    <!-- <div class="d-flex flex-column justify-content-between" style="min-height: calc(100% - 300px);"> -->
                                    <div class="inner-content" style="padding: 10px !important;">
                                        <div class="">
                                            <ul class="list-unstyled d-flex flex-column" style="gap: 10px;">
                                                <li><span class="text-muted">Project Name:</span> <b><?php echo $project["project_name"]; ?></b></li>
                                                <li><span class="text-muted">Project Description:</span> <b><?php echo $project["project_description"]; ?></b></li>
                                                <li><span class="text-muted">Project Address:</span> <b><?php echo $project["post_code"]; ?></b></li>
                                            </ul>
                                        </div>
                                        <hr>
                                        <div class="heading d-flex align-items-center" style="gap: 10px;">
                                            <h6 class="mb-0" style="font-size: 16px;">Project's Product List</h6>
                                            <a href="?action=add-product&project-id=<?php echo $project_id; ?>">
                                                <svg width="28" height="28" viewBox="0 0 36 36" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.27C3 29.745 6.255 33 11.715 33H24.27C29.73 33 32.985 29.745 32.985 24.285V11.715C33 6.255 29.745 3 24.285 3ZM24 19.125H19.125V24C19.125 24.615 18.615 25.125 18 25.125C17.385 25.125 16.875 24.615 16.875 24V19.125H12C11.385 19.125 10.875 18.615 10.875 18C10.875 17.385 11.385 16.875 12 16.875H16.875V12C16.875 11.385 17.385 10.875 18 10.875C18.615 10.875 19.125 11.385 19.125 12V16.875H24C24.615 16.875 25.125 17.385 25.125 18C25.125 18.615 24.615 19.125 24 19.125Z" fill="#60CB97"></path>
                                                </svg>
                                            </a>
                                        </div>

                                        <?php
                                            $projectItems = $projectsModel->getProjectItems($project_id);
                                            // echo json_encode($projectItems);
                
                                                if(!$projectItems) {
                                                    ?>
                                                        <div class="mt-50 d-flex flex-column align-items-center">
                                                            <img src="public/images/group-64391.png" alt="">
                                
                                                            <div class="mt-20">
                                                                <h5>The project has no products yet.</h5>
                                                            </div>
                                                        </div>

                                                        <div class="mt-40 w-100">
                                                            <a href="?action=add-product&project-id=<?php echo $project_id; ?>">
                                                                <button class="btn butn-primary" style="width: 100%;" type="submit">Click here to add new Products</button>
                                                            </a>
                                                        </div>
                                                    <?php
                                                }else {
                                                    ?>
                                                        <div class="mt-40 d-flex flex-column align-items-start">
                                                            <ul class="list-unstyled d-flex flex-column" style="gap: 10px">
                                                                <?php
                                                                    $x = 0;
                                                                    foreach($projectItems as $item) {
                                                                        ?>
                                                                            <li class="item-product">
                                                                                <div class="d-flex">
                                                                                    <?php echo $x + 1; ?>. <?php echo ucfirst($item["product_type"]); ?>: <span class="text-muted" style="padding-left: 5px;"><?php echo $item["description"]; ?></span>
                                                                                    <ul class="d-flex list-unstyled ml-30" style="gap: 20px">
                                                                                        <li>
                                                                                            <a href="?action=edit-product&product-id=<?php echo $item["id"]; ?>&project-id=<?php echo $project["id"]; ?>" class="text-decoration-none" style="font-size: 13px;">Edit</a>
                                                                                        </li>
                                                                                        <li>
                                                                                            <a href="javascript:void(0);" class="delete-product" data-id="<?php echo $item["id"] ?>" data-project="<?php echo $project["id"]; ?>" data-type="1">
                                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="20" fill="red" id="delete"><path d="M24.2,12.193,23.8,24.3a3.988,3.988,0,0,1-4,3.857H12.2a3.988,3.988,0,0,1-4-3.853L7.8,12.193a1,1,0,0,1,2-.066l.4,12.11a2,2,0,0,0,2,1.923h7.6a2,2,0,0,0,2-1.927l.4-12.106a1,1,0,0,1,2,.066Zm1.323-4.029a1,1,0,0,1-1,1H7.478a1,1,0,0,1,0-2h3.1a1.276,1.276,0,0,0,1.273-1.148,2.991,2.991,0,0,1,2.984-2.694h2.33a2.991,2.991,0,0,1,2.984,2.694,1.276,1.276,0,0,0,1.273,1.148h3.1A1,1,0,0,1,25.522,8.164Zm-11.936-1h4.828a3.3,3.3,0,0,1-.255-.944,1,1,0,0,0-.994-.9h-2.33a1,1,0,0,0-.994.9A3.3,3.3,0,0,1,13.586,7.164Zm1.007,15.151V13.8a1,1,0,0,0-2,0v8.519a1,1,0,0,0,2,0Zm4.814,0V13.8a1,1,0,0,0-2,0v8.519a1,1,0,0,0,2,0Z"></path></svg>
                                                                                            </a>
                                                                                        </li>
                                                                                    </ul>
                                                                                </div>
                                                                            </li>
                                                                        <?php
                                                                    $x++;
                                                                }
                                                                ?>
                                                            </ul>
                                                        </div>
                                                    </div>

                                                    <?php
                                                    $is_edited = false;
                                                    foreach($projectItems as $item) {
                                                        if(!empty($item["edit_data"]) || $item["status"] === '0') {
                                                            $is_edited = true;
                                                            break;
                                                        }
                                                    }

                                                    if($project["status"] === '0' || $is_edited) {
                                                        ?>
                                                            <div class="mt-40 w-100 pl-15 pr-15">
                                                                <button class="btn butn-primary publish-project" data-project-id="<?php echo $project_id; ?>" data-location="1" style="width: 100%;" type="submit">Publish</button>
                                                            </div>
                                                        <?php
                                                    }
                                                }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php
                    } else if(isset($_GET["action"]) && $_GET["action"] === 'add-product') {
                        ?>
                            <div id="add-product-section" class="box-content" style="width: 73%; display: inline-flex;">
                                <div class="">
                                    <div class="sec__heading">
                                        <h5>Add New Product - <?php echo $project["project_name"]; ?></h5>
                                    </div>
                                    <div class="inner-content" style="padding: 10px !important;">
                                        <div class="d-flex justify-content-between pt-20 pb-10">
                                            <div class="">
                                                <h6>Project Description: <small class="text-muted"><?php echo $project["project_name"]; ?></small></h6>
                                            </div>
                                            <div class="">
                                                <h6>Project Address: <small class="text-muted"><?php echo $project["post_code"]; ?></small></h6>
                                            </div>
                                        </div>
                                        <hr>

                                        <div class="">
                                            <form id="new-product-form">
                                                <input type="hidden" name="project_id" value="<?php echo $project_id; ?>">
                                                <div class="form-group product-list mb-20">
                                                    <label class="text-muted" for="">Product Name</label>
                                                    <select class="form-control" name="product_name">
                                                        <?php
                                                            $products = $productModel->getAllProducts();
        
                                                            if($products) {
                                                                foreach($products as $product) {
                                                                    echo '<option value="'. strtolower($product["name"]). '">'. $product["name"]. '</option>';
                                                                }
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                                <div class="form-group mb-20">
                                                    <label class="text-muted" for="">Description</label>
                                                    <textarea style="min-height: 120px;" name="description" class="form-control" id="" cols="30" rows="10" required></textarea>
                                                </div>
                                                <div class="row">
                                                    <div class="col-6">
                                                        <div class="form-group mb-20">
                                                            <label class="text-muted" for="">Quantity</label>
                                                            <input type="number" class="form-control" name="quantity" min="1" value="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-6">
                                                        <div class="form-group mb-20">
                                                            <label class="text-muted" for="">Unit</label>
                                                            <input type="text" class="form-control" name="unit" min="1" value="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group mb-20">
                                                    <label class="text-muted" for="">Date Required</label>
                                                    <input type="text" class="form-control" name="date_required" min="1" value="" required>
                                                </div>
        
                                                <div class="form-group mb-20">
                                                    <label class="d-block text-muted" for="">Attach a photo of the materials to illustrate how you expect them to look</label>
                                                    <!-- <input type="file" class="" name="product_image" /> -->
                                                    <div class="drop-zone w-100">
                                                        <span class="drop-zone__prompt">Drop file here or click to upload</span>
                                                        <input type="file" name="product_image" class="drop-zone__input">
                                                    </div>
                                                </div>
                                                <div class="form-group mb-20">
                                                    <div class="box-sm">
                                                        <span>are you open to similar brands?</span>
                                                        <div class="mt-15">
                                                            <a href="javascript:void(0);">
                                                                <input type="radio" name="open_to_similar_brands" value="yes" checked> Yes
                                                            </a>
                                                            <a href="javascript:void(0);">
                                                                <input type="radio" name="open_to_similar_brands" value="no"> No
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- <div class="form-group">
                                                    <button class="btn butn-primary w-100" style="height: 50px;" type="submit">Save</button>
                                                </div> -->

                                                <div class="form-group">
                                                    <div class="d-flex" style="gap: 20px">
                                                        <button class="btn butn-primary w-100"style="background-color: #FF8484" disabled>Delete</button>
                                                        <button class="btn butn-primary w-100" type="submit">Save</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        <?php
                    }else if(isset($_GET["action"]) && $_GET["action"] === 'edit-product') {
                        $product_id = $_GET["product-id"];
                        $projectItem = $projectsModel->getProjectItem($product_id);
                        $edit_data = json_decode($projectItem["edit_data"], true);
                        // echo json_encode($edit_data);
                        ?>
                            <div id="edit-product-section" class="box-content" style="width: 73%; display: inline-flex;">
                                <div class="">
                                    <div class="sec__heading">
                                        <h5><?php echo $project["project_name"]; ?> - Editing</h5>
                                    </div>
                                    <div class="inner-content" style="padding: 10px !important;">
                                        <div class="d-flex justify-content-between pt-20 pb-10">
                                            <div class="">
                                                <h6>Project Description: <small class="text-muted"><?php echo $project["project_description"]; ?></small></h6>
                                            </div>
                                            <div class="">
                                                <h6>Project Address: <small class="text-muted"><?php echo $project["post_code"]; ?></small></h6>
                                            </div>
                                        </div>
                                        <hr>

                                        <form id="edit-product-form">
                                            <input type="hidden" name="project_id" value="<?php echo $project_id; ?>">
                                            <input type="hidden" name="item_id" value="<?php echo $product_id; ?>">

                                            <div class="form-group product-list mb-20">
                                                <label class="text-muted" for="">Product Name</label>
                                                <select class="form-control" name="product_name" disabled>
                                                    <?php
                                                        $products = $productModel->getAllProducts();
    
                                                        if($products) {
                                                            foreach($products as $product) {
                                                                echo '<option value="'. strtolower($product["name"]). '">'. $product["name"]. '</option>';
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="form-group mb-20">
                                                <label class="text-muted" for="">Description</label>
                                                <textarea style="min-height: 150px;" name="description" class="form-control" id="" cols="30" rows="10" required><?php echo $edit_data ? $edit_data["description"] : $projectItem["description"]; ?></textarea>
                                            </div>
                                            <div class="row">
                                                <div class="col-6">
                                                    <div class="form-group mb-20">
                                                        <label class="text-muted" for="">Quantity</label>
                                                        <input type="number" class="form-control" name="quantity" min="1" value="<?php echo $edit_data ? $edit_data["quantity"] : $projectItem["quantity"]; ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="form-group mb-20">
                                                    <label class="text-muted" for="">Unit</label>
                                                        <input type="text" class="form-control" name="unit" min="1" value="<?php echo $edit_data ? $edit_data["unit"] : $projectItem["unit"]; ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-6">
                                                    <div class="form-group mb-20">
                                                    <label class="text-muted" for="">Date Required</label>
                                                        <input type="text" class="form-control" name="date_required" min="1" value="<?php echo $edit_data ? $edit_data["date_required"] : $projectItem["date_required"]; ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="box-button mt-25">
                                                        <div class="label">Equivalent Products Acceptable?</div>
                                                        <div class="radio-container">
                                                            <?php
                                                                $open_to_similar_brands = $projectItem["open_to_similar_brands"];
                                                                if($edit_data) {
                                                                    $open_to_similar_brands = $edit_data["open_to_similar_brands"];
                                                                }
                                                            ?>

                                                            <input type="radio" id="yes" name="open_to_similar_brands" value="yes" <?php echo $open_to_similar_brands === 'yes' ? 'checked' : '' ?>>
                                                            <label for="yes">Yes</label>
                                                            <input type="radio" id="no" name="open_to_similar_brands" value="no" <?php echo $open_to_similar_brands === 'no' ? 'checked' : '' ?>>
                                                            <label for="no" class="no">No</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group mb-20">
                                                <label class="d-block text-muted" for="">Attach a photo of the materials to illustrate how you expect them to look</label>
                                                <!-- <input type="file" class="" name="product_image" /> -->
                                                <div class="drop-zone w-100">
                                                    <span class="drop-zone__prompt">Drop file here or click to upload</span>
                                                    <input type="file" name="product_image" class="drop-zone__input">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="d-flex" style="gap: 20px">
                                                    <button class="delete-product btn butn-primary w-100" data-id="<?php echo $product_id; ?>" data-project="<?php echo $project_id; ?>" data-type="2" type="button" style="background-color: #FF8484">Delete</button>
                                                    <button class="btn butn-primary w-100" type="submit">Save</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php
                    }else {
                        ?>
                            <div id="products-list-section" class="products-list box-content" style="width: 37%; display: inline-flex;">
                                <div class="">
                                    <div class="sec__heading">
                                        <h5><span id="project-name"></span> Products List</h5>
                                    </div>
                                    <div class="products-group">
                                        <div class="text-center py-4">No Products found.</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div id="bids-list-section" class="bids-list box-content" style="width: 35.5%; display: inline-flex;">
                                <div class="">
                                    <div class="sec__heading">
                                        <h5><span id="bidlist-project-name"></span> Bids List</h5>
                                    </div>
                                    <div class="bids-group" style="padding: 10px !important;">
                                        <div class="text-center py-4">No bids found.</div>
                                    </div>
                                </div>
                            </div>
                        <?php
                        }
                }
            ?>

            <div class="chat-toggle-button" style="position: fixed; bottom: 50px; right: 50px; cursor: pointer; z-index: 9999999999;">
                <div class="" style="width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                    <img src="public/images/messages-3.png" alt="">
                </div>
                <div class="unread-msg-count"></div>
            </div>

            <div class="chat-app" style="position: fixed; width: 100%; height: 100%; top: 0; right: 0; background: #00000091;">
                <div class="chat-container" style="position: absolute; bottom: 150px; right: 50px; cursor: pointer;">
                    <div class="chat__heading">
                        <h5 class="mb-0">Chat</h5>
                    </div>
                    <div class="inner-content">
                        <div class="app-content">
                            <div class="people-list">
                                <ul class="list list-unstyled p-0 m-0">
                                    <div class="loading-chat-icon text-center mt-20">
                                        <img src="https://media.tenor.com/On7kvXhzml4AAAAj/loading-gif.gif" width="30" height="30" alt="">
                                    </div>
                                </ul>
                            </div>
                            
                            <div class="chat">
                                <div class="chat-history">
                                    <ul class="list-unstyled m-0">
                                        <li class="clearfix">
                                            <?php
                                                if($messages && count($messages) >= 20) {
                                                    ?>
                                                            <div class="load-more-msg text-center">
                                                            <a href="javascript:void(0);">Load More</a>
                                                        </div>
                                                    <?php
                                                }
                                            ?>
                                            <div class="chats">
                                                <div class="msg text-muted mt-50" style="height: 100%; display: flex; align-items: center; justify-content: center; text-align: center;">
                                                    <h6>Select a chat or start a new conversation</h6>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
    
                                <div class="chat-message" style="display: none;">
                                    <div class="">
                                        <p class="attached-file-name" style="margin-top: -3px;"></p>
                                        <div class="warning-msg" style="display: none;">
                                            <small><p style="color: #df3079;">Terms of Service reminder: Sharing contact information is only allowed when essential for the service.</p></small>
                                        </div>
                                        <div class="box-wrapper">
                                            <div class="input-wraper" style="position: relative;">
                                                <div class="upload-file">
                                                    <label class="upload-area">
                                                        <input id="attached-file" type="file">
                                                        <span class="file-upload-button">
                                                            <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <g id="fi-sr-clip" opacity="0.4" clip-path="url(#clip0_93_163)">
                                                                    <path id="Vector" d="M26.775 11.2001C26.5562 10.9813 26.2596 10.8585 25.9502 10.8585C25.6408 10.8585 25.3441 10.9813 25.1254 11.2001L12.418 23.9622C11.8764 24.504 11.2333 24.9337 10.5255 25.2269C9.81778 25.5202 9.0592 25.6711 8.29311 25.6712C6.74591 25.6713 5.26205 25.0568 4.16794 23.9628C3.07384 22.8689 2.45911 21.3851 2.459 19.8379C2.45889 18.2907 3.07341 16.8068 4.16736 15.7127L16.4745 3.35539C17.1326 2.70776 18.02 2.34642 18.9433 2.35007C19.8666 2.35372 20.7511 2.72207 21.404 3.37488C22.057 4.02769 22.4256 4.91207 22.4294 5.83538C22.4333 6.75869 22.0722 7.64613 21.4247 8.30439L9.11753 20.6617C8.89557 20.8744 8.60007 20.9931 8.29269 20.9931C7.98532 20.9931 7.68982 20.8744 7.46786 20.6617C7.24914 20.4429 7.12628 20.1462 7.12628 19.8369C7.12628 19.5275 7.24914 19.2308 7.46786 19.0121L18.4252 8.00455C18.6377 7.78452 18.7553 7.48982 18.7526 7.18392C18.75 6.87802 18.6273 6.58541 18.411 6.3691C18.1947 6.15279 17.9021 6.03009 17.5962 6.02743C17.2903 6.02478 16.9956 6.14237 16.7755 6.35489L5.81819 17.3624C5.49313 17.6874 5.23526 18.0733 5.05934 18.4979C4.88341 18.9226 4.79286 19.3778 4.79286 19.8375C4.79286 20.2971 4.88341 20.7523 5.05934 21.177C5.23526 21.6017 5.49313 21.9875 5.81819 22.3126C6.48508 22.9489 7.37147 23.304 8.29328 23.304C9.21508 23.304 10.1015 22.9489 10.7684 22.3126L23.0744 9.95405C24.1454 8.85541 24.7404 7.37905 24.7306 5.84479C24.7207 4.31053 24.1068 2.84191 23.0218 1.75708C21.9369 0.672249 20.4682 0.0585561 18.9339 0.0489428C17.3996 0.0393295 15.9234 0.63457 14.8249 1.70572L2.51769 14.0631C0.986068 15.5947 0.12561 17.672 0.12561 19.8381C0.12561 22.0041 0.986068 24.0814 2.51769 25.6131C4.04932 27.1447 6.12665 28.0051 8.29269 28.0051C10.4587 28.0051 12.5361 27.1447 14.0677 25.6131L26.775 12.8544C26.884 12.746 26.9705 12.6171 27.0295 12.4751C27.0886 12.3332 27.1189 12.181 27.1189 12.0272C27.1189 11.8735 27.0886 11.7213 27.0295 11.5793C26.9705 11.4374 26.884 11.3085 26.775 11.2001Z" fill="black" fill-opacity="0.4"/>
                                                                </g>
                                                                <defs>
                                                                    <clipPath id="clip0_93_163">
                                                                        <rect width="28" height="28" fill="white"/>
                                                                    </clipPath>
                                                                </defs>
                                                            </svg>
                                                        </span>
                                                    </label>
                                                </div>
                                                <input id="receiver_id" type="hidden" name="" value="">
                                                <textarea id="msg-input" class="form-control" id="" cols="30" rows="2"></textarea>
                                            </div>
                                            <div id="send-msg">
                                                <a href="javascript:void(0);"><img src="public/images/fi-sr-paper-plane.svg" alt=""></a>
                                            </div>
                                            <div id="sending-msg" style="display: none">
                                                <a href="javascript:void(0);">
                                                    <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                        <circle fill="#fff" stroke="none" cx="6" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>
                                                        </circle>
                                                        <circle fill="#fff" stroke="none" cx="26" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>
                                                        </circle>
                                                        <circle fill="#fff" stroke="none" cx="46" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>
                                                        </circle>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal -->
             <div id="modal" class="w-100 h-100" style="position: absolute; top: 0; right: 0; background: #00000091;">
                <div class="modal-dialog modal-dialog-centered h-100">
                    <div class="modal-content" style="background-color: #fff; width: 600px; height: 700px; margin: auto; border-radius: 30px;">
                        <div class="modal-body" style="padding: 30px;">
                            
                        </div>
                    </div>
                </div>
             </div>

            
            <!-- Include Footer -->
            <footer class="d-none" style="display: none;">
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>
                                    
                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<script src="public/js/image-uploader.js"></script>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });

        $(".chat-toggle-button").click(function() {
            $(".chat-app").toggleClass("active");
        });

        $('#search-input').on('keydown', function(event) {
            if (event.key === 'Enter') {
                event.preventDefault();
                $(this).closest('form').submit();
            }
        });

        // showModal();

        // <?php
        //     if(isset($_GET["action"]) && $_GET["action"] === "add-project") {
        //         ?>
        //             if ($(window).width() < 768) {
        //                 $('html, body').animate({ scrollTop: $('.add-product').offset().top }, 0);
        //             }
        //         <?php
        //     }
        // ?>

        $(document).on('click','.msg-icon', function() {
            const user_id = $(this).data('id');
            console.log(user_id);

            $(".chat-app").toggleClass("active");

            $(".chat-app #receiver_id").val(user_id);

            $(".chat-message").show();
            updateMessages(user_id, 0, 2);
        });

    function showModal() {
        $("#modal").addClass('show');
    }

    function hideModal() {
        $("#modal").removeClass('show');
    }

    $(document).on('click','.scroll-to-bestcomb', function() {
        var offerId = $(this).data("offer-id");
        var $target = $(".offer-item[data-id='" + offerId + "']");
        if ($target.length) {
            $('html, body').animate({
                scrollTop: $target.offset().top
            }, 1000);
        }
    });

    

    $(document).on('click','.scrollto-nextcomb', function() {
        var offerId = $(this).data("offer-id");

        var $target = $(".bids-group .offer-item[data-id='" + offerId + "']");
        if ($target.length) {
            $('html, body').animate({
                scrollTop: $target.offset().top
            }, 1000);
        }
    });

    setInterval(function(){
        let receiver_id = $("#receiver_id").val();
        
        if(receiver_id) {
            let last_msg_id = $(".chat-msg").last().data("id");
            if(!last_msg_id) {
                last_msg_id = 0;
            }

            // console.log("waiting for new message!");
            updateMessages(receiver_id, last_msg_id);
        }

        checkNewNotifications();
        updateChatUser();
        loadNewBids();
        // unreadMessagesCount();
    }, 1500);

    $(document).on('click','.single-project .product-name', function() {
        $('#products-list-section .products-group').html(`<div class="products-list-loading-icon text-center mt-20">
                                        <img src="https://media.tenor.com/On7kvXhzml4AAAAj/loading-gif.gif" width="30" height="30" alt="">
                                    </div>`);

        const project_id = $(this).parent().data('id');
        const action_type = $(this).parent().data('type');
        // console.log(project_id, action_type);

        if(action_type === 'redirect') {
            window.location.href = "<?php echo BASE_URL;?>buyer.php?action=load-products&pid=" + project_id;
        }else {
            $(".single-project").removeClass('active');
            $(this).parent().addClass('active');
    
            $('#bidlist-project-name').html(`<span></span>`);
    
            loadProducts(project_id, action_type);
        }

    });

    <?php
        if(isset($_GET["action"]) && $_GET["action"] === "load-products") {
            $project_id = $_GET["pid"];
    
            ?>
                loadProducts(<?php echo $project_id; ?>);
            <?php
        }
    ?>

    function loadProducts(project_id, action_type = '') {
        $.ajax({
            type: 'POST',
            url: 'app/core/projects.php',
            data: {
                action: 'LOAD_PRODUCTS',
                project_id: project_id
            },
            success: function(res) {
                // alert('Project saved successfully!');
                // console.log(res);

                const response = JSON.parse(res);

                $('#project-name').html(`<span>${response.project_name} - </span>`);

                $("#products-list-section .products-group").html(response.data);
                $("#bids-list-section .bids-group").html('<div class="text-center py-4">No offers found.</div>');
            },
            error: function(xhr, status, error) {
                // Handle error
                alert('An error occurred while saving the project. Please try again.');
            }
        });
    }

    // get Bids
    $(document).on('click','.products-group .product', function() {
        $("#bids-list-section .bids-group").html(`<div class="products-list-loading-icon text-center mt-20">
                                        <img src="https://media.tenor.com/On7kvXhzml4AAAAj/loading-gif.gif" width="30" height="30" alt="">
                                    </div>`);

        const item_id = $(this).data('id');
        const project_id = $(this).data('project');

        $(".products-group .product").removeClass('active');
        $(this).addClass('active');

        $.ajax({
            type: 'POST',
            url: 'app/core/projects.php',
            data: {
                action: 'LOAD_BIDS',
                item_id: item_id,
                project_id: project_id
            },
            success: function(res) {
                // alert('Project saved successfully!');
                // console.log(response);

                // const response = JSON.parse(res);
                // console.log(response);
                const response = JSON.parse(res);

                $('#bidlist-project-name').html(`<span>${response.project_name} - </span>`);

                $("#bids-list-section .bids-group").html(response.data);
                // $("#bids-list-section .bids-group").html('<div class="text-center py-4">No offers found.</div>');
            },
            error: function(xhr, status, error) {
                // Handle error
                alert('An error occurred while saving the project. Please try again.');
            }
        });
    });

    function loadNewBids() {
        const project_id = $("#bids-list-section .price-offers").data('project');
        const item_id = $("#bids-list-section .price-offers").data('item');
        const last_id = $($("#bids-list-section .offer-item")[0]).data('id');

        if(project_id && item_id) {
            $.ajax({
                type: 'POST',
                url: 'app/core/projects.php',
                data: {
                    action: 'LOAD_NEW_BIDS',
                    item_id: item_id,
                    project_id: project_id,
                    last_id: last_id
                },
                success: function(response) {
                    // alert('Project saved successfully!');
                    console.log(response);
                    
                    if(response.length > 10) {
                        $("#bids-list-section .bids-group").prepend(response);
                    }
    
                    // const data = JSON.parse(response);
    
                    // $("#bids-list-section .bids-group").html('<div class="text-center py-4">No offers found.</div>');
                },
                error: function(xhr, status, error) {
                    // Handle error
                    alert('An error occurred while saving the project. Please try again.');
                }
            });
        }
    }

    $(document).on('click','.close-modal', function() {
        hideModal();
    });

    $("#new-project-form").on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        var form = this;

        let isValid = true;
        // Iterate through each required input and textarea
        $(this).find('input[required], textarea[required]').each(function() {
            if ($(this).val() === '') {
                isValid = false;
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });

        // If the form is valid, submit it via AJAX
        if (isValid) {
            let formData = $(this).serializeArray();
            formData.push({ name: 'action', value: 'ADD_PROJECT' });

            let serializedData = $.param(formData);

            // Reset the form
            this.reset();

            $.ajax({
                type: 'POST',
                url: 'app/core/projects.php',
                data: serializedData,
                success: function(response) {
                    console.log(response);
                    alert('Project saved successfully!');

                    const result = JSON.parse(response);

                    $("#products-section .projects").prepend(result.data);

                    $(".modal-body").html(`<div class="text-center">
                                <h2 style="font-weight: 500;">Create New Project</h2>
                            </div>
                            <div class="text-center mt-50">
                                <img style="width: 300px" src="public/images/published.svg" alt="">
                            </div>
                            <div class="text-center mt-30">
                                <h3 style="font-weight: 500;">The new project has been created successfully</h3>
                            </div>
                            <div class="mt-30 d-flex flex-column" style="gap: 15px;">
                                <a href="javascript:void(0);" class="close-modal">
                                    <button class="cns_btn cns_btn__primary btn_rounded w-100">Close</button>
                                </a>
                                <a href="?action=add-product&project-id=${result.project_id}">
                                    <button class="cns_btn cns_btn__outline btn_rounded w-100">Add a Product to the Project</button>
                                </a>
                            </div>`);

                    showModal();
                },
                error: function(xhr, status, error) {
                    // Handle error
                    alert('An error occurred while saving the project. Please try again.');
                }
            });
        } else {
            alert("Please fill all required fields.");
        }
    });

    $("#new-product-form").on('submit', function(e) {
        e.preventDefault(); // Prevent the default form submission

        let isValid = true;

        // Iterate through each required input and textarea
        $(this).find('input[required], textarea[required], select[required]').each(function() {
            if ($(this).val() === '') {
                isValid = false;
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });

        // If the form is valid, submit it via AJAX
        if (isValid) {
            let formData = new FormData(this);

            // Append additional data
            formData.append('action', 'ADD_PROJECT_ITEM');

            // Reset the form
            this.reset();

            $.ajax({
                type: 'POST',
                url: 'app/core/projects.php',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    // alert('Product saved successfully!');
                    console.log(response);

                    const data = JSON.parse(response);

                    $(".modal-body").html(`<div class="text-center">
                                <h2 style="font-weight: 500;">Add New Product</h2>
                            </div>
                            <div class="text-center mt-50">
                                <img style="width: 300px" src="public/images/published.svg" alt="">
                            </div>
                            <div class="text-center mt-30">
                                <h3 style="font-weight: 500;">The new product has been added successfully</h3>
                            </div>
                            <div class="mt-30 d-flex flex-column" style="gap: 15px;">
                                <a href="?action=edit-project&project-id=${data.project_id}">
                                    <button class="cns_btn cns_btn__primary btn_rounded w-100">Close</button>
                                </a>
                                <a href="javascript:void(0);" class="close-modal">
                                    <button class="cns_btn cns_btn__outline btn_rounded w-100">Add Another Product to the Project</button>
                                </a>
                            </div>`);

                    showModal();
                },
                error: function(xhr, status, error) {
                    // Handle error
                    alert('An error occurred while saving the product. Please try again.');
                }
            });
        } else {
            alert("Please fill all required fields.");
        }
    });

    $("#edit-product-form").on('submit', function(e) {
        e.preventDefault(); // Prevent the default form submission

        let isValid = true;

        // Iterate through each required input and textarea
        $(this).find('input[required], textarea[required], select[required]').each(function() {
            if ($(this).val() === '') {
                isValid = false;
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });

        // If the form is valid, submit it via AJAX
        if (isValid) {
            let formData = new FormData(this);

            // console.log(Object.fromEntries(formData));

            // Append additional data
            formData.append('action', 'EDIT_PROJECT_ITEM');

            $.ajax({
                type: 'POST',
                url: 'app/core/projects.php',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    // alert('Product saved successfully!');
                    console.log(response);

                    const data = JSON.parse(response);

                    $(".modal-body").html(`<div class="text-center">
                                <h2 style="font-weight: 500;">Edit Product</h2>
                            </div>
                            <div class="text-center mt-50">
                                <img style="width: 300px" src="public/images/published.svg" alt="">
                            </div>
                            <div class="text-center mt-30">
                                <h3 style="font-weight: 500;">The changes have been saved successfully</h3>
                            </div>
                            <div class="mt-30 d-flex flex-column" style="gap: 15px;">
                                <a href="javascript:void(0);" class="close-modal">
                                    <button class="cns_btn cns_btn__primary btn_rounded w-100">Close</button>
                                </a>
                                <a href="?action=add-product&project-id=${data.project_id}">
                                    <button class="cns_btn cns_btn__outline btn_rounded w-100">Add Another Product to the Project</button>
                                </a>
                            </div>`);

                    showModal();
                },
                error: function(xhr, status, error) {
                    // Handle error
                    alert('An error occurred while saving the product. Please try again.');
                }
            });
        } else {
            alert("Please fill all required fields.");
        }
    });

    $(document).on('click','.publish-project', function() {
        const project_id = $(this).data('project-id');
        const location = $(this).data('location');

        publishProject(project_id, location);
    });

    function publishProject(project_id, location) {
        $(".modal-content").css({
            "width": "540px",
            "height": "600px",
        });

        $(".modal-body").html(`<div class="text-center mt-20">
                <h2 style="font-weight: 500;">Processing Your Project</h2>
            </div>
            <div class="text-center mt-50">
                <img style="width: 300px" src="public/images/processing.svg" alt="">
            </div>
            <div class="text-center mt-80">
                <h5 class="project_name" style="font-weight: 500;">Please wait...</h5>
            </div>`);

        showModal();

        if(location === 2) {
            $($(".publish-project[data-project-id='" + project_id + "']").closest(".single-project")[0]).find('.project-status').remove();
        }
        $(".publish-project[data-project-id='" + project_id + "']").hide();

        jQuery.ajax({
            type: "POST",
            url: "app/core/projects.php",
            data: {
                action: "PUBLISH_PROJECT",
                project_id: project_id
            },
            success: function(data) {
                console.log(data);

                hideModal();

                $(".modal-content").css({
                    "width": "600px",
                    "height": "690px",
                });

                $(".modal-body").html(`<div class="text-center  mt-20">
                        <h2 style="font-weight: 500;">Published Your Project</h2>
                    </div>
                    <div class="text-center mt-50">
                        <img style="width: 300px" src="public/images/published.svg" alt="">
                    </div>
                    <div class="text-center mt-30">
                        <h2 style="font-weight: 500;">Your Project is Successfully Published</h2>
                    </div>
                    <div class="mt-50 d-flex flex-column" style="gap: 15px;">
                        <a href="javascript:void(0);" class="close-modal">
                            <button class="cns_btn cns_btn__primary btn_rounded w-100">Close</button>
                        </a>
                    </div>`);

                showModal();
            }
        });
    }
    
    // Delete Project
    $(".delete-project").on('click', function(e) {
        const $project = $(this).closest('.single-project')
        const $project_id = $project.data('id');
        // console.log($project_id);

        $(".modal-body").html(`<div class="text-center">
                    <h2 style="font-weight: 500;">Delete Project</h2>
                </div>
                <div class="text-center mt-50">
                    <img style="width: 250px" src="public/images/published.svg" alt="">
                </div>
                <div class="text-center mt-30">
                    <h3 style="font-weight: 500;">Are you sure you want to delete this project?</h3>
                </div>
                <div class="mt-30 d-flex flex-column" style="gap: 15px;">
                    <a href="javascript:void(0);" class="confirm-delete-project" data-type="project_only" data-id="${$project_id}">
                        <button class="cns_btn cns_btn__primary btn_rounded w-100">Delete Project Keep Products</button>
                    </a>
                    <a href="javascript:void(0);" class="confirm-delete-project" data-type="delete_all" data-id="${$project_id}">
                        <button class="cns_btn cns_btn__outline btn_rounded w-100">Delete Project and all the Project's Products</button>
                    </a>
                    <a href="javascript:void(0);" class="close-modal">
                        <button class="cns_btn cns_btn__outline btn_rounded w-100">Cancel</button>
                    </a>
                </div>`);

        showModal();
    });

    $(document).on('click','.confirm-delete-project', function() {
        hideModal();
        const $action_type = $(this).data('type');
        const $project_id = $(this).data('id');

        $.ajax({
            type: 'POST',
            url: 'app/core/projects.php',
            data: {
                action: 'DELETE_PROJECT',
                action_type: $action_type,
                project_id: $project_id
            },
            success: function(response) {
                // alert('Project deleted successfully!');
                // const data = JSON.parse(response);
                console.log(response);

                // Remove Project from Projects List
                $('.single-project[data-id="' + $project_id + '"]').remove();

                $(".modal-body").html(`<div class="text-center">
                            <h2 style="font-weight: 500;">Delete Project</h2>
                        </div>
                        <div class="text-center mt-50">
                            <img style="width: 320px" src="public/images/published.svg" alt="">
                        </div>
                        <div class="text-center mt-40">
                            <h2 style="font-weight: 500;">The project has been deleted successfully</h2>
                        </div>
                        <div class="mt-70 d-flex flex-column" style="gap: 15px;">
                            <a href="javascript:void(0);" class="close-modal">
                                <button class="cns_btn cns_btn__primary btn_rounded w-100">Ok</button>
                            </a>
                        </div>`);

                showModal();
            },
            error: function(xhr, status, error) {
                // Handle error
                alert('An error occurred while deleting the project. Please try again.');
            }
        });
    });

    // Delete Project
    $(".delete-product").on('click', function(e) {
        const item_id = $(this).data('id');
        const project_id = $(this).data('project');
        const action_type = $(this).data('type');
        // console.log(action_type);

        // Remove Product from
        if(action_type === 1) {
            $(this).closest('.item-product').remove();
        }

        $.ajax({
            type: 'POST',
            url: 'app/core/projects.php',
            data: {
                action: 'DELETE_PRODUCT',
                item_id: item_id,
                project_id: project_id
            },
            success: function(response) {
                // alert('Project deleted successfully!');
                // const data = JSON.parse(response);
                // console.log(response);

                $(".modal-body").html(`<div class="text-center">
                        <h2 style="font-weight: 500;">Delete Product</h2>
                    </div>
                    <div class="text-center mt-50">
                        <img style="width: 320px" src="public/images/published.svg" alt="">
                    </div>
                    <div class="text-center mt-40">
                        <h2 style="font-weight: 500;">The product has been deleted successfully</h2>
                    </div>

                    ${action_type === 1 ? `<div class="mt-70 d-flex flex-column" style="gap: 15px;">
                        <a href="javascript:void(0);" class="close-modal">
                            <button class="cns_btn cns_btn__primary btn_rounded w-100">Ok</button>
                        </a>
                    </div>` : `<div class="mt-70 d-flex flex-column" style="gap: 15px;">
                        <a href="?action=edit-project&project-id=${project_id}" class="close-modal">
                            <button class="cns_btn cns_btn__primary btn_rounded w-100">Ok</button>
                        </a>
                    </div>`}
                    `);

                showModal();
            },
            error: function(xhr, status, error) {
                // Handle error
                alert('An error occurred while deleting the project. Please try again.');
            }
        });
    });

    $(document).on('change','.update-pstatus select', function() {
        const $select = $(this);
        var $status = $select.val();
        console.log("Selected value: " + $status);

        // Remove existing alert if present
        $('.alert').remove();

        const $offerItem = $select.closest('.offer-item')[0];

        if($status === 'ordered') {
            $($offerItem).find('.review-form').show();
        }else {
            $($offerItem).find('.review-form').hide();
            
            const project_id = $($offerItem).data('project');
            const item_id = $($offerItem).data('item');
            const offer_id = $($offerItem).data('id');

            let formData = new FormData();
                formData.append('project_id', project_id);
                formData.append('item_id', item_id);
                formData.append('offer_id', offer_id);
                formData.append('status', $status);
                formData.append('action', 'UPDATE_STATUS');

            $.ajax({
                type: 'POST',
                url: 'app/core/projects.php',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    // alert('Product saved successfully!');
                    console.log('Product saved successfully!');
                    console.log(response);

                    // Create a Bootstrap 5 success alert
                    var alert = $('<div class="alert alert-success alert-dismissible fade show mt-15" role="alert">' +
                                    'Status updated successfully!' +
                                    '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' +
                                '</div>');

                    $select.closest('.offer-actions').after(alert);
                },
                error: function(xhr, status, error) {
                    // Handle error
                    alert('An error occurred while saving the product. Please try again.');
                }
            });
        }
    });

    $(document).on('submit', '.review-form form', function(event) {
        event.preventDefault(); // Prevent default form submission

        var $form = $(this); // Reference to the form that was submitted

        // Validate form fields
        var isValid = true;
        
        // Check if a rating is selected
        if (!$form.find('input[name="rating"]:checked').val()) {
            isValid = false;
        }

        // Check if the comment field is not empty
        if (!$form.find('input[name="comment"]').val().trim()) {
            isValid = false;
        }

        if (!isValid) {
            alert('Please fill out all required fields.');
            return;
        }

        // hide the form
        $form.closest('.review-form').hide();
        const offerId = $form.closest('.review-form').data('offer-id');

        var selectedDiv = $('div.update-pstatus[data-offer-id="' + offerId + '"]');

        // Disable the select element within the selected div
        selectedDiv.find('select').prop('disabled', true);
        
         // Create a Bootstrap 5 success alert
         var alert = $('<div class="alert alert-success alert-dismissible fade show mt-15" role="alert">' +
                        'Your review has been submitted successfully!' +
                        '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' +
                      '</div>');

        // Append the alert next to the review-form element
        $form.closest('.review-form').after(alert);

        let formData = $form.serializeArray();
            formData.push({ name: 'action', value: 'ADD_REVIEW' });

        let serializedData = $.param(formData);
        // console.log(serializedData);

        // Prepare form data for submission
        // var formData = $form.serialize();

        // Submit form data via AJAX
        $.ajax({
            url: "app/core/projects.php",
            type: 'POST',
            data: serializedData,
            success: function(response) {
                // alert('Review submitted successfully.');
                console.log('Review submitted successfully.');
                console.log(response);

                // Disable the selected option
                $('.update-pstatus select').prop('disabled', true);
            },
            error: function(xhr, status, error) {
                // Handle error response
                alert('An error occurred while submitting the review.');
                console.log(xhr.responseText);
            }
        });
    });

    // Click event handler for submit button
    $('#submitForm').on('click', function(event) {
        event.preventDefault();

        var $form = $(this).closest('form'); 

        // Submit the form programmatically
        $form.submit();
    });

    // Remove the invalid class on input
    $('input[required], textarea[required]').on('input', function() {
        if ($(this).val() !== '') {
            $(this).removeClass('is-invalid');
        }
    });

        function updateProjectIPublished(id) {
            $.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: {
                    action: "updateProjectIPublished",
                    project_id: id
                },
                success: function(data) {
                    // console.log(data);

                    const singleProject = $("#products-section .single-project[data-id='" + id + "']");
                    if(singleProject) {
                        singleProject.remove();
                    }

                    $("#products-section .projects").prepend(data);
                }
            });
        }

        $(".publish-btn").click(function() {
            const type = $(this).data("type");
            console.log(type);

            let formContent = $(".add-product .inner-content");

            let inputsToValidate = [];
            if(type === 'form_upload') {
                inputsToValidate = [
                    "project_name",
                    "post_code",
                    "description",
                    "quantity",
                    "date_required"
                ];
            }else {
                inputsToValidate = [
                    "project_name",
                    "post_code"
                ];
            }

            for (let i = 0; i < inputsToValidate.length; i++) {
                let fieldName = inputsToValidate[i];
                let fieldValue = formContent.find(`[name='${fieldName}']`).val();

                if (fieldValue.trim() === '') {
                    formContent.find(`[name='${fieldName}']`).focus();
                    return;
                }
            }

            const project_id = formContent.find("input[name='project_id']").val();
            const project_name = formContent.find("input[name='project_name']").val();
            const post_code = formContent.find("input[name='post_code']").val();

            if(type === 'form_upload') {
                
            }

            // if(project_name === '' || post_code === '' || product_name === '' || description === '' || quantity === '' || unit === '' || date_required === '') {
            //     alert("Please fill all fields");
            //     return;
            // }

            
            let formData = new FormData();
            formData.append("project_name", project_name);
            formData.append("post_code", post_code);

            if(type === 'form_upload') {
                const product_name = formContent.find("select[name='product_name']").val();
                const description = formContent.find("textarea[name='description']").val();
                const quantity = formContent.find("input[name='quantity']").val();
                const unit = formContent.find("input[name='unit']").val();
                const date_required = formContent.find("input[name='date_required']").val();
                const open_to_similar_brands = formContent.find("input[name='open_to_similar_brands']:checked").val();

                formData.append("product_name", product_name);
                formData.append("description", description);
                formData.append("quantity", quantity);
                formData.append("unit", unit);
                formData.append("date_required", date_required);
                formData.append("open_to_similar_brands", open_to_similar_brands);

                if(project_id) {
                    formData.append("project_id", project_id);
                }

                const product_image = formContent.find("input[name='product_image']")[0].files[0];

                if(product_image) {
                    formData.append("product_image", product_image);
                }
            }

            if(type === 'excel_upload') {
                const excel_file = formContent.find("input[name='fileToUpload']")[0].files[0];

                if(excel_file) {
                    formData.append("fileToUpload", excel_file);
                }else {
                    alert("Please select a file to upload");
                    return;
                }
            }

            formData.append("status", "publish");
            formData.append("action", "ADD_PROJECT");

            // console.log(Object.fromEntries(formData));
            // return;

            $("#add-section .form-box").hide();
            $("#add-section .processing-project .project_name").text(project_name);
            $("#add-section .processing-project").show();

            $.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);
                    console.log(res);
                    updateProjectIPublished(res.project_id);
                    
                    $("#add-section .processing-project").hide();

                    $("#add-section .published-project .project_name").text(project_name);
                    $("#add-section .published-project").show();

                    // window.location.href = `buyer.php?status=published-project&project=` + project_name;
                }
            });

        });

        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });

        $(".chat-history ul li").animate({ scrollTop:3031 },"fast");

        $("#attached-file").on("change", function () {
            let maxFileSizeMB = 10;
            let maxFileSizeBytes = maxFileSizeMB * 1024 * 1024;

            let $uploadButton = $(".file-upload-button");
            let $attachedFileName = $(".attached-file-name");
            let fileName = $(this).val().split("\\").pop();

            if ($(this).val()) {
                let uploadedFile = this.files[0];
                if(uploadedFile.size <= maxFileSizeBytes) {
                    $uploadButton.addClass("file-attached");
                    $attachedFileName.text(fileName);
                }else {
                    alert("Please upload file less than 10MB. Thanks!!");
                }
            } else {
                $uploadButton.removeClass("file-attached");
                $attachedFileName.text('');
            }
        });

        function updateChatUser() {
            const activeChatUser = $('.chat-user.active');

            let activeUserId = '';
            if(activeChatUser.length > 0) {
                const userId = activeChatUser.data("id");
                activeUserId = userId
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "updateChatUser",
                    activeUserId
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.status === "success") {
                        $(".people-list ul").html(res.result);
                    }
                    // if(res.is_found == true) {
                    //     $(".load-notifications").show();
                    // }
                    // data && $(".chat-history ul li").append(data);

                    $('.loading-chat-icon').remove();
                }
            });
        }

        var termsToCheck = ["email", "skype", "phone", "contact", "details", "telephone", "number", "address"];

        function checkForContactDetails(text) {

            var lowercaseText = text.toLowerCase();
            var containsTerms = false;

            for (var i = 0; i < termsToCheck.length; i++) {
                var term = termsToCheck[i];
                if (lowercaseText.includes(term)) {
                    containsTerms = true;
                    break;
                }
            }

            // Check for words ending with "@"
            if (text.match(/\w+@$/)) {
                containsTerms = true;
            }

            var warningMessage = $('#warning-message');
            if (containsTerms) {
                // console.log("violations are not allowed");
                $(".warning-msg").show();
            } else {
                // console.log("you are going correctly");
                $(".warning-msg").hide();
            }
        }

        $('#msg-input').on('input', function() {
            var text = $(this).val();
            checkForContactDetails(text);
        });

        $(document).on('click','.chat-user', function() {
            $(".chat-user").removeClass('active');
            $(this).addClass('active');

            const $receiver_id = $(this).data("id");
            $("#receiver_id").val($receiver_id);

            $(".chat-message").show();
            updateMessages($receiver_id, 0, 2);
        });

        $("#send-msg").click(function() {
            var $msg_input = $("#msg-input");
            var $file = $("#attached-file");
            const $receiver = $("#receiver_id");

            if ($msg_input.val().trim() !== "" || $file[0].files[0]) {
                let $attachedFileName = $(".attached-file-name");

                var formData = new FormData(); // Create a new FormData object
                formData.append('message_text', $msg_input.val()); // Append the message value
                formData.append('file', $file[0].files[0]); // Append the selected file
                formData.append('receiver_id', $receiver.val()); // Append the message value
                formData.append('action', 'SEND_MESSAGE'); // Append the message value

                // console.log(formData);

                $.ajax({
                    url: "app/core/messages.php",
                    type: "POST",
                    data: formData,
                    processData: false, // Prevent jQuery from processing data
                    contentType: false, // Let the browser set the content type
                    beforeSend: function() {
                        // console.log("Sending...");
                        $("#send-msg").hide();
                        $("#sending-msg").show();
                    },
                    success: function(data) {
                        console.log(data);
                    },
                    complete: function() {
                        // console.log("Sent successfully");
                        $msg_input.val('');
                        $file.val('');

                        // Scroll to bottom
                        let targetSection = $(".chat-history ul li");
                        let targetBottom = targetSection[0].scrollHeight
                        $(".chat-history ul li").animate({ scrollTop: targetBottom + 100 },"fast");

                        $attachedFileName.text('');

                        $("#send-msg").show();
                        $("#sending-msg").hide();
                    }
                });
            }
        });

        $(".load-more-msg").click(function() {
            let receiver_id = $("#receiver_id").val();
            let first_id = $(".chat-msg").first().data("id");

            console.log(first_id);

            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "loadMoreMessages",
                    receiver_id: receiver_id,
                    first_id: first_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if(res.status === 'success') {
                        res.result && $(".chat-history .chats").prepend(res.result);

                        if(res.total < 20) {
                            $(".load-more-msg").hide();
                        }
                    }
                }
            });
        });

        function updateMessages(receiver_id, last_msg_id, type = 1) {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "updateMessages",
                    receiver_id: receiver_id,
                    last_msg_id: last_msg_id
                },
                success: function(data) {
                    // console.log(data);

                    if(type == 2) {
                        $(".chat-history ul li .chats").html(data);
                    }else {
                        $(".chat-history ul li .chats").append(data);
                    }

                    if(data) {
                        // Scroll to bottom
                        var element = $('.chat-history ul li');
                        var positionFromBottom = element.prop('scrollHeight') - element.scrollTop() - element.height();

                        // console.log(positionFromBottom);
                        if(positionFromBottom < 150) {
                            let targetBottom = element[0].scrollHeight
                            $(".chat-history ul li").animate({ scrollTop: targetBottom + 100 },"fast");
                        }
                    }
                }
            });
        }

        function unreadMessagesCount() {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: 'unreadMessagesCount'
                },
                success: function(data) {
                    console.log(data);
                    let response = JSON.parse(data);
                    if(response.status === 'success') {
                        // console.log(response);
                        if(response.unread_count > 0) {
                            const badge = `<span class="position-absolute translate-middle badge rounded-pill bg-danger" style="top: 5px; right: 0;">
                                ${response.unread_count}
                                <span class="visually-hidden">unread messages</span>
                            </span>`;
    
                            $(".unread-msg-count").html(badge);
                        }else {
                            $(".unread-msg-count").html('');
                        }
                        
                    }
                }
            });
        }

        $(".load-notifications a").click(function(){
            // $(".load-notifications").hide();
            updateNewNotifications();
        });

        $(".notif-back-btn").click(function() {
            $(".notification-menu").removeClass("active");
        });

        $(".load-more-notifications").click(function() {
            let last_id = $(".notifs .list").last().data("id");

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "loadMoreBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if(res.has_result) {
                        $(".notifs .lists-container").append(res.data);

                        if(res.total < 10)  {
                            $(".load-more-notifications").hide();
                        }
                    }
                }
            });
        });

        $(".dropdown-icon").click(function() {
            updateNewNotifications();

            $(".notification-menu").toggleClass("active");
        });

        function checkNewNotifications() {
            // console.log("Checking new notifications");

            let first_id = $(".notifs .list").first().data("id");

            if(!first_id) {
                first_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "checkNewBuyerNotifications",
                    first_id: first_id
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.is_found == true) {
                        $(".load-notifications").show();
                        $(".notif-alert").show();
                    }else {
                        $(".load-notifications").hide();
                        // console.log("not new notifications found");
                    }
                    // data && $(".chat-history ul li").append(data);
                }
            });
        }

        function updateNewNotifications() {
            // console.log("Checking new notifications");
            let last_id = $(".notifs .list").first().data("id");

            if(!last_id) {
                last_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "getNewBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    console.log(data);
                    let res = JSON.parse(data);

                    if(res.status == 'success') {
                        $(".no-results").hide();
                        res.data && $(".notifs").prepend(res.data);

                        $(".load-notifications").hide();
                        $(".notif-alert").hide();
                    }
                }
            });
        }

        function ensureHttpsProtocol(url) {
            return url.replace(/^http:\/\//i, 'https://');
        }

        $(document).on('click','.mark-notifications', function() {
            let offer_id = $(this).data("id");
            var imgElement = $(this).find("img");

            let src = imgElement.attr("src");

            let type = 1;
            if(src === 'public/images/star.svg') {
                type = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "markBuyerNotification",
                    offer_id: offer_id,
                    type: type
                },
                success: function(data) {
                    // console.log(data);
                    // let res = JSON.parse(data);

                    if(type === 1) {
                        imgElement.attr('src', 'public/images/star.svg');
                    }else {
                        imgElement.attr('src', 'public/images/star-light.svg');
                    }
                }
            });
        });
    });
</script>