<?php
    class Users {
        // DB Stuff
        protected $connect;

        public function __construct() {
            // $DB = new Database();
            $this->connect = (new Database())->getConnection();
        }
        public function getPostCodes() {
            // $query = $this->connect->query("SELECT postcode, latitude, longitude FROM `postcodes` where country = ENG ORDER BY `postcode` ASC");
            $query = $this->connect->query("SELECT postcode, latitude, longitude FROM `postcodes` WHERE country = 'ENG' ORDER BY `postcode` ASC");
        
            if ($query->rowCount() > 0) {
                $result = $query->fetchAll(PDO::FETCH_ASSOC);
                $postcodes = [];
                foreach ($result as $row) {
                    // Push both postcode and coordinates into the array
                    $postcodes[] = [
                        'postcode' => $row['postcode'],
                        'latitude' => $row['latitude'],
                        'longitude' => $row['longitude']
                    ];
                }
                echo json_encode(['postcodes' => $postcodes]); // Proper JSON structure
            } else {
                echo json_encode(['postcodes' => []]); // Return empty array if no data
            }
        }              

        public function checkEmail($email) {
            $query = $this->connect->query("SELECT * FROM users WHERE email = '$email'");
            
            if ($query->rowCount() > 0) {
                return true;
            }

            return false;
        }

        public function authenticate($email, $password) {
            $query = $this->connect->query("SELECT user_id, email, company_name, company_logo, account_type, products_list, country FROM `users` WHERE `email` = '$email' AND `password` = '$password'");

            if ($query->rowCount() > 0) {
                $result = $query->fetch(PDO::FETCH_ASSOC);
                return $result;
            }

            return false;
        }

        public function getAllUsers() {
            $query = $this->connect->query("SELECT user_id, email, company_name, company_logo, account_type, products_list, country, newsletter_preference FROM `users` WHERE `account_type` = 'buyer' OR `account_type` = 'seller' ORDER BY `user_id` DESC");

            if ($query->rowCount() > 0) {
                $result = $query->fetchAll(PDO::FETCH_ASSOC);
                return $result;
            }

            return false;
        }

        public function getAllSellers($type = null) {
            $sql = "SELECT user_id, email, company_name, company_logo, account_type, products_list FROM `users` WHERE account_type ='seller'";
            if(!empty($type)) {
                $sql .= " AND `products_list` = '$type'";
            }

            $query = $this->connect->query($sql);
            if ($query->rowCount() > 0) {
                $result = $query->fetchAll(PDO::FETCH_ASSOC);
                return $result;
            }

            return false;
        }

        public function getAllBuyers() {
            $query = $this->connect->query("SELECT user_id, email, company_name, company_logo, account_type, products_list FROM `users` WHERE `account_type` = 'buyer'");

            if ($query->rowCount() > 0) {
                $result = $query->fetchAll(PDO::FETCH_ASSOC);
                return $result;
            }

            return false;
        }

        public function searchByKeywords($keywords) {
            $keywordArray = explode(',', $keywords);
            $escapedKeywords = array_map('trim', $keywordArray);

            $placeholders = implode(',', array_fill(0, count($escapedKeywords), '?'));

            $likeConditions = array_map(function ($keyword) {
                return "products_list LIKE ?";
            }, $escapedKeywords);

            $likeClause = implode(' OR ', $likeConditions);

            $query = "SELECT * FROM users WHERE $likeClause";

            $stmt = $this->connect->prepare($query);

            $likePatterns = array_map(function ($keyword) {
                return '%' . $keyword . '%';
            }, $escapedKeywords);

            $stmt->execute($likePatterns);

            if ($stmt->rowCount() > 0) {
                $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                return $result;
            }
    
            return false;
        }

        public function getUserById($id) {
            $query = $this->connect->query("SELECT user_id, email, company_name, company_logo, account_type, products_list, gr_link, country, newsletter_preference, postcodes FROM `users` WHERE `user_id` = '$id'");
            
            if ($query->rowCount() > 0) {
                $result = $query->fetch(PDO::FETCH_ASSOC);
                return $result;
            }
            return false;
        }

        public function updateGrLink($uid, $link) {
            $query = $this->connect->query("UPDATE `users` SET `gr_link` = '$link' WHERE user_id = $uid;");

            if ($query) {
                return true;
            }
            return false;
        }

        public function getUserByEmail($email) {
            $query = $this->connect->query("SELECT user_id, email, company_name, company_logo, account_type, secret_key FROM `users` WHERE `email` = '$email'");

            if ($query->rowCount() > 0) {
                $result = $query->fetch(PDO::FETCH_ASSOC);
                return $result;
            }
            return false;
        }

        public function getUserBySecretKey($secretKey) {
            $query = $this->connect->query("SELECT user_id, email, company_name, company_logo, account_type, secret_key FROM `users` WHERE `secret_key` = '$secretKey'");

            if ($query->rowCount() > 0) {
                $result = $query->fetch(PDO::FETCH_ASSOC);
                return $result;
            }
        }

        public function updateSecretKey($id, $secretKey) {
            $query = $this->connect->query("UPDATE `users` SET `secret_key` = '$secretKey' WHERE `user_id` = '$id'");

            if ($query) {
                return true;
            }
            return false;
        }

        public function getSellerReviews($uid) {
            $avgRatingQuery = $this->connect->query("SELECT AVG(rating) AS avg_rating FROM ratings WHERE seller_id = $uid");

            $query = $this->connect->query("SELECT ratings.*, users.company_name
                FROM 
                    ratings
                JOIN 
                    users ON ratings.user_id = users.user_id
                WHERE 
                    ratings.seller_id = $uid;");

            if ($query->rowCount() > 0) {
                $avgRatingResult = $avgRatingQuery->fetch(PDO::FETCH_ASSOC);
                $result = $query->fetchAll(PDO::FETCH_ASSOC);

                return array(
                    'average_rating' => $avgRatingResult['avg_rating'],
                    'reviews' => $result
                );
            }
            return false;
        }

        public function getLoginCredentials($uid) {
            $query = $this->connect->query("SELECT email, password, secret_key FROM `users` WHERE `user_id` = '$uid'");

            if ($query->rowCount() > 0) {
                $result = $query->fetch(PDO::FETCH_ASSOC);
                return $result;
            }
            return false;
        }

        public function changePassword($uid, $encryptedPass, $newKey) {
            $query = $this->connect->query("UPDATE `users` SET `password` = '$encryptedPass', `secret_key` = '$newKey' WHERE `user_id` = '$uid';");
            
            if ($query) {
                return true;
            }
            return false;
        }

        public function updatePreferences($uid, $preferences) {
            $query = $this->connect->query("UPDATE `users` SET `newsletter_preference` = '$preferences' WHERE `user_id` = '$uid';");

            if ($query) {
                return true;
            }
            return false;
        }
        public function updatePostcodes($uid, $postcodes) {
            $query = $this->connect->query("UPDATE `users` SET `postcodes` = '$postcodes' WHERE `user_id` = '$uid';");

            if ($query) {
                return true;
            }
            return false;
        }

        public function createUser($company, $email, $password, $type, $list, $country, $gr_link, $key, $postcodes) {
            $validationErrors = $this->validateRegistration($company, $email, $password, $type, $list);
            if (empty($validationErrors)) {
                // Encrypt the password
                $encryptedPass = hash("sha256", $password);
        
                // Construct the query dynamically
                if ($type === 'seller') {
                    $query = "INSERT INTO `users` (`email`, `password`, `company_name`, `account_type`, `products_list`, `country`, `gr_link`, `secret_key`, `postcodes`) 
                              VALUES ('$email', '$encryptedPass', '$company', '$type', '$list', '$country', '$gr_link', '$key', '$postcodes')";
                } else {
                    $query = "INSERT INTO `users` (`email`, `password`, `company_name`, `account_type`, `products_list`, `country`, `gr_link`, `secret_key`) 
                              VALUES ('$email', '$encryptedPass', '$company', '$type', '$list', '$country', '$gr_link', '$key')";
                }
        
                // Execute the query
                $insertUser = $this->connect->query($query);
        
                // Get the last inserted user ID
                $lastInsertedId = $this->connect->lastInsertId();
        
                // Return success response
                return array("status" => "success", "inserted_id" => $lastInsertedId);
            }
        
            // Determine the redirect action based on the account type
            if ($type === 'buyer') {
                $accType = 'buyer-register';
            } else {
                $accType = 'seller-register';
            }
        
            // Return validation errors
            return array("action" => $accType, "status" => "danger", "messages" => $validationErrors);
        }              

        public function emailExists($email) {
            $query = $this->connect->query("SELECT * FROM `users` WHERE `email` = '$email'");

            if ($query->rowCount() > 0) {
                return true;
            }

            return false;
        }

        public function validateRegistration( $company, $email, $password,$type, $list) {
            $errors = [];

            if (!validateString($company)) {
                $errors[] = 'Invalid company name';
            }

            if (!validateEmail($email)) {
                $errors[] = 'Invalid email';
            }

            if (!validatePassword($password)) {
                $errors[] = 'Password must be at least 8 characters long';
            }

            return $errors;
        }

        public function deleteUser($user_id) {
            $query = $this->connect->query("DELETE FROM `users` WHERE `user_id` = '$user_id'");

            if ($query) {
                // delete all notifications for this user
                $this->connect->query("DELETE FROM `notifications` WHERE `sent_to` = '$user_id'");

                // select all products for this user
                $projectsQuery = $this->connect->query("SELECT * FROM `projects` WHERE `buyer_id` = '$user_id'");
                if ($projectsQuery->rowCount() > 0) {
                    $projects = $projectsQuery->fetchAll(PDO::FETCH_ASSOC);
                    foreach ($projects as $project) {
                        $project_id = $project['id'];

                        // delete all projects for this user
                        $this->connect->query("DELETE FROM `projects` WHERE `id` = '$project_id'");

                        // delete notifications for this project
                        $this->connect->query("DELETE FROM `notifications` WHERE `project_id` = '$project_id'");

                        // delete all project_items for this project
                        $this->connect->query("DELETE FROM `project_items` WHERE `project_id` = '$project_id'");

                        // delete price_offers for this project
                        $this->connect->query("DELETE FROM `price_offers` WHERE `project_id` = '$project_id'");

                        // delete offer_items for this project
                        $this->connect->query("DELETE FROM `offer_items` WHERE `project_id` = '$project_id'");

                        // delete ratings for this project
                        $this->connect->query("DELETE FROM `ratings` WHERE `project_id` = '$project_id'");
                    }
                }

                return true;
            }
            return false;
        }

        public function lastProjectCreated($uid) {
            $query = $this->connect->query("SELECT last_project_created FROM `users` WHERE `user_id` = '$uid'");
            if ($query->rowCount() > 0) {
                $result = $query->fetch(PDO::FETCH_ASSOC);
                return $result['last_project_created'];
            }
        }

        public function updateLastProjectCreated($uid) {
            $query = $this->connect->query("UPDATE `users` SET `last_project_created` = NOW() WHERE `user_id` = '$uid';");
            if ($query) {
                return true;
            }
            return false;
        }
        public function updateUserDetails($userId, $country, $currency, $dateFormat) {
            $query = $this->connect->query("
                UPDATE `users`
                SET 
                    `country` = '$country',
                    `currency` = '$currency',
                    `date_format` = '$dateFormat'
                WHERE 
                    `user_id` = '$userId';
            ");
            if ($query) {
                return true;
            }
            return false;
        }
        public function getUserDetails($userId) {
            $query = $this->connect->query("
                SELECT `country`, `currency`, `date_format`
                FROM `users`
                WHERE `user_id` = '$userId';
            ");
        
            if ($query->rowCount() > 0) {
                $result = $query->fetch(PDO::FETCH_ASSOC);
                return $result;
            }
            return false;
        }
        
        
    }
?>