<?php
    include 'Users.php';

    class Projects extends Users {
        // DB Stuff
        protected $connect;

        public function __construct() {
            // $DB = new Database();
            $this->connect = (new Database())->getConnection();
        }

        public function getReviews($uid) {
            $avgRatingQuery = $this->connect->query("SELECT AVG(rating) AS avg_rating FROM ratings WHERE seller_id = $uid");
            $totalReviewsQuery = $this->connect->query("SELECT COUNT(*) AS total FROM ratings WHERE seller_id = $uid");
        
            $avgRatingResult = $avgRatingQuery->fetch(PDO::FETCH_ASSOC);
            $totalReviewsResult = $totalReviewsQuery->fetch(PDO::FETCH_ASSOC);
        
            if ($totalReviewsResult['total'] > 0) {
                return array(
                    'average_rating' => $avgRatingResult['avg_rating'],
                    'total_reviews' => $totalReviewsResult['total']
                );
            }
            return false;
        }

        public function publishProduct($product_id) {
            $result = $this->connect->query("UPDATE `projects` SET `status` = '1' WHERE id = $product_id;");

            if($result) {
                return true;
            }
            return false;
        }

        public function addToProjectItems($project_id, $description, $product_type, $open_to_similar_brands, $quantity, $unit, $date_required, $product_image = '', $status = '0') {
            $ip = $this->get_client_ip();
            $locationInfo = $this->getCurrencyAndDateFormatByIp($ip);
            $currency = $locationInfo["currency"];
            $result = $this->connect->query("INSERT INTO `project_items` (`project_id`, `description`, `product_type`, `open_to_similar_brands`, `quantity`, `unit`, `date_required`, `product_image`, `status`, `currency`) VALUES ('$project_id', '$description', '$product_type', '$open_to_similar_brands', '$quantity', '$unit', '$date_required', '$product_image', '$status', '$currency');");

            if($result) {
                return $this->connect->lastInsertId();
            }
            return false;
        }

        public function updateProjectItemEditData($item_id, $edit_data) {
            $ip = $this->get_client_ip();
            $locationInfo = $this->getCurrencyAndDateFormatByIp($ip);
            $currency = $locationInfo["currency"];
            
            $result = $this->connect->query(
                "UPDATE `project_items` SET `edit_data` = '$edit_data', `currency` = '$currency' WHERE `id` = $item_id;"
            );
            
            if ($result) {
                return true;
            }
            return false;
        }
        
        public function getAllProjectItems($user_id) {
            $query = "SELECT * 
                    FROM
                        `project_items` as pi 
                    JOIN
                        projects AS p on pi.project_id = p.id
                    WHERE
                        p.buyer_id = $user_id";

            $result = $this->connect->query($query);
            if ($result && $result->rowCount() > 0) {
                return $result->fetchAll(PDO::FETCH_ASSOC);
            }
            return false;
        }

        public function getProjectItems($project_id, $status = 'all') {
            $condition = '';
            if ($status !== 'all') {
                $condition = "AND pi.status = '$status'";
            }
        
            $query = "SELECT 
                        pi.*,
                        p.image
                      FROM project_items AS pi
                      JOIN products AS p ON pi.product_type = p.name
                      WHERE 
                        pi.project_id = $project_id
                        $condition
                      ORDER BY pi.id ASC";
        
            $result = $this->connect->query($query);
        
            if ($result && $result->rowCount() > 0) {
                return $result->fetchAll(PDO::FETCH_ASSOC);
            } else {
                return false;
            }
        }

        public function updateProjectItemsStatus($project_id, $status = '0') {
            $ip = $this->get_client_ip();
            $locationInfo = $this->getCurrencyAndDateFormatByIp($ip);
            $currency = $locationInfo["currency"];
            
            $result = $this->connect->query(
                "UPDATE `project_items` SET `status` = '$status', `currency` = '$currency' WHERE `project_id` = $project_id;"
            );
        
            if ($result) {
                return true;
            }
            return false;
        }        

        public function getProjectItem($item_id) {
            $result = $this->connect->query("SELECT * FROM `project_items` WHERE `id` = $item_id");

            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getProjectItemFiles($project_id, $product_type) {
            $result = $this->connect->query("SELECT id, product_image, product_image_old FROM `project_items` WHERE project_id = $project_id AND product_type = '$product_type'");

            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updateProjectItemFiles($item_id, $product_image = '', $product_image_old = '') {
            $ip = $this->get_client_ip();
            $locationInfo = $this->getCurrencyAndDateFormatByIp($ip);
            $currency = $locationInfo["currency"];
            
            if ($product_image !== '') {
                $result = $this->connect->query(
                    "UPDATE `project_items` SET `product_image` = '$product_image', `currency` = '$currency' WHERE `id` = '$item_id';"
                );
            }
            
            if ($product_image_old !== '') {
                $result = $this->connect->query(
                    "UPDATE `project_items` SET `product_image_old` = '$product_image_old', `currency` = '$currency' WHERE `id` = '$item_id';"
                );
            }
        
            return true;
        }        

        public function getOfferItems($project_id, $product_name) {
            $result = $this->connect->query("SELECT 
                    oi.*, 
                    u.company_name AS supplier_name,
                    u.gr_link,
                    po.attached_file,
                    po.version
                FROM 
                    offer_items AS oi
                JOIN 
                    users AS u ON oi.seller_id = u.user_id
                LEFT JOIN
                    price_offers AS po ON oi.offer_id = po.offer_id
                WHERE 
                    oi.project_id = $project_id
                AND 
                    oi.product_name = '$product_name';");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);

                return $res;
            }
            return false;
        }

        public function getOfferItem($seller_id, $item_id) {
            $result = $this->connect->query("SELECT * FROM `offer_items` WHERE `seller_id` = $seller_id AND `item_id` = $item_id");
            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getOfferById($offer_id) {
            $result = $this->connect->query("SELECT * FROM `price_offers` WHERE `offer_id` = $offer_id");
            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updateOfferData($offer_id, $offer_data) {
            $result = $this->connect->query("UPDATE `price_offers` SET `offer_data` = '$offer_data' WHERE `offer_id` = $offer_id");

            if($result) {
                return true;
            }
            return false;
        }

        public function updateOfferAttachedFile($offer_id, $attached_file) {
            $result = $this->connect->query("UPDATE `price_offers` SET `attached_file` = '$attached_file' WHERE `offer_id` = $offer_id");

            if($result) {
                return true;
            }
            return false;
        }

        public function updateProject($pid, $project_name, $project_description, $post_code) {
            $result = $this->connect->query("UPDATE `projects` SET `project_name` = '$project_name', `project_description` = '$project_description',  `post_code` = '$post_code', `updated_on` = CURRENT_TIMESTAMP WHERE id = $pid;");
        
            if($result) {
                return true;
            }
            return false;
        }

        public function updateProjectItem($item_id, $description, $quantity, $unit, $date_required, $open_to_similar_brands) {
            $ip = $this->get_client_ip();
            $locationInfo = $this->getCurrencyAndDateFormatByIp($ip);
            $currency = $locationInfo["currency"];
            
            $result = $this->connect->query(
                "UPDATE `project_items` 
                 SET `description` = '$description', 
                     `open_to_similar_brands` = '$open_to_similar_brands', 
                     `quantity` = '$quantity', 
                     `unit` = '$unit', 
                     `date_required` = '$date_required', 
                     `currency` = '$currency', 
                     `is_updated` = '1' 
                 WHERE `id` = $item_id;"
            );
        
            if ($result) {
                return true;
            }
            return false;
        }        

        public function updateProjectItemX($item_id, $description) {
            $result = $this->connect->query("UPDATE `project_items` SET `description` = '$description' WHERE id = $item_id;");

            if($result) {
                return true;
            }
            return false;
        }

        public function addReview($user_id, $seller_id, $project_id, $offer_id, $item_id, $rating, $comment) {
            $result = $this->connect->query("INSERT INTO `ratings` (`user_id`, `seller_id`, `project_id`, `offer_id`, `item_id`, `rating`, `comment`) VALUES ('$user_id', '$seller_id', '$project_id', '$offer_id', '$item_id', '$rating', '$comment');");
            
            if($result) {
                return true;
            }
            return false;
        }

        public function getProjectReview($project_id, $offer_id = null) {
            $result = $this->connect->query("SELECT * FROM `ratings` WHERE project_id = '$project_id' AND offer_id = '$offer_id' LIMIT 1;");

            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function productISold($uid) {
            $result = $this->connect->query("SELECT
                p.id AS project_id,
                p.project_name,
                p.post_code,
                po.offer_id,
                po.offer_data,
                po.attached_file,
                po.status,
                u.company_name
            FROM
                projects p
            JOIN
                price_offers po ON p.id = po.project_id
            JOIN
                users u ON u.user_id = p.buyer_id
            WHERE
                po.seller_id = $uid
            ORDER BY 
                po.offer_id DESC;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getProductByName($name) {
            $result = $this->connect->query("SELECT * FROM `products` WHERE name = '$name'; LIMIT 1");
            
            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updateProductIOffer($uid, $start = null, $project_id = null) {
            $sql = "SELECT
                    p.id AS project_id,
                    p.project_name,
                    p.post_code,
                    po.offer_id,
                    po.offer_data,
                    po.attached_file,
                    po.status,
                    u.company_name
                FROM
                    projects p
                JOIN
                    price_offers po ON p.id = po.project_id
                JOIN
                    users u ON u.user_id = p.buyer_id
                WHERE
                    po.seller_id = $uid";

                if($start) {
                    $sql .= " AND po.offer_id > $start";
                }

                if($project_id) {
                    $sql .= " AND p.id = $project_id";
                }

                $sql .= " ORDER BY po.offer_id DESC";

            $result = $this->connect->query($sql);

            if ($result->rowCount() > 0) {
                $projects = $result->fetchAll(PDO::FETCH_ASSOC);

                $data = '';
                foreach($projects as $project) {
                    $status = '';
                    if($project["status"] === null) {
                        $status = '<b class="text-muted">Pending</b>';
                    }else {
                        $status = '<b class="text-muted">'.lcfirst($project["status"]).'</b>';
                    }

                    $product_name = strtolower($project["product_name"]);
                    $productsArray = explode(",", $product_name);
                    $product = $this->getProductByName($productsArray[0]);

                    $offerData = $project["offer_data"];
                    $arrayData = json_decode($offerData, true);

                    $prices = '';
                    foreach ($arrayData as $item) {
                        $vat = $item["vat"] === '1' ? "With VAT" : "Without VAT";

                        $prices .= '<div class="amount">
                            <span class="text-muted">'.ucfirst($item['product']).':</span> (<small class="text-muted">All the prices <strong>'.$vat.'</strong></small>)
                            <div class="">
                                <table>
                                    <tr>
                                        <td style="padding-right: 15px;">
                                            <b style="margin-right: 4px;">Product Price:</b>
                                            <b class="text-muted">£'.number_format($item['price'], 2).' </b>
                                        </td>';

                                    if(isset($item["delivery_price"]) && $item["delivery_price"] !== null) {
                                        $prices .= ' <td>
                                            <b style="margin-right: 4px;">Delivery Price:</b>
                                            <b class="text-muted">£'.number_format($item['delivery_price'], 2).' </b>
                                        </td>';
                                    }

                                    $prices .= '</tr>
                                        <tr>';

                                    if(isset($item["delivery_date"]) && $item["delivery_date"] !== null) {
                                        $prices .= '<td style="padding-right: 15px;">
                                            <b style="margin-right: 4px;">Delivery Date:</b>
                                            <b class="text-muted">'.$item['delivery_date'].' </b>
                                        </td>';
                                    }

                                    if(isset($item["payment_term"]) && $item["payment_term"] !== null) {
                                        $prices .= '<td>
                                            <b style="margin-right: 4px;">Payment Term:</b>
                                            <b class="text-muted">'.$item['payment_term'].' </b>
                                        </td>';
                                    }

                            $prices .= '</tr>
                                </table>
                            </div></div>';
                    }

                    $attached_file = '';
                    if(!empty($project["attached_file"])) {
                        $attached_file = '<span class="text-muted fw-normal pt-5">
                                <a class="text-decoration-none" style="color: #60CB97; font-weight: 500;" target="_blank" href="'.$project["attached_file"].'">Attachment</a>
                            </span>';
                    }

                    $data .= '<tr class="price-i-offer" data-id="'.$project["offer_id"].'" data-project="'.$project["project_id"].'">
                        <td>
                            <div class="p-img">
                                <img src="'.$product["image"].'" alt="">
                            </div>
                        </td>
                        <td>
                            <div class="" style="display: flex; justify-content: space-between;">
                                <span class="p-name">
                                    <h6>'.$project["project_name"].'</h6>
                                    <span class="text-muted fw-normal hide-company-name"><b>'.$project["company_name"].'</b></span>
                                    <span class="text-muted fw-normal"><b>Postcode: </b> '.$project["post_code"].'</span>
                                    
                                </span>
                                <div class="p-status">
                                    '.$status.'
                                </div>
                            </div>
                            '.$attached_file.'
                            <div class="p-amount" style="gap: 10px;">
                                '.$prices.'
                            </div>
                        </td>
                    </tr>';
                }

                $response = array(
                    'status' => "success",
                    'project_id' =>  $project["project_id"],
                    'data' => $data
                );

                return $response;
            }
            return false;
        }

        public function addProject($buyer_id, $project_name = '', $description = '', $post_code = '') {
            $insert = $this->connect->query("INSERT INTO `projects` (`buyer_id`, `project_name`, `project_description`, `post_code`) VALUES ('$buyer_id', '$project_name', '$description', '$post_code');");
            if($insert) {
                // send notifications to sellers
                $lastInsertedId = $this->connect->lastInsertId();

                return array("action" => "add-project", "status" => "success", "insert_id" => $lastInsertedId, "message" => "Project created successfully.");
            }
            return array("action" => "add-project", "status" => "danger", "message" => "Project creation failed. Please try again later!");
        }

        public function addToNofications($project_name, $description, $project_id, $seller_id) {
            $result = $this->connect->query("INSERT INTO `notifications` (`title`, `description`, `project_id`, `sent_to`) VALUES ('$project_name', '$description', '$project_id', '$seller_id');");
        
            if($result) {
                return true;
            }
            return false;
        }

        public function checkNotification($project_id, $seller_id) {
            $result = $this->connect->query("SELECT * FROM `notifications` WHERE `project_id` = $project_id AND `sent_to` = $seller_id");

            if ($result->rowCount() > 0) {
                return true;
            }
            return false;
        }

        public function getProject($id) {
            $result = $this->connect->query("SELECT * FROM `projects` WHERE `id` = $id");

            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getProjects($buyer_id = null, $status = null, $is_deleted = null) {
            $sql = "SELECT * FROM `projects` WHERE 1=1";
    
            if (!empty($buyer_id)) {
                $sql .= " AND `buyer_id` = $buyer_id";
            }
    
            if (!empty($status)) {
                $sql .= " AND `status` = '$status'";
            }
    
            if (is_array($is_deleted) && !empty($is_deleted)) {
                $is_deleted_list = implode("','", array_map('strval', $is_deleted));
                $sql .= " AND `is_deleted` IN ('$is_deleted_list')";
            } elseif (!is_null($is_deleted)) {
                $sql .= " AND `is_deleted` = '$is_deleted'";
            }
    
            $sql .= " ORDER BY `id` DESC";
    
            $result = $this->connect->query($sql);
    
            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getProductsBySearchKey($searchKey, $user_id) {
            // Split search key into individual keywords
            $keywords = explode(" ", $searchKey);
        
            // Initialize SQL query with a JOIN on project_items table
            $sql = "SELECT p.id, p.project_name, p.project_description, p.buyer_id, 
               GROUP_CONCAT(pi.id) AS item_ids, 
               GROUP_CONCAT(pi.description) AS item_descriptions, 
               GROUP_CONCAT(pi.product_type) AS item_product_types
        FROM projects p
        LEFT JOIN project_items pi ON p.id = pi.project_id 
        WHERE p.is_deleted = '0' AND p.buyer_id = " . $user_id;

// Dynamically add conditions for each keyword
foreach ($keywords as $index => $keyword) {
    $keyword = $this->connect->quote('%' . $keyword . '%'); // Quote and add wildcards around the keyword

    // Add conditions for project_name, project_description, and project_items fields
    $sql .= " AND (p.project_name LIKE " . $keyword . 
            " OR p.project_description LIKE " . $keyword . 
            " OR pi.description LIKE " . $keyword . 
            " OR pi.product_type LIKE " . $keyword . ")";
}

// Add GROUP BY clause for projects
$sql .= " GROUP BY p.id ORDER BY p.id DESC";

        
            // Execute the SQL query
            $result = $this->connect->query($sql);
        
            if ($result->rowCount() > 0) {
                return $result->fetchAll(PDO::FETCH_ASSOC);
            } else {
                return false;
            }
        }
        
        

        public function getProductsBySearchKeyX($searchKey, $user_id) {
            // Split search key into individual keywords
            $keywords = explode(" ", $searchKey);

            // Initialize SQL query
            $sql = "SELECT * FROM projects WHERE is_deleted = '0'";

            // Dynamically add conditions for each keyword
            foreach ($keywords as $index => $keyword) {
                $keyword = $this->connect->quote('%' . $keyword . '%'); // Quote and add wildcards around the keyword
                $sql .= " AND project_name LIKE " . $keyword;
            }

            $sql .= " AND buyer_id = ".$user_id."  ORDER BY id DESC";

            // Execute the SQL query
            $result = $this->connect->query($sql);

            if ($result->rowCount() > 0) {
                return $result->fetchAll(PDO::FETCH_ASSOC);
            } else {
                return false;
            }
        }

        public function getProjectsByDate($products, $country) {
            $sevenDaysAgo = date('Y-m-d H:i:s', strtotime('-7 days'));
        
            $sql = "SELECT p.id, p.buyer_id, p.project_name, p.post_code, p.project_description, MAX(p.added_on) AS max_added_on, MAX(pi.description) AS description, MAX(pi.product_type) AS product_type
                    FROM projects AS p
                    JOIN project_items AS pi ON pi.project_id = p.id
                    JOIN users AS u ON u.user_id = p.buyer_id
                    WHERE p.status = '1' AND p.is_deleted = '0' AND p.is_completed != '1' AND p.added_on > '$sevenDaysAgo' AND (";
        
            if ($country === 'all') {
                $sql .= "u.country = 'uk' OR u.country = 'ireland' OR u.country = 'all'";
            } else {
                if($country !== 'uk' || $country !== 'ireland') {
                    $sql .= "u.country = '$country' OR u.country = 'all'";
                }
            }
        
            $sql .= ") AND (";
        
            $pArray = explode(",", $products);
        
            foreach ($pArray as $index => $p) {
                if ($index > 0) {
                    $sql .= " OR ";
                }
                $sql .= "pi.product_type = '$p'";
            }
        
            $sql .= ") GROUP BY p.id";
        
            $result = $this->connect->query($sql);
        
            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            } else {
                return false;
            }
        }

        public function getProjectsByDateY($products , $country) {
            $sevenDaysAgo = date('Y-m-d H:i:s', strtotime('-7 days'));
        
            $sql = "SELECT p.id, MAX(p.added_on) AS max_added_on, MAX(pi.description) AS description, MAX(pi.product_type) AS product_type
                    FROM projects as p
                    JOIN project_items as pi ON pi.project_id = p.id
                    WHERE added_on > '$sevenDaysAgo' AND (";
        
            $pArray = explode(",", $products);
        
            foreach ($pArray as $index => $p) {
                if ($index > 0) {
                    $sql .= " OR ";
                }
                $sql .= "pi.product_type = '$p'";
            }
        
            $sql .= ") GROUP BY p.id";
        
            $result = $this->connect->query($sql);
            
            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            } else {
                return false;
            }
        }
        

        public function getProjectsByDateX($products) {
            // $sql = "SELECT * FROM `projects` WHERE ";
            $sevenDaysAgo = date('Y-m-d H:i:s', strtotime('-1 hour'));

            $sql = "SELECT
                    p.*,
                    pi.description,
                    pi.product_type
                FROM `projects` as p
                JOIN project_items as pi ON pi.project_id = p.id
                WHERE `added_on` > '$sevenDaysAgo'";

            $sql .= " AND (";

            $pArray = explode(",", $products);
            $x = 0;
            foreach($pArray as $p) {
                if($x > 0) {
                    $sql .= " OR";
                }
                $sql .= " pi.product_type = '$p'";

                $x++;
            }

            $sql .= ")";
            $sql .= " GROUP BY p.id";

            $result = $this->connect->query($sql);
            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return $sql;
        }

        public function deleteProject($pid, $type = '1') {
            $result = $this->connect->query("UPDATE `projects` SET `is_deleted` = '$type' WHERE id = $pid");
            if ($result) {
                return true;
            }
            return false;
        }

        public function deleteProjectPermanent($pid) {
            $result = $this->connect->query("DELETE FROM `projects` WHERE `id` = $pid");
            if ($result) {
                return true;
            }
            return false;
        }
        
        public function deleteProjectItem($item_id, $project_id) {
            $result = $this->connect->query("DELETE FROM `project_items` WHERE `id` = $item_id AND `project_id` = $project_id");
            if ($result) {
                return true;
            }
            return false;
        }

        // not used
        public function deleteAllProjectItems($pid) {
            $result = $this->connect->query("DELETE FROM `project_items` WHERE `project_id` = $pid");
            if ($result) {
                return true;
            }
            return false;
        }

        // not used
        public function deletePriceOffers($pid) {
            $result = $this->connect->query("DELETE FROM `price_offers` WHERE `project_id` = $pid");
            if ($result) {
                return true;
            }
            return false;
        }

        public function updateOfferItemsEditPermission($project_id, $product_name, $status) {
            $result = $this->connect->query("UPDATE `offer_items` SET `edit_permission` = '$status' WHERE `project_id` = $project_id AND `product_name` = '$product_name'");
            if ($result) {
                return true;
            }
            return false;
        }

        public function updateOfferItemEditable($project_id, $item_id, $status) {
            $result = $this->connect->query("UPDATE `offer_items` SET `is_editable` = '$status' WHERE `project_id` = $project_id AND `item_id` = $item_id");
            if ($result) {
                return true;
            }
            return false;
        }

        // not used
        public function deleteOfferItems($pid) {
            $result = $this->connect->query("DELETE FROM `offer_items` WHERE `project_id` = $pid");
            if ($result) {
                return true;
            }
            return false;
        }

        public function updateStatus($project_id, $offer_id, $item_id, $seller_id, $status) {
            $statusType = 0;
            if($status === "ordered") {
                $statusType = 1;
            }else if($status === "declined") {
                $statusType = 2;
            }else if($status === "order-out-of-website") {
                $statusType = 3;
            }

            $query = "UPDATE `projects` SET `is_completed` = '$statusType'";

            if(!empty($seller_id)) {
                $query .= " , `seller_id` = '$seller_id'";
            }

            $query .= " WHERE id = $project_id;";

            $results = $this->connect->query($query);

            $results = $this->connect->query("UPDATE `price_offers` SET `status` = '$status' WHERE offer_id = $offer_id;");
            $results = $this->connect->query("UPDATE `offer_items` SET `status` = '$status' WHERE id = $item_id;");

            if($results) {
                return array("status" => "success");
            }
            return array("status" => "error");
        }

        public function getAllPriceOffers($buyer_id) {
            $query = "SELECT *
                FROM
                    price_offers po
                JOIN
                    projects p ON po.project_id = p.id
                WHERE
                    p.buyer_id = $buyer_id
                ORDER BY
                    po.offer_id DESC";
                
            $result = $this->connect->query($query);
            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        // new
        public function getPriceOffers($project_id, $last_id = null, $buyer_id = null) {
                $query = "SELECT
                    po.*,
                    p.buyer_id,
                    u.company_name AS supplier_name
                FROM
                    price_offers po
                JOIN
                    users u ON po.seller_id = u.user_id
                JOIN
                	projects p on po.project_id = p.id";
                

                if($project_id) {
                    $query .= " WHERE po.project_id = $project_id";
                }

                if($buyer_id) {
                    $query .= " AND p.buyer_id = $buyer_id";
                }
                
                if(!empty($last_id)) {
                    $query .= " AND po.offer_id > $last_id";
                }
    
                $query .= " ORDER BY po.offer_id DESC";
    
                // echo $query;
    
                $result = $this->connect->query($query);
    
                if ($result->rowCount() > 0) {
                    $res = $result->fetchAll(PDO::FETCH_ASSOC);
                    return $res;
                }
                return false;
        }

        public function isPriceSent($projectId, $seller_id) {
            $result = $this->connect->query("SELECT * FROM `price_offers` WHERE `seller_id` = $seller_id AND `project_id` = $projectId");

            if ($result->rowCount() > 0) {
                return $result->rowCount();
            }
            return false;
        }

        public function updatePriceOffers($user_id) {
            $result = $this->connect->query("SELECT 
                    oi.*,
                    p.buyer_id,
                    p.seller_id,
                    po.attached_file,
                    pi.quantity,
                    u.company_name AS supplier_name,
                    u.gr_link,
                    AVG(r.rating) AS average_rating,
                    COUNT(r.rating) AS total_reviews
                FROM 
                    offer_items AS oi
                JOIN 
                    projects AS p ON oi.project_id = p.id AND p.buyer_id = $user_id
                JOIN
                    project_items AS pi ON pi.id = oi.item_id
                JOIN 
                    price_offers AS po ON oi.offer_id = po.offer_id
                JOIN 
                    users AS u ON oi.seller_id = u.user_id
                LEFT JOIN 
                    ratings AS r ON oi.seller_id = r.seller_id
                GROUP BY
                    oi.id, p.buyer_id, po.attached_file, u.company_name;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updatePriceOffersEditPermission($pid, $type, $seller_id = null) {
            $sql = "UPDATE `price_offers` SET `edit_permission` = '$type' WHERE `project_id` = $pid";

            if ($seller_id !== null) {
                $sql.= " AND `seller_id` = $seller_id";
            }

            $result = $this->connect->query($sql);

            if ($result) {
                return true;
            }
            return false;
        }

        public function updateOfferItemsEditPermissionBySellerId($project_id, $seller_id, $status) {
            $result = $this->connect->query("UPDATE `offer_items` SET `edit_permission` = '$status' WHERE `project_id` = $project_id AND `seller_id` = $seller_id;");
            if ($result) {
                return true;
            }
            return false;
        }

        public function updatePriceOffersY($user_id) {
            $result = $this->connect->query("SELECT 
                    oi.*,
                    p.buyer_id,
                    po.attached_file,
                    u.company_name AS supplier_name
                FROM 
                    offer_items AS oi
                JOIN 
                    projects AS p ON oi.project_id = p.id AND p.buyer_id = $user_id
                JOIN 
                    price_offers AS po ON oi.offer_id = po.offer_id
                JOIN 
                    users AS u ON oi.seller_id = u.user_id;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updatePriceOffersX($user_id) {
            $result = $this->connect->query("SELECT 
                price_offers.*,
                users.company_name AS supplier_name
            FROM 
                price_offers 
            JOIN 
                projects ON projects.id = price_offers.project_id
            JOIN
                users ON users.user_id = price_offers.seller_id
            WHERE 
                projects.buyer_id = $user_id;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }
        
        public function bestCombination($buyer_id) {
            $result = $this->connect->query("SELECT 
                DISTINCT 
                    projects.*
                FROM 
                    projects
                JOIN 
                    price_offers ON price_offers.project_id = projects.id
                WHERE 
                    projects.buyer_id = $buyer_id
                    AND projects.status = '1'
                    AND projects.is_deleted = '0'
                ORDER BY projects.id DESC;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updateBestCombination($buyer_id, $last_id ) {
            $result = $this->connect->query("SELECT 
                DISTINCT 
                    projects.*
                FROM 
                    projects
                JOIN 
                    price_offers ON price_offers.project_id = projects.id
                WHERE 
                    projects.buyer_id = $buyer_id AND 
                    projects.id > $last_id AND
                    projects.is_deleted = '0'
                ORDER BY 
                    projects.id DESC;");

            if ($result->rowCount() > 0) {
                $projects = $result->fetchAll(PDO::FETCH_ASSOC);

                $data = '';
                foreach($projects as $project) {
                    $data .= '<div class="single-combination" data-id="'.$project["id"].'">
                        <div class="product-name">
                            <h6>'.$project["project_name"].'</h6>
                            <div class="">
                                <img src="public/images/arrow.svg" alt="">
                            </div>
                        </div>
                        <div class="item" style="display: none;">
                            <div class="product-info d-flex align-items-center justify-content-between">
                                <div class="products">';

                    $projectItems = $this->getProjectItems($project["id"]);
                    foreach($projectItems as $item) {
                        $product = $this->getProductByName($item["product_type"]);

                        $data .= '<div class="" data-type="'.$item["id"].'">
                            <div class="product d-flex align-items-center">
                                <div class="p-img">
                                    <img src="'.$product["image"].'" alt="">
                                </div>
                                <div class="p-name">
                                    <h6>'.$product["name"].'</h6>
                                </div>
                            </div>
                            <div class="suppliers">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Suppliers</th>
                                            <th></th>
                                            <th>Best Price</th>
                                        </tr>
                                    </thead>
                                    <tbody class="offers-wrapper">';
                    
                        
                        $project_id = $item["project_id"];
                        $product_type = $item["product_type"];
                        $offerItems = $this->getBestCombinationItem($project_id, $product_type);

                        if($offerItems) {
                            foreach($offerItems as $offerId) {
                                if($item["id"] === $offerId["item_id"]) {
                                    $attached_file = '';
                                    if(!empty($offerId["attached_file"])) {
                                        $attached_file = '<div class="attachment"><a target="_blank" href="'.$offerId["attached_file"].'">Attachment</a></div>';
                                    }

                                    $vat = $offerId["vat"] === '1' ? 'With Vat' : 'Without Vat';

                                    $data .= '<tr class="project-history" data-id="'.$offerId["id"].'" data-price="'.$offerId["total_price"].'">
                                            <td class="supplier-name">
                                                <span>'.$offerId["supplier_name"].'</span>
                                            </td>
                                            <td>
                                                <div style="display: flex; flex-direction: column; gap: 5px;">
                                                    <div class="msg">
                                                        <a href="?add-to-chat='.$offerId["user_id"].'">
                                                            <img src="public/images/messages-3.svg" alt="">
                                                        </a>
                                                    </div>
                                                    '.$attached_file.'
                                                </div>
                                            </td>
                                            <td class="price">
                                                <ul class="list-unstyled">
                                                    <li>
                                                        <b>Product Price:</b>
                                                        <b>£'.number_format($offerId["product_price"], 2).'</b>
                                                    </li>
                                                    <li><i class="text-muted"></i>'.$vat.'</li>
                                                    <li>
                                                        <b>Delivery Price:</b>
                                                        <b>£'.number_format($offerId["delivery_price"], 2).'</b>
                                                    </li>
                                                    <li>
                                                        <b>Total Price:</b>
                                                        <b>£'.number_format($offerId["total_price"], 2).'</b>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>';
                                }
                            }
                        }

                        $data .= '</table>
                                </div>
                            </div>';
                    }

                    $data .= '</div>
                                </div>
                            </div>
                        </div>';
                }

                $response = array(
                    'status' => "success",
                    'data' => $data
                );

                return $response;
            }
            return false;
        }

        public function bestCombinationX($buyer_id) {
            $result = $this->connect->query("SELECT
                p.id AS project_id,
                p.project_name,
                p.product_name,
                p.project_description,
                po.seller_id,
                u.company_name AS supplier_name,
                po.price AS cheapest_offer_price,
                po.attached_file,
                po.created_at AS offer_created_at
            FROM
                projects p
            JOIN (
                SELECT
                    project_id,
                    MIN(price) AS price
                FROM
                    price_offers
                GROUP BY
                    project_id
            ) op_min ON p.id = op_min.project_id
            JOIN price_offers po ON op_min.project_id = po.project_id AND op_min.price = po.price
            JOIN users u ON po.seller_id = u.user_id
            WHERE
                p.buyer_id = $buyer_id;
            ");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getBestCombinationItem($project_id, $item_id) {
            $query = "SELECT 
                        oi.id,
                        oi.project_id,
                        oi.product_id,
                        oi.item_id,
                        oi.product_name,
                        oi.product_price,
                        oi.delivery_price,
                        oi.vat,
                        pi.quantity,
                        oi.bid_currency,
                        po.offer_id,
                        CASE
                            WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                                CASE 
                                    WHEN oi.vat = '0' THEN (oi.product_price * pi.quantity) + oi.delivery_price
                                    ELSE oi.product_price * pi.quantity + oi.delivery_price
                                END
                            WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                                CASE 
                                    WHEN oi.vat = '1' THEN ((oi.product_price * 100) / 120) * pi.quantity + oi.delivery_price
                                    ELSE oi.product_price * pi.quantity + oi.delivery_price
                                END
                            ELSE oi.product_price * pi.quantity + oi.delivery_price
                        END AS total_price,
                        u.user_id,
                        u.company_name AS supplier_name,
                        po.attached_file
                    FROM 
                        offer_items AS oi
                    JOIN 
                        users AS u ON oi.seller_id = u.user_id
                    JOIN
                        price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                    JOIN
                        project_items AS pi  ON pi.id = oi.item_id
                    WHERE 
                        oi.project_id = :project_id
                    AND 
                        oi.item_id = :item_id
                    AND
                        (oi.item_id, CASE
                            WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                                CASE 
                                    WHEN oi.vat = '0' THEN (oi.product_price * pi.quantity) + oi.delivery_price
                                    ELSE oi.product_price * pi.quantity + oi.delivery_price
                                END
                            WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                                CASE 
                                    WHEN oi.vat = '1' THEN ((oi.product_price * 100) / 120) * pi.quantity + oi.delivery_price
                                    ELSE oi.product_price * pi.quantity + oi.delivery_price
                                END
                            ELSE oi.product_price * pi.quantity + oi.delivery_price
                        END) IN (
                            SELECT oi2.item_id, 
                                MIN(
                                    CASE
                                        WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                                            CASE 
                                                WHEN oi2.vat = '0' THEN (oi2.product_price * pi.quantity) + oi2.delivery_price
                                                ELSE oi2.product_price * pi.quantity + oi2.delivery_price
                                            END
                                        WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                                            CASE 
                                                WHEN oi2.vat = '1' THEN ((oi2.product_price * 100) / 120) * pi.quantity + oi2.delivery_price
                                                ELSE oi2.product_price * pi.quantity + oi2.delivery_price
                                            END
                                        ELSE oi2.product_price * pi.quantity + oi2.delivery_price
                                    END
                                ) AS min_total_price
                            FROM offer_items AS oi2
                            WHERE oi2.project_id = :project_id
                            AND oi2.item_id = :item_id
                            GROUP BY oi2.item_id
                        )
                    ORDER BY
                        offer_id DESC, total_price ASC";
        
            try {
                $stmt = $this->connect->prepare($query);
                $stmt->bindParam(':project_id', $project_id);
                $stmt->bindParam(':item_id', $item_id);
                $stmt->execute();
        
                if ($stmt->rowCount() > 0) {
                    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    return $res;
                } else {
                    return false;
                }
            } catch (PDOException $e) {
                echo "Error: " . $e->getMessage();
                return false;
            }
        }  
        
        public function updateBestCombinationItem($user_id) {
            $query = "SELECT 
                        oi.id,
                        oi.project_id,
                        oi.product_id,
                        oi.item_id,
                        oi.product_name,
                        oi.product_price,
                        oi.delivery_price,
                        oi.vat,
                        pi.quantity,
                        CASE
                            WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                                CASE 
                                    WHEN oi.vat = '0' THEN (oi.product_price * 1.2) * pi.quantity + oi.delivery_price
                                    ELSE oi.product_price * pi.quantity + oi.delivery_price
                                END
                            WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                                CASE 
                                    WHEN oi.vat = '1' THEN ((oi.product_price * 100) / 120) * pi.quantity + oi.delivery_price
                                    ELSE oi.product_price * pi.quantity + oi.delivery_price
                                END
                            ELSE oi.product_price * pi.quantity + oi.delivery_price
                        END AS total_price,
                        u.user_id,
                        u.company_name AS supplier_name,
                        po.attached_file
                    FROM 
                        offer_items AS oi
                    JOIN 
                        users AS u ON oi.seller_id = u.user_id
                    JOIN
                        projects AS p ON oi.project_id = p.id
                    JOIN
                        price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                    JOIN
                        project_items AS pi  ON pi.id = oi.item_id
                    WHERE
                        (oi.item_id, CASE
                            WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                                CASE 
                                    WHEN oi.vat = '0' THEN (oi.product_price * 1.2) * pi.quantity + oi.delivery_price
                                    ELSE oi.product_price * pi.quantity + oi.delivery_price
                                END
                            WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                                CASE 
                                    WHEN oi.vat = '1' THEN ((oi.product_price * 100) / 120) * pi.quantity + oi.delivery_price
                                    ELSE oi.product_price * pi.quantity + oi.delivery_price
                                END
                            ELSE oi.product_price * pi.quantity + oi.delivery_price
                        END) IN (
                            SELECT oi2.item_id, 
                                MIN(
                                    CASE
                                        WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                                            CASE 
                                                WHEN oi2.vat = '0' THEN (oi2.product_price * 1.2) * pi.quantity + oi2.delivery_price
                                                ELSE oi2.product_price * pi.quantity + oi2.delivery_price
                                            END
                                        WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                                            CASE 
                                                WHEN oi2.vat = '1' THEN ((oi2.product_price * 100) / 120) * pi.quantity + oi2.delivery_price
                                                ELSE oi2.product_price * pi.quantity + oi2.delivery_price
                                            END
                                        ELSE oi2.product_price * pi.quantity + oi2.delivery_price
                                    END
                                )
                            FROM offer_items AS oi2
                            WHERE p.buyer_id = :user_id
                            GROUP BY oi2.item_id
                        )
                    ORDER BY 
                        item_id ASC, total_price ASC";
        
            try {
                $stmt = $this->connect->prepare($query);
                $stmt->bindParam(':user_id', $user_id);
                $stmt->execute();
        
                if ($stmt->rowCount() > 0) {
                    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    return $res;
                } else {
                    return false;
                }
            } catch (PDOException $e) {
                echo "Error: " . $e->getMessage();
                return false;
            }
        }
        
        // END
        public function getBestCombinationItemM($project_id, $product_name) {
            $result = $this->connect->query("SELECT 
                    oi.id,
                    oi.project_id,
                    oi.product_id,
                    oi.item_id,
                    oi.product_name,
                    oi.product_price,
                    oi.delivery_price,
                    oi.vat,
                    pi.quantity,
                    CASE
                        WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                            CASE 
                                WHEN oi.vat = '0' THEN (oi.product_price * 1.2) * pi.quantity + oi.delivery_price
                                ELSE oi.product_price * pi.quantity + oi.delivery_price
                            END
                        WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                            CASE 
                                WHEN oi.vat = '1' THEN ((oi.product_price * 100) / 120) * pi.quantity + oi.delivery_price
                                ELSE oi.product_price * pi.quantity + oi.delivery_price
                            END
                        ELSE oi.product_price * pi.quantity + oi.delivery_price
                    END AS total_price,
                    u.user_id,
                    u.company_name AS supplier_name,
                    po.attached_file
                FROM 
                    offer_items AS oi
                JOIN 
                    users AS u ON oi.seller_id = u.user_id
                JOIN
                    price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                JOIN
                    project_items AS pi  ON pi.id = oi.item_id
                WHERE 
                    oi.project_id = $project_id
                AND 
                    oi.product_name = '$product_name'
                AND
                    (oi.item_id, CASE
                        WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                            CASE 
                                WHEN oi.vat = '0' THEN (oi.product_price * 1.2) * pi.quantity + oi.delivery_price
                                ELSE oi.product_price * pi.quantity + oi.delivery_price
                            END
                        WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                            CASE 
                                WHEN oi.vat = '1' THEN ((oi.product_price * 100) / 120) * pi.quantity + oi.delivery_price
                                ELSE oi.product_price * pi.quantity + oi.delivery_price
                            END
                        ELSE oi.product_price * pi.quantity + oi.delivery_price
                    END) IN (
                        SELECT oi2.item_id, MIN(
                            CASE
                                WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                                    CASE 
                                        WHEN oi2.vat = '0' THEN (oi2.product_price * 1.2) * pi.quantity + oi.delivery_price
                                        ELSE oi2.product_price * pi.quantity + oi.delivery_price
                                    END
                                WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                                    CASE 
                                        WHEN oi2.vat = '1' THEN ((oi2.product_price * 100) / 120) * pi.quantity + oi.delivery_price
                                        ELSE oi2.product_price * pi.quantity + oi.delivery_price
                                    END
                                ELSE oi2.product_price * pi.quantity + oi.delivery_price
                            END
                        )
                        FROM offer_items AS oi2
                        WHERE oi2.project_id = $project_id
                        AND oi2.product_name = '$product_name'
                        GROUP BY oi2.item_id
                    )
                ORDER BY
                    item_id ASC, total_price ASC;");
                    

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updateBestCombinationItemM($user_id) {
            $result = $this->connect->query("SELECT 
                    oi.id,
                    oi.project_id,
                    oi.product_id,
                    oi.item_id,
                    oi.product_name,
                    oi.product_price,
                    oi.delivery_price,
                    oi.vat,
                    pi.quantity,
                    CASE
                        WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                            CASE 
                                WHEN oi.vat = '0' THEN (oi.product_price * 1.2) * pi.quantity
                                ELSE oi.product_price * pi.quantity
                            END
                        WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                            CASE 
                                WHEN oi.vat = '1' THEN ((oi.product_price * 100) / 120) * pi.quantity
                                ELSE oi.product_price * pi.quantity
                            END
                        ELSE oi.product_price * pi.quantity
                    END AS total_price,
                    u.user_id,
                    u.company_name AS supplier_name,
                    po.attached_file
                FROM 
                    offer_items AS oi
                JOIN 
                    users AS u ON oi.seller_id = u.user_id
                JOIN
                    projects AS p ON oi.project_id = p.id
                JOIN
                    price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                JOIN
                    project_items AS pi  ON pi.id = oi.item_id
                WHERE
                    (oi.item_id, CASE
                        WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                            CASE 
                                WHEN oi.vat = '0' THEN (oi.product_price * 1.2) * pi.quantity
                                ELSE oi.product_price * pi.quantity
                            END
                        WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                            CASE 
                                WHEN oi.vat = '1' THEN ((oi.product_price * 100) / 120) * pi.quantity
                                ELSE oi.product_price * pi.quantity
                            END
                        ELSE oi.product_price * pi.quantity
                    END) IN (
                        SELECT oi2.item_id, MIN(
                            CASE
                                WHEN '".$_SESSION['vat-type']."' = 'with-vat' THEN
                                    CASE 
                                        WHEN oi2.vat = '0' THEN (oi2.product_price * 1.2) * pi.quantity
                                        ELSE oi2.product_price * pi.quantity
                                    END
                                WHEN '".$_SESSION['vat-type']."' = 'without-vat' THEN
                                    CASE 
                                        WHEN oi2.vat = '1' THEN ((oi2.product_price * 100) / 120) * pi.quantity
                                        ELSE oi2.product_price * pi.quantity
                                    END
                                ELSE oi2.product_price * pi.quantity
                            END
                        )
                        FROM offer_items AS oi2
                        WHERE p.buyer_id = $user_id
                        GROUP BY oi2.item_id
                    )
                ORDER BY 
                    item_id ASC, total_price ASC;");


            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getBestCombinationItemB($project_id, $product_name) {
            $result = $this->connect->query("SELECT 
                    oi.id,
                    oi.project_id,
                    oi.product_id,
                    oi.item_id,
                    oi.product_name,
                    oi.product_price,
                    oi.delivery_price,
                    oi.vat,
                    CASE 
                        WHEN oi.vat = '0' THEN (oi.product_price + oi.delivery_price) * 1.2
                        WHEN oi.vat = '1' THEN oi.product_price + oi.delivery_price
                        ELSE NULL
                    END AS total_price,
                    u.user_id,
                    u.company_name AS supplier_name,
                    po.attached_file
                FROM 
                    offer_items AS oi
                JOIN 
                    users AS u ON oi.seller_id = u.user_id
                JOIN
                    price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                WHERE 
                    oi.project_id = $project_id
                AND 
                    oi.product_name = '$product_name'
                AND
                    (oi.item_id, CASE 
                        WHEN oi.vat = '0' THEN (oi.product_price + oi.delivery_price) * 1.2
                        WHEN oi.vat = '1' THEN oi.product_price + oi.delivery_price
                        ELSE NULL
                    END) IN (
                        SELECT oi2.item_id, MIN(
                            CASE 
                                WHEN oi2.vat = '0' THEN (oi2.product_price + oi2.delivery_price) * 1.2
                                WHEN oi2.vat = '1' THEN oi2.product_price + oi2.delivery_price
                                ELSE NULL
                            END
                        )
                        FROM offer_items AS oi2
                        WHERE oi2.project_id = $project_id
                        AND oi2.product_name = '$product_name'
                        GROUP BY oi2.item_id
                    )
                ORDER BY 
                    item_id ASC, total_price ASC;");




            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updateBestCombinationItemB($user_id) {
            $result = $this->connect->query("SELECT 
                    oi.id,
                    oi.project_id,
                    oi.product_id,
                    oi.item_id,
                    oi.product_name,
                    oi.product_price,
                    oi.delivery_price,
                    oi.vat,
                    CASE 
                        WHEN oi.vat = '0' THEN (oi.product_price + oi.delivery_price) * 1.2
                        WHEN oi.vat = '1' THEN oi.product_price + oi.delivery_price
                        ELSE NULL
                    END AS total_price,
                    u.user_id,
                    u.company_name AS supplier_name,
                    po.attached_file
                FROM 
                    offer_items AS oi
                JOIN 
                    users AS u ON oi.seller_id = u.user_id
                JOIN
                    projects AS p ON oi.project_id = p.id
                JOIN
                    price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                WHERE
                    (oi.item_id, CASE 
                        WHEN oi.vat = '0' THEN (oi.product_price + oi.delivery_price) * 1.2
                        WHEN oi.vat = '1' THEN oi.product_price + oi.delivery_price
                        ELSE NULL
                    END) IN (
                        SELECT oi2.item_id, MIN(
                            CASE 
                                WHEN oi2.vat = '0' THEN (oi2.product_price + oi2.delivery_price) * 1.2
                                WHEN oi2.vat = '1' THEN oi2.product_price + oi2.delivery_price
                                ELSE NULL
                            END
                        )
                        FROM offer_items AS oi2
                        WHERE p.buyer_id = $user_id
                        GROUP BY oi2.item_id
                    )
                ORDER BY 
                    item_id ASC, total_price ASC;");




            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updateBestCombinationItemY($user_id) {
            $result = $this->connect->query("SELECT
                    oi.id,
                    oi.product_name,
                    oi.project_id,
                    oi.product_price AS min_price,
                    u.user_id,
                    u.company_name AS supplier_name,
                    po.attached_file,
                    p.project_name,
                    COALESCE(ratings.average_rating, 0) AS average_rating,
                    COALESCE(ratings.total_reviews, 0) AS total_reviews
                FROM
                    offer_items AS oi
                JOIN
                    users AS u ON oi.seller_id = u.user_id
                JOIN
                    price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                JOIN
                    projects AS p ON oi.project_id = p.id
                LEFT JOIN (
                    SELECT
                        seller_id,
                        AVG(rating) AS average_rating,
                        COUNT(*) AS total_reviews
                    FROM
                        ratings
                    GROUP BY
                        seller_id
                ) AS ratings ON u.user_id = ratings.seller_id
                WHERE
                    (oi.product_name, oi.product_price, oi.project_id) IN (
                        SELECT
                            oi2.product_name,
                            MIN(oi2.product_price) AS min_price,
                            oi2.project_id
                        FROM
                            offer_items AS oi2
                        GROUP BY
                            oi2.product_name, oi2.project_id
                    )
                AND
                    p.buyer_id = $user_id;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function updateBestCombinationItemZ($user_id) {
            $result = $this->connect->query("SELECT
                    oi.id,
                    oi.product_name,
                    oi.project_id,
                    oi.product_price AS min_price,
                    u.user_id,
                    u.company_name AS supplier_name,
                    po.attached_file,
                    p.project_name
                FROM
                    offer_items AS oi
                JOIN
                    users AS u ON oi.seller_id = u.user_id
                JOIN
                    price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                JOIN
                    projects AS p ON oi.project_id = p.id
                WHERE
                    (oi.product_name, oi.product_price, oi.project_id) IN (
                        SELECT
                            oi2.product_name,
                            MIN(oi2.product_price) AS min_price,
                            oi2.project_id
                        FROM
                            offer_items AS oi2
                        GROUP BY
                            oi2.product_name, oi2.project_id
                    )
                AND
                    p.buyer_id = $user_id;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getBestCombinationItemY($project_id, $product_name) {
            $result = $this->connect->query("SELECT 
                    oi.product_name, 
                    u.user_id, 
                    u.company_name AS supplier_name, 
                    oi.product_price AS min_price, 
                    po.attached_file
                FROM 
                    offer_items AS oi
                JOIN 
                    users AS u ON oi.seller_id = u.user_id
                JOIN 
                    price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                WHERE 
                    oi.project_id = $project_id
                AND 
                    oi.product_name = '$product_name'
                AND
                    oi.product_price = (
                        SELECT 
                            MIN(product_price)
                        FROM 
                            offer_items
                        WHERE 
                            project_id = $project_id
                        AND 
                            product_name = '$product_name'
                    );");

            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getBestCombinationItemX($project_id, $product_name) {
            $result = $this->connect->query("SELECT 
                    oi.product_name, u.user_id, u.company_name as supplier_name, MIN(oi.product_price) AS min_price, po.attached_file
                FROM 
                    offer_items AS oi
                JOIN 
                    users AS u ON oi.seller_id = u.user_id
                JOIN 
                    price_offers AS po ON oi.project_id = po.project_id AND oi.seller_id = po.seller_id
                WHERE 
                    oi.project_id = $project_id
                AND 
                    oi.product_name = '$product_name'
                GROUP BY 
                    u.user_id, u.company_name, po.attached_file;");

            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }
        public function get_client_ip() {
            $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP']))
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            else if(isset($_SERVER['HTTP_X_FORWARDED']))
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            else if(isset($_SERVER['HTTP_FORWARDED']))
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            else if(isset($_SERVER['REMOTE_ADDR']))
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            else
                $ipaddress = 'UNKNOWN';
            return $ipaddress;
        }
        public function getCurrencyAndDateFormatByIp($ip) {
            // Using geoPlugin API for geolocation
            $url = "http://www.geoplugin.net/json.gp?ip={$ip}";
        
            // Initialize cURL session
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            curl_close($ch);
        
            // Decode the JSON response
            $data = json_decode($response, true);
        
            if (isset($data['geoplugin_countryCode'])) {
                $countryCode = $data['geoplugin_countryCode'];
                $currency = $this->getCurrencyByCountry($countryCode);
        
                return [
                    'country' => $countryCode,
                    'currency' => $currency,
                ];
            } else {
                return null; // If country information is not available
            }
        }
        public function getCurrencyByCountry($countryCode) {
            // Currency symbols mapped to countries
            $currencyMap = [
                'US' => '$',  // USD
                'GB' => '£',  // GBP
                'IN' => '₹',  // INR
                'CA' => '$',  // CAD
                'AU' => '$',  // AUD
                'PK' => '₨',  // PKR
                'DE' => '€',  // EUR
                'FR' => '€',  // EUR
                'IT' => '€',  // EUR
                'ES' => '€',  // EUR
                'CN' => '¥',  // CNY
                'JP' => '¥',  // JPY
                'BR' => 'R$', // BRL
                'MX' => '$',  // MXN
                'RU' => '₽',  // RUB
                'KR' => '₩',  // KRW
                'SG' => '$',  // SGD
                'ZA' => 'R',  // ZAR
                'SE' => 'kr', // SEK
                'IL' => '₪',  // ILS
            ];
        
            return isset($currencyMap[$countryCode]) ? $currencyMap[$countryCode] : null;
        }
    }
?>