<?php
    class Messages {
        // DB Stuff
        protected $connect;

        public function __construct() {
            // $DB = new Database();
            $this->connect = (new Database())->getConnection();
        }

        public function addToChat($uid, $seller_id) {
            $check = $this->connect->query("SELECT * FROM `messages`
                WHERE 
                    (`sender_id` = $uid AND `receiver_id` = $seller_id) OR
                    (`sender_id` = $seller_id AND `receiver_id` = $uid)");

            if ($check->rowCount() > 0) {
                return true;
            }else {
                $result = $this->connect->query("INSERT INTO `messages` (`sender_id`, `receiver_id`) VALUES ('$uid', '$seller_id');");
                if($result) {
                    return true;
                }
                return false;
            }
        }
        
        public function getPeopleList($uid) {
            try {

                $result = $this->connect->query("SELECT
                        u.user_id AS user_id,
                        u.company_name,
                        u.company_logo
                    FROM (
                        SELECT DISTINCT
                            CASE
                                WHEN sender_id = $uid THEN receiver_id
                                ELSE sender_id
                            END AS user_id
                        FROM
                            messages
                        WHERE
                            (sender_id = $uid OR receiver_id = $uid)
                            AND (sender_id <> $uid OR receiver_id <> $uid)
                    ) AS connected_users
                    JOIN
                        users u ON connected_users.user_id = u.user_id;");
    
                if ($result->rowCount() > 0) {
                    $res = $result->fetchAll(PDO::FETCH_ASSOC);
                    return $res;
                }
                return false;
            } catch (PDOException $e) {
                // Handle the exception or log the error
                echo "Error: " . $e->getMessage();
                return false; // Return an error code or message
            }
        }

        public function updateChatUser($uid, $activeUserId = '') {
            $peoples = $this->getPeopleList($uid);

            if($peoples) {
                $data = '';
                foreach($peoples as $people) {
                    $receiver_id = $people["user_id"];

                    $unreadMessages = $this->connect->query("SELECT 
                        COUNT(*) AS nr
                        FROM messages
                        WHERE
                            sender_id = $receiver_id AND receiver_id = $uid
                            AND (message_text IS NOT NULL OR attached_file IS NOT NULL)
                            AND read_at = '0';");

                    $count = $unreadMessages->fetch(PDO::FETCH_ASSOC);

                    $badge = '';
                    if($count["nr"] > 0) {
                        $badge = '<span style="margin-left: 8px; transform: translateY(-2px);" class="badge rounded-pill bg-danger">'.$count["nr"].'</span>';
                    }

                    $style = '';
                    if($activeUserId) {
                        if($receiver_id == $activeUserId) {
                            $style ='active';
                        }
                    }

                    $data .= '<li class="chat-user '.$style.' clearfix" data-id="'.$receiver_id.'">
                        <a href="javascript:void(0)">
                            <div class="profile d-flex align-items-center">
                                <img src="public/images/'.$people["company_logo"].'" alt="avatar">
                                <div class="about">
                                    <div class="name hide-company-name">'.$people["company_name"].' '.$badge.'</div>
                                </div>
                            </div>
                        </a>
                    </li>';
                }

                return array("status" => "success", "result" => $data);
            }
            return array("status" => "error");
        }

        public function chatUserDetails($chat_id) {
            $result = $this->connect->query("SELECT company_name, company_logo FROM `users` WHERE user_id = $chat_id");

            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function getMessages($user1, $user2) {
            $result = $this->connect->query("SELECT
                IF(@prev_date = DATE(c.sent_at), '', c.sent_at) AS chat_at,
                    c.message_id,
                    c.sent_at AS chat_timestamp,
                    c.sender_id AS user_id,
                    u.company_name,
                    u.company_logo,
                    c.message_text,
                    c.attached_file,
                    c.file_name,
                    @prev_date := DATE(c.sent_at)
                FROM
                    messages c
                JOIN
                    users u ON c.sender_id = u.user_id
                CROSS JOIN
                    (SELECT @prev_date := NULL) init
                WHERE
                    ((c.sender_id = $user1 AND c.receiver_id = $user2) OR
                    (c.sender_id = $user2 AND c.receiver_id = $user1))
                    AND (c.message_text IS NOT NULL OR c.attached_file IS NOT NULL)
                ORDER BY c.message_id DESC
                LIMIT 20;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);
                return array_reverse($res);
            }
            return false;
        }

        public function loadMoreMessages($user1, $user2, $first_id) {
            $result = $this->connect->query("SELECT
                IF(@prev_date = DATE(c.sent_at), '', c.sent_at) AS chat_at,
                    c.message_id,
                    c.sent_at AS chat_timestamp,
                    c.sender_id AS user_id,
                    u.company_name,
                    u.company_logo,
                    c.message_text,
                    c.attached_file,
                    c.file_name,
                    @prev_date := DATE(c.sent_at)
                FROM
                    messages c
                JOIN
                    users u ON c.sender_id = u.user_id
                CROSS JOIN
                    (SELECT @prev_date := NULL) init
                WHERE
                    ((c.sender_id = $user1 AND c.receiver_id = $user2) OR
                    (c.sender_id = $user2 AND c.receiver_id = $user1))
                    AND (c.message_text IS NOT NULL OR c.attached_file IS NOT NULL)
                    AND (c.message_id < $first_id)
                ORDER BY c.message_id DESC
                LIMIT 20;");

            if ($result->rowCount() > 0) {
                $chats = $result->fetchAll(PDO::FETCH_ASSOC);
                // return array_reverse($res);

                if($chats) {
                    $data = '';
                    foreach(array_reverse($chats) as $chat) {
                        $attached_file = '';
                        if(!empty($chat["attached_file"]) && $chat["file_name"]) {
                            $allowedExtensions = array("jpg", "jpeg", "png", "gif");
    
                            $uploadedFileName = $chat["attached_file"]; // Replace with the actual uploaded file name
                            $fileExtension = strtolower(pathinfo($uploadedFileName, PATHINFO_EXTENSION));
    
                            if (in_array($fileExtension, $allowedExtensions)) {
                                $attached_file =  '<div class="chat-msg-image">
                                        <a target="_blank" href="'.$chat["attached_file"].'">
                                            <img src="'.$chat["attached_file"].'" alt="'.$chat["file_name"].'">
                                        </a>
                                    </div>';
                            } else {
                                $attached_file = '<div class="chat-msg-file">
                                        <div class="file-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="file-arrow-down">
                                                <rect width="25" height="25 " fill="none"></rect><polygon points="152 32 152 88 208.008 88 152 32" opacity=".2"></polygon><path fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" d="M200,224.00005H55.99219a8,8,0,0,1-8-8V40a8,8,0,0,1,8-8L152,32l56,56v128A8,8,0,0,1,200,224.00005Z"></path><polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="152 32 152 88 208.008 88"></polyline><polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="100 156 128 184 156 156"></polyline><line x1="128" x2="128" y1="120" y2="184" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></line>
                                            </svg>
                                        </div>
                                        <div class="file-url">
                                            <a target="_blank" href="'.$chat["attached_file"].'">'.$chat["file_name"].'</a>
                                        </div>
                                    </div>';
                            }
                        }
    
                        $msgText = '';
                        if(!empty($chat["message_text"])) {
                            $msgText = '<div class="chat-msg-text">'.$chat["message_text"].'</div>';
                        }

                        if($chat["user_id"] == $_SESSION["user_id"]) {
                            $width = 'width: 100%;';
                        }else {
                            $width = 'width: calc(100% - 60px);';
                        }
    
                        $data .= '<div data-id="'.$chat["message_id"].'" class="chat-msg '.($chat["user_id"] == $_SESSION["user_id"] ? 'owner' : '').'">
                            <div class="chat-msg-content">
                                <div class="chat-msg-date">'.date("h:i A", strtotime($chat["chat_timestamp"])).'</div>
                                <div class="msg-body">
                                    <div class="chat-msg-profile">
                                        <img class="chat-msg-img" src="public/images/'.$chat["company_logo"].'" alt="">
                                    </div>
                                    <div class="" style="'.$width.'">
                                        '.$attached_file.'
                                        '.$msgText.'
                                    </div>
                                </div>
                            </div>
                        </div>';
                    }
    
                    return array("total" => $result->rowCount(), "chats" => $data);
                }
            }
            
            return false;
        }

        public function updateMessages($user1, $user2, $last_msg) {
            $result = $this->connect->query("SELECT
            IF(@prev_date = DATE(c.sent_at), '', c.sent_at) AS chat_at,
                c.message_id,
                c.sent_at AS chat_timestamp,
                c.sender_id AS user_id,
                u.company_name,
                u.company_logo,
                c.message_text,
                c.attached_file,
                c.file_name,
                @prev_date := DATE(c.sent_at)
            FROM
                messages c
            JOIN
                users u ON c.sender_id = u.user_id
            CROSS JOIN
                (SELECT @prev_date := NULL) init
            WHERE
                ((c.sender_id = $user1 AND c.receiver_id = $user2) OR
                (c.sender_id = $user2 AND c.receiver_id = $user1))
                AND (c.message_text IS NOT NULL OR c.attached_file IS NOT NULL)
                AND (c.message_id > $last_msg)
            ORDER BY c.sent_at;");
            
            $chats = $result->fetchAll(PDO::FETCH_ASSOC);
            if($chats) {
                // Read all messages for the chat
                $this->markMessagesAsRead($user1);

                $data = '';
                foreach($chats as $chat) {
                    $attached_file = '';
                    if(!empty($chat["attached_file"]) && $chat["file_name"]) {
                        $allowedExtensions = array("jpg", "jpeg", "png", "gif");

                        $uploadedFileName = $chat["attached_file"]; // Replace with the actual uploaded file name
                        $fileExtension = strtolower(pathinfo($uploadedFileName, PATHINFO_EXTENSION));

                        if (in_array($fileExtension, $allowedExtensions)) {
                            $attached_file =  '<div class="chat-msg-image">
                                    <a target="_blank" href="'.$chat["attached_file"].'">
                                        <img src="'.$chat["attached_file"].'" alt="'.$chat["file_name"].'">
                                    </a>
                                </div>';
                        } else {
                            $attached_file = '<div class="chat-msg-file">
                                    <div class="file-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="file-arrow-down">
                                            <rect width="25" height="25 " fill="none"></rect><polygon points="152 32 152 88 208.008 88 152 32" opacity=".2"></polygon><path fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" d="M200,224.00005H55.99219a8,8,0,0,1-8-8V40a8,8,0,0,1,8-8L152,32l56,56v128A8,8,0,0,1,200,224.00005Z"></path><polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="152 32 152 88 208.008 88"></polyline><polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="100 156 128 184 156 156"></polyline><line x1="128" x2="128" y1="120" y2="184" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></line>
                                        </svg>
                                    </div>
                                    <div class="file-url">
                                        <a target="_blank" href="'.$chat["attached_file"].'">'.$chat["file_name"].'</a>
                                    </div>
                                </div>';
                        }
                    }

                    $msgText = '';
                    if(!empty($chat["message_text"])) {
                        $msgText = '<div class="chat-msg-text">'.$chat["message_text"].'</div>';
                    }

                    $data .= '<div data-id="'.$chat["message_id"].'" class="chat-msg '.($chat["user_id"] == $_SESSION["user_id"] ? 'owner' : '').'">
                        <div class="chat-msg-content">
                            <div class="chat-msg-date">'.date("h:i A", strtotime($chat["chat_timestamp"])).'</div>
                            <div class="msg-body">
                                <div class="chat-msg-profile">
                                    <img class="chat-msg-img" src="public/images/'.$chat["company_logo"].'" alt="">
                                </div>
                                <div class="" style="width: 100%;">
                                    '.$attached_file.'
                                    '.$msgText.'
                                </div>
                            </div>
                        </div>
                    </div>';
                }

                return $data;
            }

            return false;
        }

        public function sendMessage($sender_id, $receiver_id, $message_text, $uploadedFilePath, $file_name) {
            // Mark as read previous messages]
            $this->readAll($sender_id);

            try {
                $result = $this->connect->prepare("INSERT INTO messages (sender_id, receiver_id, message_text, attached_file, file_name) VALUES (:sender_id, :receiver_id, :message_text, :attached_file, :file_name);");
                $result->bindParam(':sender_id', $sender_id);
                $result->bindParam(':receiver_id', $receiver_id);
                $result->bindParam(':message_text', $message_text);
                $result->bindParam(':attached_file', $uploadedFilePath);
                $result->bindParam(':file_name', $file_name);
                $result->execute();
        
                return $result->rowCount();
            } catch (PDOException $e) {
                // Handle the exception or log the error
                echo "Error: " . $e->getMessage();
                return 0; // Return an error code or message
            }
        }

        public function markMessagesAsRead($user1) {
            $result = $this->connect->query("UPDATE messages SET read_at = '1' WHERE receiver_id = $user1;");
                    
            if($result) {
                return true;
            }

            return false;
        }

        public function readAll($user_id) {
            $result = $this->connect->query("UPDATE messages
                SET read_at = '1'
                WHERE 
                    receiver_id = $user_id
                    AND read_at = '0';");

            if($result) {
                return true;
            }
            return false;
        }

        public function getLastMessage($user1, $user2) {
            $result = $this->connect->query("SELECT 
                    m.message_id,
                    m.sent_at
                FROM messages AS m
                WHERE
                    ((m.sender_id = 1 AND m.receiver_id = 2) OR
                    (m.sender_id = 2 AND m.receiver_id = 1))
                ORDER BY m.message_id DESC
                LIMIT 1;");
            
            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return false;
        }

        public function unreadMessagesCount($user_id) {
            $result = $this->connect->query("SELECT COUNT(DISTINCT sender_id) AS unread_count
                    FROM messages
                    WHERE receiver_id = $user_id AND read_at = '0';");
            
            if ($result->rowCount() > 0) {
                $res = $result->fetch(PDO::FETCH_ASSOC);
                return $res;
            }
            return 0;
        }
    }
?>