<?php
    session_start();

    include './load.php';
    include './templates/header.php';

    include './app/models/Users.php';

    if(!isSeller()) {
        
    }

    $uid = $_SESSION["user_id"];

    $users = new Users();
    // echo json_encode($messages);

    $user = $users->getUserById($uid);
?>

<style>
    .header-right .search {
        position: relative;
        /* min-width: 300px;
        width: 420px; */
    }

    /* For small screens (mobile devices) */
    @media screen and (max-width: 480px) {
        .header-right .search {
            min-width: 200px;
            width: 280px !important;
        }
    }

    /* For medium screens (tablets or smaller laptops) */
    @media screen and (min-width: 481px) and (max-width: 768px) {
        .header-right .search {
            min-width: 250px;
            width: 350px !important;
        }
    }

    /* For larger screens (desktops and large laptops) */
    @media screen and (min-width: 769px) and (max-width: 1200px) {
        .header-right .search {
            /* min-width: 300px; */
            width: 420px !important;
        }
    }

    /* For extra-large screens (wide desktops or high-res monitors) */
    @media screen and (min-width: 1201px) and (max-width: 1600px) {
        .header-right .search {
            min-width: 350px;
            width: 500px !important;
        }
    }

    /* For very large screens (extremely wide monitors) */
    @media screen and (min-width: 1601px) {
        .header-right .search {
            min-width: 400px;
            width: 600px !important;
        }
    }
</style>

<div class="edit-product d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item <?php echo $_SESSION["show"] === "home" ? "active" : ""; ?>">
                        <a href="seller.php?show=home">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.06 10.23L21.42 4.18503C19.065 2.53503 15.45 2.62503 13.185 4.38003L5.66999 10.245C4.16999 11.415 2.98499 13.815 2.98499 15.705V26.055C2.98499 29.88 6.08998 33 9.91498 33H26.085C29.91 33 33.015 29.895 33.015 26.07V15.9C33.015 13.875 31.71 11.385 30.06 10.23ZM19.125 27C19.125 27.615 18.615 28.125 18 28.125C17.385 28.125 16.875 27.615 16.875 27V22.5C16.875 21.885 17.385 21.375 18 21.375C18.615 21.375 19.125 21.885 19.125 22.5V27Z" fill="#dfdfdf"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left">
                    <div class="header-title">
                        <h3 class="m-0">Seller Page</h3>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                </div>
                <div class="header-right">
                    <div class="search">
                        <form action="search.php" method="GET">
                            <div class="icon">
                                <button type="submit" style="height: auto; border: 0; background-color: transparent;">
                                    <svg width="18" height="18" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.5 13C7.88314 13.0022 9.23062 12.5613 10.345 11.742H10.344C10.374 11.782 10.406 11.82 10.442 11.857L14.292 15.707C14.4795 15.8946 14.7339 16.0001 14.9991 16.0002C15.2644 16.0003 15.5189 15.895 15.7065 15.7075C15.8941 15.52 15.9996 15.2656 15.9997 15.0004C15.9998 14.7351 15.8945 14.4806 15.707 14.293L11.857 10.443C11.8212 10.4068 11.7828 10.3734 11.742 10.343C12.5611 9.22927 13.002 7.88249 13 6.5C12.9995 4.77626 12.3145 3.12326 11.0956 1.90439C9.87674 0.68552 8.22374 0.000530138 6.5 0C4.77609 0 3.12279 0.684819 1.90381 1.90381C0.684819 3.12279 0 4.77609 0 6.5C0 8.22391 0.684819 9.87721 1.90381 11.0962C3.12279 12.3152 4.77609 13 6.5 13Z" fill="#60CB97"/>
                                    </svg>
                                </button>
                                </div>
                            <input class="form-control" type="text" name="search_key" id="search-input" placeholder="Search your query">
                        </form>
                    </div>

                    <div class="notification">
                    </div>
                    
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="change-password.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" data-name="Layer 1" viewBox="0 0 24 24" id="edit">
                                            <path d="M3.5,24h15A3.51,3.51,0,0,0,22,20.487V12.95a1,1,0,0,0-2,0v7.537A1.508,1.508,0,0,1,18.5,22H3.5A1.508,1.508,0,0,1,2,20.487V5.513A1.508,1.508,0,0,1,3.5,4H11a1,1,0,0,0,0-2H3.5A3.51,3.51,0,0,0,0,5.513V20.487A3.51,3.51,0,0,0,3.5,24Z"></path><path d="M9.455,10.544l-.789,3.614a1,1,0,0,0,.271.921,1.038,1.038,0,0,0,.92.269l3.606-.791a1,1,0,0,0,.494-.271l9.114-9.114a3,3,0,0,0,0-4.243,3.07,3.07,0,0,0-4.242,0l-9.1,9.123A1,1,0,0,0,9.455,10.544Zm10.788-8.2a1.022,1.022,0,0,1,1.414,0,1.009,1.009,0,0,1,0,1.413l-.707.707L19.536,3.05Zm-8.9,8.914,6.774-6.791,1.4,1.407-6.777,6.793-1.795.394Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Edit</span>
                                    </a>
                                </li>
                                <hr>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" viewBox="0 0 24 24" id="logout">
                                            <path d="M12.59,13l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L12.59,11H3a1,1,0,0,0,0,2ZM12,2A10,10,0,0,0,3,7.55a1,1,0,0,0,1.8.9A8,8,0,1,1,12,20a7.93,7.93,0,0,1-7.16-4.45,1,1,0,0,0-1.8.9A10,10,0,1,0,12,2Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content">
            <div class="">
                <div class="update-product">
                    <?php
                        if(isset($response) && $response["type"] === "form-msg") {
                            ?>
                                <div class="alert alert-<?php echo $response["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                    <?php echo $response["message"]; ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php
                        }

                        if(isset($_GET["status"]) && isset($_GET["message"])) {
                            ?>
                                <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                    <?php echo $_GET["message"]; ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php
                        }
                    ?>

                    <div class="card mb-3">
                        <div class="card-header">Update Preferences</div>
                        <div class="card-body">
                            <div class="form-group product-list mb-15">
                                <label for="" class="d-flex align-items-center gap-2">
                                    <input type="checkbox" name="notifications" id="notifications" <?php echo $user["newsletter_preference"] === '1' ? 'checked' : ''; ?>> Notifications
                                </label>
                            </div>
                        </div>
                    </div>
    
                    <div class="card">
                        <div class="card-header">Change Password</div>
                        <div class="card-body">
                            <form action="app/core/change-password.php" method="POST">
                                <div class="form-group product-list mb-15">
                                    <label for="">Current Password</label>
                                    <input type="password" name="current-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group product-list mb-15">
                                    <label for="">New Password</label>
                                    <input type="password" name="new-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group product-list mb-15">
                                    <label for="">Confirm Password</label>
                                    <input type="password" name="confirm-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group">
                                    <button type="submit" name="change-password" value="1" class="btn butn-primary">Change Password</button>
                                </div>
                            </form>
                        </div>
                    </div>
    
                </div>
            </div>
            
            <!-- Include Footer -->
            <footer>
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>
                                    
                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });
        
        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });
    });
</script>