<?php
    session_start();

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    include '../../load.php';
    include '../models/Notifications.php';
    include '../models/Projects.php';
    include '../models/Products.php';
    include '../models/Settings.php';
    // include '../models/Users.php';

    $notifications = new Notifications();
    $projects = new Projects();
    $users = new Users();
    $products = new Products();
    $settings = new Settings();

    if(isset($_POST['action']) && $_POST['action'] == 'NEW_ITEMS_PRICE') {
        $seller_id = $_SESSION["user_id"];
        $project_id = $_POST["project_id"];
        $notif_id = $_POST["notif_id"];

        $checkOffer = $notifications->checkOffer($seller_id, $notif_id);

        $offer_id = $checkOffer["result"][0]["offer_id"];
        $offer_data = $checkOffer["result"][0]["offer_data"];

        $offer_data_array = json_decode($offer_data);

        // echo json_encode($offer_data_array);

        $newArrayData = array();
        foreach ($offer_data_array as $offer_data) {
            $newArrayData[] = $offer_data;
        }

        // echo json_encode($newArrayData);

        // exit;

        // echo json_encode($_POST)
        $newItemIds = array();

        $sellerName = 'one of the register seller';
        if($settings->get_option("hide-seller-name") === "1") {
            $sellerName = $_SESSION["userData"]["company_name"];
        }

        foreach ($_POST['product_type'] as $key => $product_type) {
            $item_id = $_POST['item_id'][$key];
            $product_price = $_POST['product_price'][$key];
            $vat_input = $_POST['vat_input'][$key];
            $delivery_price = !empty($_POST['delivery_price'][$key]) ? $_POST['delivery_price'][$key] : 0;
            $delivery_date = !empty($_POST['delivery_date'][$key]) ? $_POST['delivery_date'][$key] : null;
            $payment_term = !empty($_POST['payment_term'][$key]) ? $_POST['payment_term'][$key] : null;

            // product id
            $productData = $products->getProductByName($product_type);
            $product_id = $productData["id"];

            // Create an object for each product and add it to the array
            $product = array(
                "item_id" => $item_id,
                "product_id" => $product_id,
                "product" => $product_type,
                "price" => $product_price,
                "vat" => $vat_input,
                "delivery_price" => $delivery_price,
                "delivery_date" => $delivery_date,
                "payment_term" => $payment_term
            );

            // Decode the JSON string into an array
            $items = json_decode(json_encode($newArrayData), true);

            $replaceIndex = null;
            foreach ($items as $index => $item) {
                if ($item['item_id'] == $item_id) {
                    $replaceIndex = $index;
                    break;
                }
                
            }

            // echo $replaceIndex;
            // exit;
            $ip = get_client_ip();
            $locationInfo = getCurrencyAndDateFormatByIp($ip);

            if ($replaceIndex !== null) {
                $newArrayData[$replaceIndex] = $product;

                $offerData = $projects->getOfferItem($seller_id, $item_id);
                $offer_item_id = $offerData["id"];

                // echo $offer_item_id;

                $notifications->updateOfferItem($offer_item_id, $item_id, $product_price, $vat_input, $delivery_price, $delivery_date, $payment_term, $is_editable = '0', $locationInfo["currency"]);
            }else {
                array_push($newArrayData, $product);

                $offer_item = $notifications->addToOfferItems($offer_id, $seller_id, $project_id, $item_id, $product_id, $product_type, $product_price, $vat_input, $delivery_price, $delivery_date, $payment_term, $locationInfo["currency"]);
                
                if($offer_item) {
                    array_push($newItemIds, $offer_item);
                }
            }
        }

        // echo json_encode($newArrayData);
        // exit;

        $projects->updateOfferData($offer_id, json_encode($newArrayData));
        // $projects->updatePriceOffersEditPermission($project_id, 0);
        $projects->updatePriceOffersEditPermission($project_id, 0, $seller_id);
        $projects->updateOfferItemsEditPermissionBySellerId($project_id, $seller_id, '0');

        $product_data = $newArrayData;

        $uploadedFilePath = '';
        $file_name = '';
        if(isset($_FILES["attached-file"])) {
            $file = $_FILES["attached-file"];

            $uploadDirectory = "uploads/";
            $newFileName = generateSecretKey(8);
            $uploadedFilePath = $uploadDirectory . pathinfo($file["name"], PATHINFO_FILENAME) . '_' .$newFileName . "." . pathinfo($file["name"], PATHINFO_EXTENSION);
            $file_name = $file["name"];

            // echo $uploadedFilePath;
            if (move_uploaded_file($file["tmp_name"], "../../" . $uploadedFilePath)) {
                // echo $file["name"] . "File has been uploaded successfully.";
            } else {
                // echo "Failed to upload the file.";
                $uploadedFilePath = '';
            }
        }

        if($uploadedFilePath != '') {
            $projects->updateOfferAttachedFile($offer_id, $uploadedFilePath);
        }

        $project = $projects->getProject($project_id);
        $buyer_id = $project["buyer_id"];

        $subject = "You've received a new price offer";

        $buyer = $users->getUserById($buyer_id);
        $message = '<!DOCTYPE html>
            <html>
                <head>
                    <style>
                        @import url("https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap");
                    </style>
                </head>
                <body>
                    <div style="background-color: #f6f6f6;">
                        <div style="width: 600px; margin: auto; background-color: #fff;">
                            <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                            </div>
                            <div class="template-body">
                                <div style="padding: 0 80px">
                                    <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; text-transform: uppercase; unicode-bidi: plaintext;">Don\'t give up on getting the best price!</h1>
                                    <div class="image" style="width: 70%; margin: auto; padding: 30px 0;">
                                        <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-2.png" alt="">
                                    </div>
                                </div>
                                <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                    <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                    <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW PRICE OFFER</h1>
                                    <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">You receive a new price offer from '. $sellerName .':</h3>
                                    <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                        <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$project["project_name"].'</h3>
                                        <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$project["post_code"].'</p>
                                        <div class="products-wrapper" style="width: 97.8%; background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';

        foreach($product_data  as $item) {
            $item = json_decode(json_encode($item), true);

            $itemWidth = '100%';
            if(count($product_data) > 1) {
                $itemWidth = '50%';
            }

            $vatStatus = '(Without VAT)';
            if($item["vat"] === '1') {
                $vatStatus = '(With VAT)';
            }

            $description = '';
            $open_to_similar_brands = '';
            $quantity = '';
            $unit = '';
            $date_required = '';
            $tp = '';

            if($item["item_id"]) {
                $project_item = $projects->getProjectItem($item["item_id"]);

                $description = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;">' . $project_item["description"] . '</p>';
                
                $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($project_item["open_to_similar_brands"]).'</p>';

                if($project_item["quantity"]) {
                    $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.$project_item["quantity"].'</p>';
                }

                if($project_item["unit"]) {
                    $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.$project_item["unit"].'</p>';
                }

                if($project_item["date_required"]) {
                    $date_required = '<p style="margin-bottom: 8px; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.$project_item["date_required"].'</p>';
                }
                
                if(!empty($item["price"]) && !empty($item["delivery_price"])) {
                    $tp = '<p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Total Price:</b> £'.number_format(($item["price"] * $project_item["quantity"]) + $item["delivery_price"], 2).'</p>';
                }
            }

            $dp = '';
            if(!empty($item["delivery_price"])) {
                $dp = '<p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Delivery Price:</b> £'.number_format($item["delivery_price"], 2).'</p>';
            }

            $dd = '';
            if(!empty($item["delivery_date"])) {
                $dd = '<p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Delivery Date:</b> '.$item["delivery_date"].'</p>';
            }

            $dt = '';
            if(!empty($item["payment_term"])) {
                $dt = '<p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Payment Term:</b> '.$item["payment_term"].'</p>';
            }


            $message .= '<div class="product-item" style="box-sizing: border-box; width: '.$itemWidth.'; display: inline-block; padding: 7.5px;">
                <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                    <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($item["product"]).'</h3>
                    '.$description.'
                    <p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Product price:</b> £'.number_format($item["price"], 2).' '.$vatStatus.'</p>
                    '.$dp.'
                    '.$tp.'
                    '.$dd.'
                    '.$dt.'
                    </div>
                </div>'; 
        }

        $message .= '</div>
                </div>';

        if($uploadedFilePath != '') {
            $message .= '<div class="project-history" style="display: flow-root; background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px; padding: 15px;">
            <a href="'. BASE_URL .''. $uploadedFilePath.'" style="text-decoration: none;">
                <div>
                    <div class="file-icon" style="margin-right: 20px; float: left;">
                        <img style="width: 40px;" src="https://www.connectionsys.co.uk/public/images/file-icon.png" alt="">
                    </div>
                    <div class="attachment-info" style="width: 100%;">
                        <div style="float: left;">
                            <h4 style="margin-top: 0; margin-bottom: 5px; font-weight: 500; color: #000; font-size: 16px; width: 290px; text-align: left;">'.$file_name.'</h4>
                            <p style="margin: 0; font-size: 13px; color: #60CB97; text-align: left;">View Attachment</p>
                        </div>
                        <img style="width: 20px; float: right; padding-top: 15px;" src="https://www.connectionsys.co.uk/public/images/download-icon.png" alt="">
                    </div>
                </div>
            </a>
        </div>';
        }

        $message .= '<div class="button" style="text-align: center;">
                                <a href="https://www.connectionsys.co.uk/">
                                    <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Click For More Details</button>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                        <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                        <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                    </div>
                </div>
            </div>
        </body></html>';

        // echo $message;

        $buyer = $users->getUserById($buyer_id);
        if($buyer) {
            $email = $buyer["email"];
            $company_name = $buyer["company_name"];

            // if($email === "mdnurealamsiddiq36@gmail.com") {}
            // if($email !== "sales@a1building.co.uk" && $email !== "filip@uk-timber.co.uk" && $email !== "richard.jones@walls-and-ceilings.co.uk" && $email !== "luke.raven@belgradeinsulations.com" && $email !== "braden.hayes@uvalueinsulations.co.uk") {}
            
            
            if($buyer["newsletter_preference"] === '1') {
                $mail = new PHPMailer();

                try {
                    //Server settings
                    // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                    $mail->isSMTP();                                            //Send using SMTP
                    $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                    $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                    $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                    $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                    $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                
                    //Recipients
                    $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                    $mail->addAddress($email, $company_name);     //Add a recipient
                    // $mail->addAddress('ellen@example.com');               //Name is optional
                    $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                
                    //Content
                    $mail->isHTML(true);                                  //Set email format to HTML
                    $mail->Subject = $subject;
                    $mail->Body    = $message;
                    // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                
                    $mail->send();
                    // echo 'Message has been sent';
                } catch (Exception $e) {
                    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                    exit;
                }
            }

            // echo $message;

            // exit;
        }

        echo json_encode(array("status" => "success"));
    }

    if(isset($_POST['action']) && $_POST['action'] == 'OFFER_PRICE') {
        $seller_id = $_SESSION["user_id"];
        $project_id = $_POST["project_id"];
        $notif_id = $_POST["notif_id"];
        // $price = $_POST["price"];

        $checkOffer = $notifications->checkOffer($seller_id, $notif_id);

        // echo json_encode($checkOffer);

        // exit;

        $product_data = array();

        if($checkOffer["status"] === "success") {
            $offer_id = $checkOffer["result"][0]["offer_id"];
            $notifications->deletePriceOffer($offer_id);
            $notifications->deleteOfferItems($offer_id, $seller_id);

            $attached_file = $checkOffer["result"][0]["attached_file"];
            if($attached_file != '') {
                unlink("../../uploads/" . $attached_file);
            }

            // $offerData = $checkOffer["result"][0]["offer_data"];
            // $arrayData = json_decode($offerData, true);

            $newArrayData = array();

            // Iterate through the array to find and update the price
            foreach ($_POST['product_type'] as $key => $product_type) {
                $item_id = $_POST['item_id'][$key];
                $product_type = $_POST['product_type'][$key];
                $product_price = $_POST['product_price'][$key];
                $vat_input = $_POST['vat_input'][$key];
                $delivery_price = !empty($_POST['delivery_price'][$key]) ? $_POST['delivery_price'][$key] : 0;
                $delivery_date = !empty($_POST['delivery_date'][$key]) ? $_POST['delivery_date'][$key] : null;
                $payment_term = !empty($_POST['payment_term'][$key]) ? $_POST['payment_term'][$key] : null;

                $productData = $products->getProductByName($product_type);
                $product_id = $productData["id"];

                $product = array(
                    "item_id" => $item_id,
                    "product_id" => $product_id,
                    "product" => $product_type,
                    "price" => $product_price,
                    "vat" => $vat_input,
                    "delivery_price" => $delivery_price,
                    "delivery_date" => $delivery_date,
                    "payment_term" => $payment_term
                );

                array_push($newArrayData, $product);

                // foreach ($arrayData as $product) {
                //     if ($product['product'] === $product_type) {
                //         // Change the price to a new value
                //         $product['price'] = $product_price;
                //         $product['vat'] = $vat_input;
                //         $product['delivery_price'] = $delivery_price;
                //         $product['delivery_date'] = $delivery_date;
                //         $product['payment_term'] = $payment_term;
                        
                //         // break;
                //     }
                // }
            }

            $product_data = $newArrayData;

            $projects->updatePriceOffersEditPermission($project_id, 0);

        }else {
            // Iterate through the product_type[] and product_price[] arrays
            foreach ($_POST['product_type'] as $key => $product_type) {
                $item_id = $_POST['item_id'][$key];
                $product_price = $_POST['product_price'][$key];
                $vat_input = $_POST['vat_input'][$key];
                $delivery_price = !empty($_POST['delivery_price'][$key]) ? $_POST['delivery_price'][$key] : 0;
                $delivery_date = !empty($_POST['delivery_date'][$key]) ? $_POST['delivery_date'][$key] : null;
                $payment_term = !empty($_POST['payment_term'][$key]) ? $_POST['payment_term'][$key] : null;

                // product id
                $productData = $products->getProductByName($product_type);
                $product_id = $productData["id"];

                // Create an object for each product and add it to the array
                $product = array(
                    "item_id" => $item_id,
                    "product_id" => $product_id,
                    "product" => $product_type,
                    "price" => $product_price,
                    "vat" => $vat_input,
                    "delivery_price" => $delivery_price,
                    "delivery_date" => $delivery_date,
                    "payment_term" => $payment_term
                );

                array_push($product_data, $product);
            }
        }

        // echo json_encode($product_data);
        // exit;

        $uploadedFilePath = '';
        $file_name = '';
        if(isset($_FILES["attached-file"])) {
            $file = $_FILES["attached-file"];

            $uploadDirectory = "uploads/";
            $newFileName = generateSecretKey(8);
            $uploadedFilePath = $uploadDirectory . pathinfo($file["name"], PATHINFO_FILENAME) . '_' .$newFileName . "." . pathinfo($file["name"], PATHINFO_EXTENSION);
            $file_name = $file["name"];

            // echo $uploadedFilePath;
            if (move_uploaded_file($file["tmp_name"], "../../" . $uploadedFilePath)) {
                // echo $file["name"] . "File has been uploaded successfully.";
            } else {
                // echo "Failed to upload the file.";
                $uploadedFilePath = '';
            }
        }

        $offer_data = json_encode($product_data);
        $res = $notifications->offerPrice($seller_id, $project_id, $notif_id, $offer_data, $uploadedFilePath);

        // echo $offer_data;

        if($res) {
            $offer_id = $res["offer_id"];

            $sellerName = 'one of the register seller';
            if($settings->get_option("hide-seller-name") === "1") {
                $sellerName = $_SESSION["userData"]["company_name"];
            }

            $ip = get_client_ip();
            $locationInfo = getCurrencyAndDateFormatByIp($ip);

            foreach($product_data as $item) {
                $item_id = !empty($item["item_id"]) ? $item["item_id"] : 0;
                $product_id = !empty($item["product_id"]) ? $item["product_id"] : 0;
                $product_name = $item["product"];
                $product_price = $item["price"];
                $vat = $item["vat"];
                $delivery_price = !empty($item["delivery_price"]) ? $item["delivery_price"] : 0;
                $delivery_date = !empty($item["delivery_date"]) ? $item["delivery_date"] : null;
                $payment_term = !empty($item["payment_term"]) ? $item["payment_term"] : null;
    
                $notifications->addToOfferItems($offer_id, $seller_id, $project_id, $item_id, $product_id, $product_name, $product_price, $vat, $delivery_price, $delivery_date, $payment_term, $locationInfo["currency"]);
            }

            // if($checkOffer["status"] === "error") {
            // }

            $project = $projects->getProject($project_id);
            $buyer_id = $project["buyer_id"];

            $subject = "You've received a new price offer";

            $message = '<!DOCTYPE html>
            <html>
                <head>
                    <style>
                        @import url("https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap");
                    </style>
                </head>
                <body>
                    <div style="background-color: #f6f6f6;">
                        <div style="width: 600px; margin: auto; background-color: #fff;">
                            <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                            </div>
                            <div class="template-body">
                                <div style="padding: 0 80px">
                                    <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; text-transform: uppercase; unicode-bidi: plaintext;">Don\'t give up on getting the best price!</h1>
                                    <div class="image" style="width: 70%; margin: auto; padding: 30px 0;">
                                        <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-2.png" alt="">
                                    </div>
                                </div>
                                <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                    <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                    <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW PRICE OFFER</h1>
                                    <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">You receive a new price offer from '. $sellerName .':</h3>
                                    <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                        <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$project["project_name"].'</h3>
                                        <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$project["post_code"].'</p>
                                        <div class="products-wrapper" style="width: 97.8%; background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';

                foreach($product_data as $item) {
                    $itemWidth = '100%';
                    if(count($product_data) > 1) {
                        $itemWidth = '50%';
                    }

                    $vatStatus = '(Without VAT)';
                    if($item["vat"] === '1') {
                        $vatStatus = '(With VAT)';
                    }

                    $description = '';
                    $open_to_similar_brands = '';
                    $quantity = '';
                    $unit = '';
                    $date_required = '';
                    $tp = '';

                    if($item["item_id"]) {
                        $project_item = $projects->getProjectItem($item["item_id"]);

                        $description = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;">' . $project_item["description"] . '</p>';
                        
                        $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($project_item["open_to_similar_brands"]).'</p>';

                        if($project_item["quantity"]) {
                            $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.$project_item["quantity"].'</p>';
                        }
        
                        if($project_item["unit"]) {
                            $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.$project_item["unit"].'</p>';
                        }
        
                        if($project_item["date_required"]) {
                            $date_required = '<p style="margin-bottom: 8px; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.$project_item["date_required"].'</p>';
                        }
                        
                        if(!empty($item["price"]) && !empty($item["delivery_price"])) {
                            $tp = '<p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Total Price:</b> £'.number_format(($item["price"] * $project_item["quantity"]) + $item["delivery_price"], 2).'</p>';
                        }
                    }

                    $dp = '';
                    if(!empty($item["delivery_price"])) {
                        $dp = '<p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Delivery Price:</b> £'.number_format($item["delivery_price"], 2).'</p>';
                    }

                    $dd = '';
                    if(!empty($item["delivery_date"])) {
                        $dd = '<p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Delivery Date:</b> '.$item["delivery_date"].'</p>';
                    }

                    $dt = '';
                    if(!empty($item["payment_term"])) {
                        $dt = '<p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Payment Term:</b> '.$item["payment_term"].'</p>';
                    }


                    $message .= '<div class="product-item" style="box-sizing: border-box; width: '.$itemWidth.'; display: inline-block; padding: 7.5px;">
                        <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                            <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($item["product"]).'</h3>
                            '.$description.'
                            <p style="margin-bottom: 0; margin-top: 0; color: #60CB97; font-size: 12px; font-weight: 600; text-align: left;"><b>Product price:</b> £'.number_format($item["price"], 2).' '.$vatStatus.'</p>
                            '.$dp.'
                            '.$tp.'
                            '.$dd.'
                            '.$dt.'
                            </div>
                        </div>'; 
                }
                $message .= '</div>
                        </div>';

                if($uploadedFilePath != '') {
                    $message .= '<div class="project-history" style="display: flow-root; background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px; padding: 15px;">
                    <a href="'. BASE_URL .''. $uploadedFilePath.'" style="text-decoration: none;">
                        <div>
                            <div class="file-icon" style="margin-right: 20px; float: left;">
                                <img style="width: 40px;" src="https://www.connectionsys.co.uk/public/images/file-icon.png" alt="">
                            </div>
                            <div class="attachment-info" style="width: 100%;">
                                <div style="float: left;">
                                    <h4 style="margin-top: 0; margin-bottom: 5px; font-weight: 500; color: #000; font-size: 16px; width: 290px; text-align: left;">'.$file_name.'</h4>
                                    <p style="margin: 0; font-size: 13px; color: #60CB97; text-align: left;">View Attachment</p>
                                </div>
                                <img style="width: 20px; float: right; padding-top: 15px;" src="https://www.connectionsys.co.uk/public/images/download-icon.png" alt="">
                            </div>
                        </div>
                    </a>
                </div>';
                }

                $message .= '<div class="button" style="text-align: center;">
                                        <a href="https://www.connectionsys.co.uk/">
                                            <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Click For More Details</button>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                            </div>
                        </div>
                    </div>
                </body></html>';

            $buyer = $users->getUserById($buyer_id);
            if($buyer) {
                $email = $buyer["email"];
                $company_name = $buyer["company_name"];

                // if($email === "mdnurealamsiddiq36@gmail.com") {}
                // if($email !== "sales@a1building.co.uk" && $email !== "filip@uk-timber.co.uk" && $email !== "richard.jones@walls-and-ceilings.co.uk" && $email !== "luke.raven@belgradeinsulations.com" && $email !== "braden.hayes@uvalueinsulations.co.uk") {}
                
                
                if($buyer["newsletter_preference"] === '1') {
                    $mail = new PHPMailer();
    
                    try {
                        //Server settings
                        // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                        $mail->isSMTP();                                            //Send using SMTP
                        $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                        $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                        $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                        $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                        $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                    
                        //Recipients
                        $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                        $mail->addAddress($email, $company_name);     //Add a recipient
                        // $mail->addAddress('ellen@example.com');               //Name is optional
                        $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                    
                        //Content
                        $mail->isHTML(true);                                  //Set email format to HTML
                        $mail->Subject = $subject;
                        $mail->Body    = $message;
                        // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                    
                        $mail->send();
                        // echo 'Message has been sent';
                    } catch (Exception $e) {
                        echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                        exit;
                    }
                }

                // echo $message;

                // exit;
            }

            echo json_encode(array("status" => "success"));
        }else {
            echo json_encode(array("status" => "error"));
        }
    }
    if(isset($_POST['action']) && $_POST['action'] == 'OFFER_PRICE_UPDATE') {
       
        $item_id = $_POST['item_id'];
        $product_price = $_POST['total_price'];
        $vat_input = $_POST['vat_status'];
        $delivery_price = !empty($_POST['delivery_price']) ? $_POST['delivery_price'] : 0;
        $delivery_date = !empty($_POST['delivery_date']) ? $_POST['delivery_date'] : null;
        $payment_term = !empty($_POST['payment_term']) ? $_POST['payment_term'] : null;

        $ip = get_client_ip();
        $locationInfo = getCurrencyAndDateFormatByIp($ip);

        $notifications->updateOfferItemUpdate($item_id, $product_price, $vat_input, $delivery_price, $delivery_date, $payment_term, $locationInfo["currency"]);
        echo json_encode(array("status" => "success"));
    }

    if(isset($_POST['action']) && $_POST['action'] == 'markNotification') {
        $user_id = $_SESSION['user_id'];
        $notif_id = $_POST['notif_id'];
        $type = $_POST['type'];

        $res = $notifications->markNotification($user_id, $notif_id, $type);

        if($res) {
            echo json_encode(array("status" => "success"));
        }else {
            echo json_encode(array("status" => "error"));
        }
    }

    if(isset($_POST['action']) && $_POST['action'] == 'getUnreadMessages') {
        $user_id = $_SESSION['user_id'];

        $res =  $notifications->getUnreadMessages($user_id);

        echo json_encode($res);
    }

    if(isset($_POST['action']) && $_POST['action'] == 'checkNewNotifications') {
        $user_id = $_SESSION['user_id'];
        $last_id = $_POST['last_id'];

        $res = $notifications->checkSellerNotifications($user_id, $last_id);

        // echo json_encode($res);

        if($res) {
            echo json_encode(array("is_found" => true));
        }else {
            echo json_encode(array("is_found" => false));
        }
    }
    
    if(isset($_POST['action']) && $_POST['action'] == 'loadMoreNotifications') {
        $user_id = $_SESSION['user_id'];
        $last_id = $_POST['last_id'];

        $res = $notifications->loadMoreNotifications($user_id, $last_id);

        if($res) {
            echo json_encode($res);
        }else {
            echo json_encode(array("has_result" => false));
        }
    }

    if(isset($_POST['action']) && $_POST['action'] == 'getNewSellerNotifications') {
        $user_id = $_SESSION['user_id'];
        $last_id = $_POST['last_id'];

        $res = $notifications->getNewSellerNotifications($user_id, $last_id);

        if($res) {
            echo json_encode($res);
        }else {
            echo json_encode(array("status" => false));
        }
    }

    // Buyer
    if(isset($_POST['action']) && $_POST['action'] == 'checkNewBuyerNotifications') {
        $user_id = $_SESSION['user_id'];
        $first_id = $_POST['first_id'];

        $res = $notifications->checkBuyerNotifications($user_id, $first_id);

        if($res) {
            echo json_encode(array("is_found" => true));
        }else {
            echo json_encode(array("is_found" => false));
        }
    }

    if(isset($_POST['action']) && $_POST['action'] == 'getNewBuyerNotifications') {
        $user_id = $_SESSION['user_id'];
        $last_id = $_POST['last_id'];

        $res = $notifications->getNewBuyerNotifications($user_id, $last_id);

        if($res) {
            echo json_encode($res);
        }else {
            echo json_encode(array("status" => false));
        }
    }

    if(isset($_POST['action']) && $_POST['action'] == 'loadMoreBuyerNotifications') {
        $user_id = $_SESSION['user_id'];
        $last_id = $_POST['last_id'];

        $res = $notifications->loadMoreBuyerNotifications($user_id, $last_id);

        if($res) {
            echo json_encode($res);
        }else {
            echo json_encode(array("has_result" => false));
        }
    }

    if(isset($_POST['action']) && $_POST['action'] == 'markBuyerNotification') {
        $user_id = $_SESSION['user_id'];
        $offer_id = $_POST['offer_id'];
        $type = $_POST['type'];

        $res = $notifications->markBuyerNotification($user_id, $offer_id, $type);

        if($res) {
            echo json_encode(array("status" => "success"));
        }else {
            echo json_encode(array("status" => "error"));
        }
    }

    function get_client_ip() {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }
    function getCurrencyAndDateFormatByIp($ip) {
        // Using geoPlugin API for geolocation
        $url = "http://www.geoplugin.net/json.gp?ip={$ip}";
    
        // Initialize cURL session
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
    
        // Decode the JSON response
        $data = json_decode($response, true);
    
        if (isset($data['geoplugin_countryCode'])) {
            $countryCode = $data['geoplugin_countryCode'];
            $currency = getCurrencyByCountry($countryCode);
    
            return [
                'country' => $countryCode,
                'currency' => $currency,
            ];
        } else {
            return null; // If country information is not available
        }
    }
    function getCurrencyByCountry($countryCode) {
        // Currency symbols mapped to countries
        $currencyMap = [
            'US' => '$',  // USD
            'GB' => '£',  // GBP
            'IN' => '₹',  // INR
            'CA' => '$',  // CAD
            'AU' => '$',  // AUD
            'PK' => '₨',  // PKR
            'DE' => '€',  // EUR
            'FR' => '€',  // EUR
            'IT' => '€',  // EUR
            'ES' => '€',  // EUR
            'CN' => '¥',  // CNY
            'JP' => '¥',  // JPY
            'BR' => 'R$', // BRL
            'MX' => '$',  // MXN
            'RU' => '₽',  // RUB
            'KR' => '₩',  // KRW
            'SG' => '$',  // SGD
            'ZA' => 'R',  // ZAR
            'SE' => 'kr', // SEK
            'IL' => '₪',  // ILS (Israeli New Shekel)
        ];
    
        return isset($currencyMap[$countryCode]) ? $currencyMap[$countryCode] : null;
    }
?>